/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kaanha.reports.helper.Utils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.util.DateFormatConverter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class DateUtils {
    public static final String DEFAULT_DATE_PATTERN = "MMM dd, yyyy";
    public static final String TABLEAU_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String JS_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String JIRA_LONG_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final ThreadLocal<DateFormat> sdfSprint = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        }
    };
    private static final ThreadLocal<DateFormat> jsDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.JS_DATE_PATTERN);
        }
    };
    public static final ThreadLocal<DateFormat> sdfJiraLongDate = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.JIRA_LONG_DATE_PATTERN);
        }
    };
    private static final ThreadLocal<DateFormat> sdfTimesheet = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.DEFAULT_DATE_PATTERN);
        }
    };
    private static final ThreadLocal<DateFormat> sdfTimesheetDay = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE");
        }
    };
    private static final ThreadLocal<DateFormat> sdfTimesheetDate = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MMM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> sdfyyyyMMdd = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> sdfDayMonthDateTimeYear = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
        }
    };
    private static final Map<String, ThreadLocal<DateFormat>> dateFormatters = Maps.newLinkedHashMap();
    private static final Map<String, String> javaExcelPatternMap = Maps.newHashMap();

    public static Set<Date> datesBetween(String startDate, String endDate) throws ParseException {
        Date start = jsDateFormat.get().parse(startDate);
        Date end = jsDateFormat.get().parse(endDate);
        TreeSet dates = Sets.newTreeSet();
        while (!start.after(end)) {
            dates.add(start);
            start = DateUtils.addDays(start, 1);
        }
        return dates;
    }

    public static Date applyTimezone(String strDate, String timezone) throws ParseException {
        boolean applyZone = true;
        Date out = null;
        if (StringUtils.isNotBlank((CharSequence)strDate) && !StringUtils.equals((CharSequence)strDate, (CharSequence)"-") && !StringUtils.contains((CharSequence)strDate, (CharSequence)"-;") && StringUtils.indexOf((CharSequence)strDate, (CharSequence)"null") == -1) {
            try {
                out = sdfJiraLongDate.get().parse(strDate);
            }
            catch (Exception e2) {
                try {
                    out = sdfJiraLongDate.get().parse(strDate);
                }
                catch (ParseException e1) {
                    try {
                        out = sdfSprint.get().parse(strDate);
                    }
                    catch (ParseException e22) {
                        try {
                            out = sdfyyyyMMdd.get().parse(strDate);
                            applyZone = false;
                        }
                        catch (ParseException e3) {
                            out = sdfDayMonthDateTimeYear.get().parse(strDate);
                        }
                    }
                }
            }
            if (applyZone && StringUtils.isNotBlank((CharSequence)timezone)) {
                out = DateUtils.applyTimezone(out, timezone);
            }
        }
        return out;
    }

    public static Date applyTimezone(Date date, String timezone) throws ParseException {
        if (date != null && StringUtils.isNotBlank((CharSequence)timezone)) {
            SimpleDateFormat tzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            TimeZone tz = TimeZone.getTimeZone(timezone);
            tzFormat.setTimeZone(tz);
            String strDate = tzFormat.format(date);
            SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = outFormat.parse(strDate);
        }
        return date;
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static String getTimesheetDay(String strDate, String pattern, String endDate, String startDate) throws ParseException {
        if (DEFAULT_DATE_PATTERN.equals(pattern)) {
            Date dt2 = sdfTimesheet.get().parse(strDate);
            String day = sdfTimesheetDay.get().format(dt2);
            if ("sat".equalsIgnoreCase(day) || "sun".equalsIgnoreCase(day)) {
                return day.substring(0, 2);
            }
            return day.substring(0, 1);
        }
        if ("w-yyyy".equals(pattern)) {
            Date sDate = jsDateFormat.get().parse(startDate);
            Date sdt = DateUtils.formatterForPattern(pattern).parse(strDate);
            if (sdt.before(sDate)) {
                sdt = sDate;
            }
            Date eDate = jsDateFormat.get().parse(endDate);
            Date edt = DateUtils.formatterForPattern(pattern).parse(strDate);
            if ((edt = DateUtils.addDays(edt, 6)).after(eDate)) {
                edt = eDate;
            }
            return sdfTimesheetDate.get().format(sdt) + "\n" + sdfTimesheetDate.get().format(edt);
        }
        if ("MMM-yyyy".equals(pattern)) {
            Date dt3 = DateUtils.formatterForPattern(pattern).parse(strDate);
            return DateUtils.format(dt3, "MMMM");
        }
        return strDate;
    }

    public static String getTimesheetDate(String strDate, String pattern, String startDate) throws ParseException {
        if (DEFAULT_DATE_PATTERN.equals(pattern)) {
            Date dt2 = sdfTimesheet.get().parse(strDate);
            return sdfTimesheetDate.get().format(dt2).replace("-", "\n");
        }
        if ("w-yyyy".equals(pattern)) {
            Date sDate = jsDateFormat.get().parse(startDate);
            Date dt3 = DateUtils.formatterForPattern(pattern).parse(strDate);
            if (dt3.before(sDate)) {
                dt3 = sDate;
            }
            return "Wk " + DateUtils.formatterForPattern("w").format(dt3);
        }
        if ("MMM-yyyy".equals(pattern)) {
            Date dt4 = DateUtils.formatterForPattern(pattern).parse(strDate);
            return DateUtils.format(dt4, "yyyy");
        }
        return "";
    }

    public static boolean isWeekend(String day) {
        return day.equalsIgnoreCase("sa") || day.equalsIgnoreCase("su");
    }

    public static double daysBetweenNow(Date date) {
        return DateUtils.daysBetween(new Date(), date);
    }

    public static double daysBetween(Date endDate, Date startDate) {
        double diff = (double)(endDate.getTime() - startDate.getTime()) * 1.0 / 8.64E7 * 1.0;
        double days = Utils.round(diff);
        if (days < 0.0) {
            days = -days;
        }
        return days;
    }

    public static double businessDaysBetween(Date end, Date start) {
        Calendar c1 = GregorianCalendar.getInstance();
        c1.setTime(start);
        int w1 = c1.get(7);
        c1.add(7, -w1 + 1);
        Calendar c2 = GregorianCalendar.getInstance();
        c2.setTime(end);
        int w2 = c2.get(7);
        c2.add(7, -w2 + 1);
        double days = (double)(c2.getTimeInMillis() - c1.getTimeInMillis()) * 1.0 / 8.64E7 * 1.0;
        double daysWithoutSunday = days - days * 2.0 / 7.0;
        if (w1 == 1) {
            w1 = 2;
        }
        if (w2 == 1) {
            w2 = 2;
        }
        if (daysWithoutSunday < 0.0) {
            ++w2;
        }
        return Utils.round(daysWithoutSunday - (double)w1 + (double)w2);
    }

    public static String convertFormat(String date, String srcFormat, String destFormat) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)date)) {
            DateFormat sdf = DateUtils.formatterForPattern(srcFormat);
            Date d2 = sdf.parse(date);
            DateFormat sdf2 = DateUtils.formatterForPattern(destFormat);
            return sdf2.format(d2);
        }
        return date;
    }

    public static DateFormat formatterForPattern(String inPattern) {
        final String pattern = DateUtils.sanitizePattern(inPattern);
        ThreadLocal<DateFormat> tsdf = dateFormatters.get(pattern);
        if (tsdf == null) {
            tsdf = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    SimpleDateFormat _sdf = new SimpleDateFormat(pattern);
                    if ("w-yyyy".equals(pattern) || "w".equals(pattern) || "W".equals(pattern)) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setFirstDayOfWeek(2);
                        _sdf.setCalendar(calendar);
                    }
                    return _sdf;
                }
            };
            dateFormatters.put(pattern, tsdf);
        }
        return tsdf.get();
    }

    public static Date toDate(String strDate, String pattern) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)strDate)) {
            if ("Quarter".equalsIgnoreCase(pattern)) {
                Calendar c2 = Calendar.getInstance();
                c2.setTime(new Date());
                c2.set(5, 1);
                c2.set(1, Integer.parseInt(strDate.substring(strDate.indexOf("'") + 1)));
                if (strDate.startsWith("Q1 (Jan-Mar)")) {
                    c2.set(2, 0);
                }
                if (strDate.startsWith("Q2 (Apr-Jun)")) {
                    c2.set(2, 3);
                }
                if (strDate.startsWith("Q3 (Jul-Sep)")) {
                    c2.set(2, 6);
                }
                if (strDate.startsWith("Q4 (Oct-Dec)")) {
                    c2.set(2, 9);
                }
                return c2.getTime();
            }
            return DateUtils.formatterForPattern(pattern).parse(strDate);
        }
        return null;
    }

    public static Date jsToJava(String strDate) throws ParseException {
        return jsDateFormat.get().parse(strDate);
    }

    public static Date removeTime(Date date) {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date);
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return c2.getTime();
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if ("Quarter".equalsIgnoreCase(pattern)) {
            return DateUtils.getQuarterForDate(date);
        }
        return DateUtils.formatterForPattern(pattern).format(date);
    }

    public static String getExcelDatePatternForJavaDatePattern(String javaDatePattern) {
        if (javaExcelPatternMap.containsKey(javaDatePattern)) {
            return javaExcelPatternMap.get(javaDatePattern);
        }
        javaDatePattern = DateUtils.sanitizePattern(javaDatePattern);
        String excelDatePattern = DateFormatConverter.convert(Locale.getDefault(), javaDatePattern);
        excelDatePattern = StringUtils.replace((String)excelDatePattern, (String)"aaa", (String)"AM/PM");
        excelDatePattern = StringUtils.replace((String)excelDatePattern, (String)"eee", (String)"aaa");
        javaExcelPatternMap.put(javaDatePattern, excelDatePattern);
        return excelDatePattern;
    }

    private static String sanitizePattern(String javaDatePattern) {
        if (javaDatePattern.indexOf("[") > -1) {
            javaDatePattern = StringUtils.strip((String)javaDatePattern.substring(0, javaDatePattern.indexOf("[")));
        }
        return javaDatePattern;
    }

    public static String javaTojs(String date) throws ParseException {
        return jsDateFormat.get().format(sdfyyyyMMdd.get().parse(date));
    }

    public static Date convertToUTC(Date date, String timezone) {
        if (StringUtils.isBlank((CharSequence)timezone) || date == null) {
            return date;
        }
        TimeZone tz = TimeZone.getTimeZone(timezone);
        date = new Date(date.getTime() - (long)tz.getRawOffset() - (long)(tz.inDaylightTime(date) ? tz.getDSTSavings() : 0));
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(date.getTime() + (long)c2.get(15) + (long)c2.get(16));
        return c2.getTime();
    }

    public static Date convertToLocal(Date date, String timezone) {
        if (StringUtils.isBlank((CharSequence)timezone) || date == null) {
            return date;
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(date.getTime() - (long)c2.get(15) - (long)c2.get(16));
        TimeZone tz = TimeZone.getTimeZone(timezone);
        return new Date(c2.getTimeInMillis() + (long)tz.getRawOffset() + (long)(tz.inDaylightTime(c2.getTime()) ? tz.getDSTSavings() : 0));
    }

    public static String getQuarterForDate(Date dt2) {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(dt2);
        int month = c2.get(2);
        String quarter = month >= 0 && month <= 2 ? "Q1 (Jan-Mar)" : (month >= 3 && month <= 5 ? "Q2 (Apr-Jun)" : (month >= 6 && month <= 8 ? "Q3 (Jul-Sep)" : "Q4 (Oct-Dec)"));
        return quarter + "'" + c2.get(1);
    }

    public static Date maxTime(Date date) {
        date = DateUtils.removeTime(date);
        date = DateUtils.addDays(date, 1);
        date = new Date(date.getTime() - 1L);
        return date;
    }

    public static double hoursBetween(Date endDate, Date startDate) {
        return (endDate.getTime() - startDate.getTime()) / 3600000L;
    }

    public static void setTimeFromDate(Date src, Date dest) {
        Calendar calSrc = Calendar.getInstance();
        calSrc.setTime(src);
        Calendar calDest = Calendar.getInstance();
        calDest.setTime(dest);
        calDest.set(11, calSrc.get(11));
        calDest.set(12, calSrc.get(12));
        calDest.set(13, calSrc.get(13));
        calDest.set(14, calSrc.get(14));
        dest.setTime(calDest.getTimeInMillis());
    }

    public static Date dateWithTime(String hour, String amPm) {
        Calendar c2 = Calendar.getInstance();
        int h2 = Integer.parseInt(hour);
        if ("pm".equals(amPm)) {
            h2 += 12;
        }
        c2.set(11, h2);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return c2.getTime();
    }

    public static LocalDate timezoneLocalDate(String timezone) {
        DateTimeZone zone = DateTimeZone.forID((String)timezone);
        LocalDate now = new LocalDate(zone);
        return now;
    }
}

