/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kaanha.reports.model.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataMigrationUtils {
    static Map<String, String> datePatternMap = Maps.newHashMap();
    static Map<String, String> aioFieldMap = Maps.newHashMap();

    public static List<Field> converStringToField(List<String> fieldIds) {
        ArrayList out = Lists.newArrayList();
        for (String fieldId : fieldIds) {
            Field f2 = new Field();
            if (DataMigrationUtils.isDate(fieldId)) {
                String pattern = DataMigrationUtils.getPattern(fieldId.substring(fieldId.lastIndexOf("_") + 1));
                if (StringUtils.isBlank((CharSequence)pattern)) continue;
                f2.setPattern(pattern);
                fieldId = fieldId.substring(0, fieldId.lastIndexOf("_"));
            }
            if (DataMigrationUtils.isAggregate(fieldId)) {
                String aggFunc = fieldId.substring(fieldId.lastIndexOf("_") + 1);
                f2.setAggregateFunction(aggFunc);
                f2.setAggregate(true);
                fieldId = fieldId.substring(0, fieldId.lastIndexOf("_"));
            }
            if (aioFieldMap.containsKey(fieldId)) {
                if ("aio_count".equals(fieldId = aioFieldMap.get(fieldId))) {
                    f2.setAggregate(true);
                    f2.setAggregateFunction("COUNT");
                }
                if ("aio_count_percent".equals(fieldId)) {
                    f2.setAggregate(true);
                    f2.setAggregateFunction("");
                }
            }
            f2.setId(fieldId);
            out.add(f2);
        }
        return out;
    }

    public static boolean isAggregate(String fieldId) {
        return fieldId.endsWith("_SUM") || fieldId.endsWith("_AVG");
    }

    public static String getPattern(String pattern) {
        return datePatternMap.get(pattern);
    }

    public static boolean isDate(String fieldId) {
        return fieldId.endsWith("_LONGDATE") || fieldId.endsWith("_YEAR") || fieldId.endsWith("_MONTH") || fieldId.endsWith("_WEEK") || fieldId.endsWith("_TIME") || fieldId.endsWith("_HOUR") || fieldId.endsWith("_MINUTE");
    }

    public static List<Field> converStringToField(String fields) {
        if (fields != null) {
            return DataMigrationUtils.converStringToField(Lists.newArrayList((Object[])fields.split(",")));
        }
        return null;
    }

    public static List<String> splitAndRemoveDoubleQuotes(String in2) {
        String[] _in;
        if (StringUtils.isBlank((CharSequence)in2)) {
            return null;
        }
        ArrayList out = Lists.newArrayList();
        for (String _s : _in = in2.split(",")) {
            String _stripped = _s.replaceAll("\"", "");
            if (_stripped.equals("All")) continue;
            out.add(_stripped);
        }
        return out;
    }

    public static String convertDateRangeDesc(String dateRangeDesc) {
        if (StringUtils.isBlank((CharSequence)dateRangeDesc)) {
            return null;
        }
        if (dateRangeDesc.equals("Custom")) {
            return "custom";
        }
        if (dateRangeDesc.equals("This Week")) {
            return "current_week";
        }
        if (dateRangeDesc.equals("Last Month")) {
            return "last_month";
        }
        if (dateRangeDesc.equals("This Month")) {
            return "current_month";
        }
        if (dateRangeDesc.equals("Last Week")) {
            return "last_week";
        }
        return null;
    }

    static {
        datePatternMap.put("LONGDATE", "MM/dd/yy HH:mm:ss");
        datePatternMap.put("YEAR", "yyyy");
        datePatternMap.put("MONTH", "MMM-yy");
        datePatternMap.put("WEEK", "w");
        aioFieldMap.put("X_PERCENT", "aio_count_percent");
        aioFieldMap.put("X_COUNT", "aio_count");
        aioFieldMap.put("age", "aio_age");
        aioFieldMap.put("resolutiontime", "aio_resolutiontime");
        aioFieldMap.put("watches", "watches_watchCount");
        aioFieldMap.put("fixVersions", "fixVersions_name");
        aioFieldMap.put("project", "project_name");
        aioFieldMap.put("project_category", "project_projectCategory.name");
        aioFieldMap.put("worklog_author", "worklog_author.displayName");
        aioFieldMap.put("worklog_author_username", "worklog_author.name");
        aioFieldMap.put("worklog_author_userkey", "worklog_author.key");
    }
}

