/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.exception;

import com.kaanha.reports.connect.AtlassianConnectContextParams;
import com.kaanha.reports.connect.ConnectUtils;
import com.kaanha.reports.exception.AjaxException;
import com.kaanha.reports.exception.InvalidAccessCodeException;
import com.kaanha.reports.exception.InvalidJQLException;
import com.kaanha.reports.exception.InvalidTableauURLException;
import com.kaanha.reports.exception.LicenseExpiredException;
import com.kaanha.reports.exception.MultipleTenantsFoundException;
import com.kaanha.reports.exception.ReportNotFoundException;
import com.kaanha.reports.exception.SessionExpiredException;
import com.kaanha.reports.exception.TenantNotFoundException;
import com.kaanha.reports.exception.UserNotLoggedInException;
import com.kaanha.reports.service.EmailService;
import com.kaanha.reports.servlet.PlatformTypeEnum;
import com.kaanha.reports.servlet.ViewRenderer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ExceptionHandler {
    static Logger logger = Logger.getLogger(ExceptionHandler.class);

    public static void showErrorPage(Exception e2, ViewRenderer viewRenderer, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String message = "The application has encountered an unknown error. Please try again later.";
            Exception rootException = e2;
            if (e2 instanceof AjaxException) {
                rootException = ((AjaxException)e2).getE();
            }
            if (ExceptionHandler.knownException(rootException)) {
                message = e2.getMessage();
            }
            if (!ExceptionHandler.exempted(rootException, request)) {
                logger.error((Object)rootException.getMessage(), (Throwable)rootException);
                if (viewRenderer != null && PlatformTypeEnum.CLOUD.equals((Object)viewRenderer.getPlatformType())) {
                    String prepend = "";
                    String postData = null;
                    try {
                        AtlassianConnectContextParams atlassianConnectContextParams = ConnectUtils.extractAtlassianParamsFromRequest(request);
                        prepend = prepend + atlassianConnectContextParams.toString();
                        prepend = prepend + ExceptionHandler.getRequestDump(request);
                        if (e2 instanceof AjaxException) {
                            postData = "\npostData:" + ((AjaxException)e2).getPostData();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    new EmailService().sendErrorEmail(rootException, prepend, postData);
                }
            }
            if (e2 instanceof AjaxException) {
                response.setStatus(500);
                response.getOutputStream().print(message);
            } else if (viewRenderer != null) {
                viewRenderer.renderView(request, response, "/error", null, message);
            } else {
                response.setStatus(500);
                response.getOutputStream().print(message);
            }
        }
        catch (Exception ex2) {
            logger.error((Object)ex2.getMessage(), (Throwable)ex2);
            throw new ServletException((Throwable)e2);
        }
    }

    private static boolean exempted(Exception rootException, HttpServletRequest request) {
        if (rootException instanceof UserNotLoggedInException || rootException instanceof TenantNotFoundException || rootException instanceof ReportNotFoundException || rootException instanceof LicenseExpiredException || rootException instanceof SessionExpiredException || rootException instanceof OpenXML4JRuntimeException || rootException instanceof ResourceNotFoundException) {
            return true;
        }
        if (rootException != null && rootException.getMessage() != null) {
            return rootException.getMessage().contains("Unrecognized token") || rootException.getMessage().contains("Unexpected end-of-input") || rootException.getMessage().contains("Broken pipe") || rootException.getMessage().contains("Unable to find resource");
        }
        return request.getHeader("referer") != null && request.getHeader("referer").startsWith("https://www.jirareports.com/jr/aio/view/dashboard?dashboard") && rootException instanceof NullPointerException;
    }

    private static boolean knownException(Exception e2) {
        return e2 instanceof LicenseExpiredException || e2 instanceof MultipleTenantsFoundException || e2 instanceof ReportNotFoundException || e2 instanceof TenantNotFoundException || e2 instanceof UserNotLoggedInException || e2 instanceof SessionExpiredException || e2 instanceof InvalidTableauURLException || e2 instanceof InvalidJQLException || e2 instanceof InvalidAccessCodeException;
    }

    private static String getRequestDump(HttpServletRequest request) {
        StringBuffer dump = new StringBuffer();
        dump.append("\nURL: " + request.getRequestURL() + "\n");
        dump.append("QueryString: " + request.getQueryString() + "\n");
        dump.append("Headers**************************************\n");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            dump.append(headerName + ":" + request.getHeader(headerName) + "\n");
        }
        dump.append("Method :" + request.getMethod() + "\n");
        dump.append("Params**************************************\n");
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            dump.append(paramName + ":" + request.getParameter(paramName) + "\n");
        }
        return dump.toString();
    }
}

