/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.connect;

import com.kaanha.reports.connect.ConnectionParams;
import com.kaanha.reports.connect.Connector;
import com.kaanha.reports.exception.AuthenticationException;
import com.kaanha.reports.exception.CaptchaRequiredException;
import com.kaanha.reports.exception.SearchException;
import com.kaanha.reports.service.EmailService;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public final class RestConnector
implements Connector {
    private final int connectTimeoutMillis = 30000;
    private static final Logger logger = LogManager.getLogger((String)RestConnector.class.getName());
    private static RestConnector instance = null;
    EmailService emailService;

    private RestConnector() throws Exception {
        RestConnector.trustAllCertificates();
        this.emailService = new EmailService();
    }

    public static RestConnector getInstance() throws Exception {
        if (instance == null) {
            instance = new RestConnector();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnectionParams connectionParams) throws MalformedURLException, IOException, AuthenticationException, CaptchaRequiredException {
        HttpURLConnection connection = null;
        try {
            connection = this.getAuthenticatedConnection(connectionParams);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 401: {
                    throw new AuthenticationException();
                }
                case 403: {
                    throw new CaptchaRequiredException();
                }
            }
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(ConnectionParams connectionParams, String path) throws Exception {
        HttpURLConnection connection = null;
        try {
            connection = this.getAuthenticatedConnection(connectionParams, path);
            this.doGet(connection);
            String string = this.readHttpResponse(connection);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void doGet(HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(ConnectionParams connectionParams, String path, String postData) throws Exception {
        HttpURLConnection connection = null;
        path = path.replace("restlocal", "rest");
        try {
            connection = this.getAuthenticatedConnection(connectionParams, path);
            this.doPost(connection, postData);
            String string = this.readHttpResponse(connection);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void doPost(HttpURLConnection connection, String postData) throws ProtocolException, IOException {
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(postData);
        wr.flush();
        wr.close();
    }

    public String readHttpResponse(HttpURLConnection connection) throws Exception {
        String line;
        BufferedReader rd;
        try {
            rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (IOException e2) {
            rd = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        }
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rd.close();
        String result = response.toString();
        this.validateResponse(result);
        return result;
    }

    private HttpURLConnection getAuthenticatedConnection(ConnectionParams connectionParams) throws MalformedURLException, IOException {
        return this.getAuthenticatedConnection(connectionParams, null);
    }

    private HttpURLConnection getAuthenticatedConnection(ConnectionParams connectionDetails, String path) throws IOException, MalformedURLException {
        HttpURLConnection connection = this.getHttpURLConnection(connectionDetails, path);
        String encoded = new String(Base64.getEncoder().encodeToString((connectionDetails.getUsername() + ":" + connectionDetails.getPassword()).getBytes()));
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTargetReachable(ConnectionParams connectionDetails) {
        HttpURLConnection connection = null;
        try {
            connection = this.getHttpURLConnection(connectionDetails);
            int responseCode = connection.getResponseCode();
            boolean bl2 = 200 <= responseCode && responseCode <= 399;
            return bl2;
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection getHttpURLConnection(ConnectionParams connectionDetails) throws MalformedURLException, IOException {
        return this.getHttpURLConnection(connectionDetails, null);
    }

    private HttpURLConnection getHttpURLConnection(ConnectionParams connectionDetails, String path) throws IOException, MalformedURLException {
        String urlToCall = StringUtils.isEmpty((Object)path) ? connectionDetails.getURL() : connectionDetails.getURL() + path;
        HttpURLConnection connection = (HttpURLConnection)new URL(urlToCall).openConnection();
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        return connection;
    }

    private static void trustAllCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    public void validateResponse(String result) throws SearchException, Exception {
        if (org.apache.commons.lang3.StringUtils.contains((CharSequence)result, (CharSequence)"errorMessages")) {
            throw new SearchException(result);
        }
    }
}

