/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.connect;

import com.kaanha.reports.connect.ConnectionParams;
import com.kaanha.reports.exception.EmptyURLException;
import com.kaanha.reports.exception.LocalURLException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class RestConnectionParams
implements ConnectionParams {
    private String url;
    private String username;
    private String password;
    private final String DEFAULT_PROTOCOL = "https://";
    private static final Logger logger = LogManager.getLogger((String)RestConnectionParams.class.getName());

    @Override
    public void setURL(String url) throws MalformedURLException {
        URL httpURL;
        if (StringUtils.isEmpty((Object)url)) {
            throw new EmptyURLException();
        }
        if ((url = url.toLowerCase()).contains("localhost") || url.contains("127.0.0.1")) {
            throw new LocalURLException(url);
        }
        try {
            httpURL = new URL(url);
        }
        catch (MalformedURLException mex) {
            if (mex.getMessage().contains("no protocol") || mex.getMessage().contains("unknown protocol")) {
                url = "https://" + url;
            }
            httpURL = new URL(url);
        }
        int port = httpURL.getPort();
        this.url = httpURL.getProtocol() + "://" + httpURL.getHost() + (port != -1 ? ":" + httpURL.getPort() : "");
        logger.debug((Object)this.url);
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }
}

