/*
 * Decompiled with CFR 0.152.
 */
package com.kaanha.reports.connect;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kaanha.reports.connect.JWT;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.crypto.MACVerifier;
import java.io.IOException;
import java.text.ParseException;
import net.minidev.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class JWTHandler {
    ObjectMapper mapper = new ObjectMapper();

    public JWT toObject(String jwt) throws JsonParseException, JsonMappingException, IOException, ParseException {
        JWSObject jwsObject = JWSObject.parse(jwt);
        JSONObject jsonPayload = jwsObject.getPayload().toJSONObject();
        JWT o2 = this.mapper.readValue(jsonPayload.toString(), JWT.class);
        return o2;
    }

    public boolean validate(String jwt, String sharedSecret) throws ParseException, JOSEException {
        MACVerifier verifier = new MACVerifier(sharedSecret);
        JWSObject jwsObject = JWSObject.parse(jwt);
        return jwsObject.verify(verifier);
    }
}

