/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.struc;

public class Bag {
    protected Object[] data = null;
    protected int size = 0;

    public Bag() {
        this.data = new Object[2];
    }

    public Bag(int initialCapacity) {
        this.data = new Object[initialCapacity];
    }

    public Bag(Object[] data, int size) {
        if (data == null) {
            throw new IllegalArgumentException("data array cannot be null.");
        }
        if (size < 0 || size > data.length) {
            throw new IllegalArgumentException("required: (size >= 0 && size <= data.length) but: (size = " + size + ", data.length = " + data.length + ")");
        }
        this.data = data;
        this.size = size;
    }

    public void add(Object o2) {
        this.insert(o2, this.size);
    }

    public int size() {
        return this.size;
    }

    public void setSize(int s2) {
        if (s2 < 0 || s2 > this.data.length) {
            throw new IllegalArgumentException("required: (size >= 0 && size <= data.length) but: (size = " + this.size + ", data.length = " + this.data.length + ")");
        }
        this.size = s2;
    }

    public void insert(Object o2, int index) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index <= size) but: (index = " + index + ", size = " + this.size + ")");
        }
        this.ensureCapacity(this.size + 1);
        for (int i2 = this.size; i2 > index; --i2) {
            this.data[i2] = this.data[i2 - 1];
        }
        this.data[index] = o2;
        ++this.size;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            int x2 = 2 * this.data.length;
            if (x2 < capacity) {
                x2 = capacity;
            }
            Object[] arr = new Object[x2];
            for (int i2 = 0; i2 < this.size; ++i2) {
                arr[i2] = this.data[i2];
            }
            this.data = arr;
        }
    }

    public int getCapacity() {
        return this.data.length;
    }

    private int find(Object o2, int i2, boolean forward) {
        if (i2 < 0 || i2 >= this.size) {
            return -1;
        }
        if (forward) {
            if (o2 == null) {
                while (i2 < this.size) {
                    if (this.data[i2] == null) {
                        return i2;
                    }
                    ++i2;
                }
            } else {
                while (i2 < this.size) {
                    if (o2.equals(this.data[i2])) {
                        return i2;
                    }
                    ++i2;
                }
            }
        } else if (o2 == null) {
            while (i2 >= 0) {
                if (this.data[i2] == null) {
                    return i2;
                }
                --i2;
            }
        } else {
            while (i2 >= 0) {
                if (o2.equals(this.data[i2])) {
                    return i2;
                }
                --i2;
            }
        }
        return -1;
    }

    public int remove(Object o2) {
        int i2 = this.find(o2, 0, true);
        if (i2 >= 0) {
            this.remove(i2);
        }
        return i2;
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        Object o2 = this.data[index];
        for (int i2 = index + 1; i2 < this.size; ++i2) {
            this.data[i2 - 1] = this.data[i2];
        }
        this.data[--this.size] = null;
        return o2;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        return this.data[index];
    }

    public Object set(Object o2, int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        Object old = this.data[index];
        this.data[index] = o2;
        return old;
    }

    public boolean contains(Object o2) {
        return this.find(o2, 0, true) >= 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trimArray() {
        if (this.size < this.data.length) {
            Object[] arr = new Object[this.size];
            for (int i2 = 0; i2 < this.size; ++i2) {
                arr[i2] = this.data[i2];
            }
            this.data = arr;
        }
    }

    public int indexOf(Object o2) {
        return this.find(o2, 0, true);
    }

    public int indexOf(Object o2, int startIndex) {
        return this.find(o2, startIndex, true);
    }

    public int lastIndexOf(Object o2) {
        return this.find(o2, this.size - 1, false);
    }

    public int lastIndexOf(Object o2, int startIndex) {
        return this.find(o2, startIndex, false);
    }
}

