/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.org.apache.harmony.awt.gl;

import java.awt.Shape;
import java.awt.geom.PathIterator;

public class Crossing {
    static final double DELTA = 1.0E-5;
    static final double ROOT_DELTA = 1.0E-10;
    public static final int CROSSING = 255;
    static final int UNKNOWN = 254;

    public static int solveQuad(double[] eqn, double[] res) {
        double a2 = eqn[2];
        double b2 = eqn[1];
        double c2 = eqn[0];
        int rc = 0;
        if (a2 == 0.0) {
            if (b2 == 0.0) {
                return -1;
            }
            res[rc++] = -c2 / b2;
        } else {
            double d2 = b2 * b2 - 4.0 * a2 * c2;
            if (d2 < 0.0) {
                return 0;
            }
            d2 = Math.sqrt(d2);
            res[rc++] = (-b2 + d2) / (a2 * 2.0);
            if (d2 != 0.0) {
                res[rc++] = (-b2 - d2) / (a2 * 2.0);
            }
        }
        return Crossing.fixRoots(res, rc);
    }

    public static int solveCubic(double[] eqn, double[] res) {
        double d2 = eqn[3];
        if (d2 == 0.0) {
            return Crossing.solveQuad(eqn, res);
        }
        double a2 = eqn[2] / d2;
        double b2 = eqn[1] / d2;
        double c2 = eqn[0] / d2;
        int rc = 0;
        double Q = (a2 * a2 - 3.0 * b2) / 9.0;
        double R = (2.0 * a2 * a2 * a2 - 9.0 * a2 * b2 + 27.0 * c2) / 54.0;
        double Q3 = Q * Q * Q;
        double R2 = R * R;
        double n2 = -a2 / 3.0;
        if (R2 < Q3) {
            double t2 = Math.acos(R / Math.sqrt(Q3)) / 3.0;
            double p2 = 2.0943951023931953;
            double m2 = -2.0 * Math.sqrt(Q);
            res[rc++] = m2 * Math.cos(t2) + n2;
            res[rc++] = m2 * Math.cos(t2 + p2) + n2;
            res[rc++] = m2 * Math.cos(t2 - p2) + n2;
        } else {
            double A = Math.pow(Math.abs(R) + Math.sqrt(R2 - Q3), 0.3333333333333333);
            if (R > 0.0) {
                A = -A;
            }
            if (-1.0E-10 < A && A < 1.0E-10) {
                res[rc++] = n2;
            } else {
                double B = Q / A;
                res[rc++] = A + B + n2;
                double delta = R2 - Q3;
                if (-1.0E-10 < delta && delta < 1.0E-10) {
                    res[rc++] = -(A + B) / 2.0 + n2;
                }
            }
        }
        return Crossing.fixRoots(res, rc);
    }

    static int fixRoots(double[] res, int rc) {
        int tc = 0;
        block0: for (int i2 = 0; i2 < rc; ++i2) {
            for (int j2 = i2 + 1; j2 < rc; ++j2) {
                if (Crossing.isZero(res[i2] - res[j2])) continue block0;
            }
            res[tc++] = res[i2];
        }
        return tc;
    }

    public static int crossLine(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (x3 < x1 && x3 < x2 || x3 > x1 && x3 > x2 || y3 > y1 && y3 > y2 || x1 == x2) {
            return 0;
        }
        if (!(y3 < y1 && y3 < y2 || !((y2 - y1) * (x3 - x1) / (x2 - x1) <= y3 - y1))) {
            return 0;
        }
        if (x3 == x1) {
            return x1 < x2 ? 0 : -1;
        }
        if (x3 == x2) {
            return x1 < x2 ? 1 : 0;
        }
        return x1 < x2 ? 1 : -1;
    }

    public static int crossQuad(double x1, double y1, double cx2, double cy2, double x2, double y2, double x3, double y3) {
        if (x3 < x1 && x3 < cx2 && x3 < x2 || x3 > x1 && x3 > cx2 && x3 > x2 || y3 > y1 && y3 > cy2 && y3 > y2 || x1 == cx2 && cx2 == x2) {
            return 0;
        }
        if (y3 < y1 && y3 < cy2 && y3 < y2 && x3 != x1 && x3 != x2) {
            if (x1 < x2) {
                return x1 < x3 && x3 < x2 ? 1 : 0;
            }
            return x2 < x3 && x3 < x1 ? -1 : 0;
        }
        QuadCurve c2 = new QuadCurve(x1, y1, cx2, cy2, x2, y2);
        double px = x3 - x1;
        double py = y3 - y1;
        double[] res = new double[3];
        int rc = c2.solvePoint(res, px);
        return c2.cross(res, rc, py, py);
    }

    public static int crossCubic(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double x3, double y3) {
        if (x3 < x1 && x3 < cx1 && x3 < cx2 && x3 < x2 || x3 > x1 && x3 > cx1 && x3 > cx2 && x3 > x2 || y3 > y1 && y3 > cy1 && y3 > cy2 && y3 > y2 || x1 == cx1 && cx1 == cx2 && cx2 == x2) {
            return 0;
        }
        if (y3 < y1 && y3 < cy1 && y3 < cy2 && y3 < y2 && x3 != x1 && x3 != x2) {
            if (x1 < x2) {
                return x1 < x3 && x3 < x2 ? 1 : 0;
            }
            return x2 < x3 && x3 < x1 ? -1 : 0;
        }
        CubicCurve c2 = new CubicCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
        double px = x3 - x1;
        double py = y3 - y1;
        double[] res = new double[3];
        int rc = c2.solvePoint(res, px);
        return c2.cross(res, rc, py, py);
    }

    public static int crossPath(PathIterator p2, double x2, double y2) {
        int cross = 0;
        double cy2 = 0.0;
        double cx2 = 0.0;
        double my = 0.0;
        double mx = 0.0;
        double[] coords = new double[6];
        while (!p2.isDone()) {
            switch (p2.currentSegment(coords)) {
                case 0: {
                    if (cx2 != mx || cy2 != my) {
                        cross += Crossing.crossLine(cx2, cy2, mx, my, x2, y2);
                    }
                    mx = cx2 = coords[0];
                    my = cy2 = coords[1];
                    break;
                }
                case 1: {
                    double d2 = cx2;
                    double d3 = cy2;
                    cx2 = coords[0];
                    cy2 = coords[1];
                    cross += Crossing.crossLine(d2, d3, cx2, cy2, x2, y2);
                    break;
                }
                case 2: {
                    double d4 = cx2;
                    double d5 = cy2;
                    cx2 = coords[2];
                    cy2 = coords[3];
                    cross += Crossing.crossQuad(d4, d5, coords[0], coords[1], cx2, cy2, x2, y2);
                    break;
                }
                case 3: {
                    double d6 = cx2;
                    double d7 = cy2;
                    cx2 = coords[4];
                    cy2 = coords[5];
                    cross += Crossing.crossCubic(d6, d7, coords[0], coords[1], coords[2], coords[3], cx2, cy2, x2, y2);
                    break;
                }
                case 4: {
                    if (cy2 == my && cx2 == mx) break;
                    double d8 = cx2;
                    double d9 = cy2;
                    cx2 = mx;
                    cy2 = my;
                    cross += Crossing.crossLine(d8, d9, cx2, cy2, x2, y2);
                }
            }
            if (x2 == cx2 && y2 == cy2) {
                cross = 0;
                cy2 = my;
                break;
            }
            p2.next();
        }
        if (cy2 != my) {
            cross += Crossing.crossLine(cx2, cy2, mx, my, x2, y2);
        }
        return cross;
    }

    public static int crossShape(Shape s2, double x2, double y2) {
        if (!s2.getBounds2D().contains(x2, y2)) {
            return 0;
        }
        return Crossing.crossPath(s2.getPathIterator(null), x2, y2);
    }

    public static boolean isZero(double val) {
        return -1.0E-5 < val && val < 1.0E-5;
    }

    static void sortBound(double[] bound, int bc2) {
        for (int i2 = 0; i2 < bc2 - 4; i2 += 4) {
            int k2 = i2;
            for (int j2 = i2 + 4; j2 < bc2; j2 += 4) {
                if (!(bound[k2] > bound[j2])) continue;
                k2 = j2;
            }
            if (k2 == i2) continue;
            double tmp = bound[i2];
            bound[i2] = bound[k2];
            bound[k2] = tmp;
            tmp = bound[i2 + 1];
            bound[i2 + 1] = bound[k2 + 1];
            bound[k2 + 1] = tmp;
            tmp = bound[i2 + 2];
            bound[i2 + 2] = bound[k2 + 2];
            bound[k2 + 2] = tmp;
            tmp = bound[i2 + 3];
            bound[i2 + 3] = bound[k2 + 3];
            bound[k2 + 3] = tmp;
        }
    }

    static int crossBound(double[] bound, int bc2, double py1, double py2) {
        if (bc2 == 0) {
            return 0;
        }
        int up = 0;
        int down = 0;
        for (int i2 = 2; i2 < bc2; i2 += 4) {
            if (bound[i2] < py1) {
                ++up;
                continue;
            }
            if (bound[i2] > py2) {
                ++down;
                continue;
            }
            return 255;
        }
        if (down == 0) {
            return 0;
        }
        if (up != 0) {
            Crossing.sortBound(bound, bc2);
            boolean sign = bound[2] > py2;
            for (int i3 = 6; i3 < bc2; i3 += 4) {
                boolean sign2;
                boolean bl2 = sign2 = bound[i3] > py2;
                if (sign != sign2 && bound[i3 + 1] != bound[i3 - 3]) {
                    return 255;
                }
                sign = sign2;
            }
        }
        return 254;
    }

    public static int intersectLine(double x1, double y1, double x2, double y2, double rx1, double ry1, double rx2, double ry2) {
        if (rx2 < x1 && rx2 < x2 || rx1 > x1 && rx1 > x2 || ry1 > y1 && ry1 > y2) {
            return 0;
        }
        if (!(ry2 < y1) || !(ry2 < y2)) {
            double bx2;
            double bx1;
            if (x1 == x2) {
                return 255;
            }
            if (x1 < x2) {
                bx1 = x1 < rx1 ? rx1 : x1;
                bx2 = x2 < rx2 ? x2 : rx2;
            } else {
                bx1 = x2 < rx1 ? rx1 : x2;
                bx2 = x1 < rx2 ? x1 : rx2;
            }
            double k2 = (y2 - y1) / (x2 - x1);
            double by1 = k2 * (bx1 - x1) + y1;
            double by2 = k2 * (bx2 - x1) + y1;
            if (by1 < ry1 && by2 < ry1) {
                return 0;
            }
            if (!(by1 > ry2) || !(by2 > ry2)) {
                return 255;
            }
        }
        if (x1 == x2) {
            return 0;
        }
        if (rx1 == x1) {
            return x1 < x2 ? 0 : -1;
        }
        if (rx1 == x2) {
            return x1 < x2 ? 1 : 0;
        }
        if (x1 < x2) {
            return x1 < rx1 && rx1 < x2 ? 1 : 0;
        }
        return x2 < rx1 && rx1 < x1 ? -1 : 0;
    }

    public static int intersectQuad(double x1, double y1, double cx2, double cy2, double x2, double y2, double rx1, double ry1, double rx2, double ry2) {
        int cross;
        if (rx2 < x1 && rx2 < cx2 && rx2 < x2 || rx1 > x1 && rx1 > cx2 && rx1 > x2 || ry1 > y1 && ry1 > cy2 && ry1 > y2) {
            return 0;
        }
        if (ry2 < y1 && ry2 < cy2 && ry2 < y2 && rx1 != x1 && rx1 != x2) {
            if (x1 < x2) {
                return x1 < rx1 && rx1 < x2 ? 1 : 0;
            }
            return x2 < rx1 && rx1 < x1 ? -1 : 0;
        }
        QuadCurve c2 = new QuadCurve(x1, y1, cx2, cy2, x2, y2);
        double px1 = rx1 - x1;
        double py1 = ry1 - y1;
        double px2 = rx2 - x1;
        double py2 = ry2 - y1;
        double[] res1 = new double[3];
        double[] res2 = new double[3];
        int rc1 = c2.solvePoint(res1, px1);
        int rc2 = c2.solvePoint(res2, px2);
        if (rc1 == 0 && rc2 == 0) {
            return 0;
        }
        double minX = px1 - 1.0E-5;
        double maxX = px2 + 1.0E-5;
        double[] bound = new double[28];
        int bc2 = 0;
        bc2 = c2.addBound(bound, bc2, res1, rc1, minX, maxX, false, 0);
        bc2 = c2.addBound(bound, bc2, res2, rc2, minX, maxX, false, 1);
        rc2 = c2.solveExtrem(res2);
        bc2 = c2.addBound(bound, bc2, res2, rc2, minX, maxX, true, 2);
        if (rx1 < x1 && x1 < rx2) {
            bound[bc2++] = 0.0;
            bound[bc2++] = 0.0;
            bound[bc2++] = 0.0;
            bound[bc2++] = 4.0;
        }
        if (rx1 < x2 && x2 < rx2) {
            bound[bc2++] = 1.0;
            bound[bc2++] = c2.ax;
            bound[bc2++] = c2.ay;
            bound[bc2++] = 5.0;
        }
        if ((cross = Crossing.crossBound(bound, bc2, py1, py2)) != 254) {
            return cross;
        }
        return c2.cross(res1, rc1, py1, py2);
    }

    public static int intersectCubic(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double rx1, double ry1, double rx2, double ry2) {
        int cross;
        if (rx2 < x1 && rx2 < cx1 && rx2 < cx2 && rx2 < x2 || rx1 > x1 && rx1 > cx1 && rx1 > cx2 && rx1 > x2 || ry1 > y1 && ry1 > cy1 && ry1 > cy2 && ry1 > y2) {
            return 0;
        }
        if (ry2 < y1 && ry2 < cy1 && ry2 < cy2 && ry2 < y2 && rx1 != x1 && rx1 != x2) {
            if (x1 < x2) {
                return x1 < rx1 && rx1 < x2 ? 1 : 0;
            }
            return x2 < rx1 && rx1 < x1 ? -1 : 0;
        }
        CubicCurve c2 = new CubicCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
        double px1 = rx1 - x1;
        double py1 = ry1 - y1;
        double px2 = rx2 - x1;
        double py2 = ry2 - y1;
        double[] res1 = new double[3];
        double[] res2 = new double[3];
        int rc1 = c2.solvePoint(res1, px1);
        int rc2 = c2.solvePoint(res2, px2);
        if (rc1 == 0 && rc2 == 0) {
            return 0;
        }
        double minX = px1 - 1.0E-5;
        double maxX = px2 + 1.0E-5;
        double[] bound = new double[40];
        int bc2 = 0;
        bc2 = c2.addBound(bound, bc2, res1, rc1, minX, maxX, false, 0);
        bc2 = c2.addBound(bound, bc2, res2, rc2, minX, maxX, false, 1);
        rc2 = c2.solveExtremX(res2);
        bc2 = c2.addBound(bound, bc2, res2, rc2, minX, maxX, true, 2);
        rc2 = c2.solveExtremY(res2);
        bc2 = c2.addBound(bound, bc2, res2, rc2, minX, maxX, true, 4);
        if (rx1 < x1 && x1 < rx2) {
            bound[bc2++] = 0.0;
            bound[bc2++] = 0.0;
            bound[bc2++] = 0.0;
            bound[bc2++] = 6.0;
        }
        if (rx1 < x2 && x2 < rx2) {
            bound[bc2++] = 1.0;
            bound[bc2++] = c2.ax;
            bound[bc2++] = c2.ay;
            bound[bc2++] = 7.0;
        }
        if ((cross = Crossing.crossBound(bound, bc2, py1, py2)) != 254) {
            return cross;
        }
        return c2.cross(res1, rc1, py1, py2);
    }

    public static int intersectPath(PathIterator p2, double x2, double y2, double w2, double h2) {
        int count;
        int cross = 0;
        double cy2 = 0.0;
        double cx2 = 0.0;
        double my = 0.0;
        double mx = 0.0;
        double[] coords = new double[6];
        double rx1 = x2;
        double ry1 = y2;
        double rx2 = x2 + w2;
        double ry2 = y2 + h2;
        while (!p2.isDone()) {
            count = 0;
            switch (p2.currentSegment(coords)) {
                case 0: {
                    if (cx2 != mx || cy2 != my) {
                        count = Crossing.intersectLine(cx2, cy2, mx, my, rx1, ry1, rx2, ry2);
                    }
                    mx = cx2 = coords[0];
                    my = cy2 = coords[1];
                    break;
                }
                case 1: {
                    double d2 = cx2;
                    double d3 = cy2;
                    cx2 = coords[0];
                    cy2 = coords[1];
                    count = Crossing.intersectLine(d2, d3, cx2, cy2, rx1, ry1, rx2, ry2);
                    break;
                }
                case 2: {
                    double d4 = cx2;
                    double d5 = cy2;
                    cx2 = coords[2];
                    cy2 = coords[3];
                    count = Crossing.intersectQuad(d4, d5, coords[0], coords[1], cx2, cy2, rx1, ry1, rx2, ry2);
                    break;
                }
                case 3: {
                    double d6 = cx2;
                    double d7 = cy2;
                    cx2 = coords[4];
                    cy2 = coords[5];
                    count = Crossing.intersectCubic(d6, d7, coords[0], coords[1], coords[2], coords[3], cx2, cy2, rx1, ry1, rx2, ry2);
                    break;
                }
                case 4: {
                    if (cy2 != my || cx2 != mx) {
                        count = Crossing.intersectLine(cx2, cy2, mx, my, rx1, ry1, rx2, ry2);
                    }
                    cx2 = mx;
                    cy2 = my;
                }
            }
            if (count == 255) {
                return 255;
            }
            cross += count;
            p2.next();
        }
        if (cy2 != my) {
            count = Crossing.intersectLine(cx2, cy2, mx, my, rx1, ry1, rx2, ry2);
            if (count == 255) {
                return 255;
            }
            cross += count;
        }
        return cross;
    }

    public static int intersectShape(Shape s2, double x2, double y2, double w2, double h2) {
        if (!s2.getBounds2D().intersects(x2, y2, w2, h2)) {
            return 0;
        }
        return Crossing.intersectPath(s2.getPathIterator(null), x2, y2, w2, h2);
    }

    public static boolean isInsideNonZero(int cross) {
        return cross != 0;
    }

    public static boolean isInsideEvenOdd(int cross) {
        return (cross & 1) != 0;
    }

    public static class CubicCurve {
        double ax;
        double ay;
        double bx;
        double by;
        double cx;
        double cy;
        double Ax;
        double Ay;
        double Bx;
        double By;
        double Cx;
        double Cy;
        double Ax3;
        double Bx2;

        public CubicCurve(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2) {
            this.ax = x2 - x1;
            this.ay = y2 - y1;
            this.bx = cx1 - x1;
            this.by = cy1 - y1;
            this.cx = cx2 - x1;
            this.cy = cy2 - y1;
            this.Cx = this.bx + this.bx + this.bx;
            this.Bx = this.cx + this.cx + this.cx - this.Cx - this.Cx;
            this.Ax = this.ax - this.Bx - this.Cx;
            this.Cy = this.by + this.by + this.by;
            this.By = this.cy + this.cy + this.cy - this.Cy - this.Cy;
            this.Ay = this.ay - this.By - this.Cy;
            this.Ax3 = this.Ax + this.Ax + this.Ax;
            this.Bx2 = this.Bx + this.Bx;
        }

        int cross(double[] res, int rc, double py1, double py2) {
            int cross = 0;
            for (int i2 = 0; i2 < rc; ++i2) {
                double t2 = res[i2];
                if (t2 < -1.0E-5 || t2 > 1.00001) continue;
                if (t2 < 1.0E-5) {
                    if (!(py1 < 0.0)) continue;
                    double d2 = this.bx != 0.0 ? this.bx : (this.cx != this.bx ? this.cx - this.bx : this.ax - this.cx);
                    if (!(d2 < 0.0)) continue;
                    --cross;
                    continue;
                }
                if (t2 > 0.99999) {
                    if (!(py1 < this.ay)) continue;
                    double d3 = this.ax != this.cx ? this.ax - this.cx : (this.cx != this.bx ? this.cx - this.bx : this.bx);
                    if (!(d3 > 0.0)) continue;
                    ++cross;
                    continue;
                }
                double ry = t2 * (t2 * (t2 * this.Ay + this.By) + this.Cy);
                if (!(ry > py2)) continue;
                double rxt = t2 * (t2 * this.Ax3 + this.Bx2) + this.Cx;
                if (rxt > -1.0E-5 && rxt < 1.0E-5) {
                    rxt = t2 * (this.Ax3 + this.Ax3) + this.Bx2;
                    if (rxt < -1.0E-5 || rxt > 1.0E-5) continue;
                    rxt = this.ax;
                }
                cross += rxt > 0.0 ? 1 : -1;
            }
            return cross;
        }

        int solvePoint(double[] res, double px) {
            double[] eqn = new double[]{-px, this.Cx, this.Bx, this.Ax};
            return Crossing.solveCubic(eqn, res);
        }

        int solveExtremX(double[] res) {
            double[] eqn = new double[]{this.Cx, this.Bx2, this.Ax3};
            return Crossing.solveQuad(eqn, res);
        }

        int solveExtremY(double[] res) {
            double[] eqn = new double[]{this.Cy, this.By + this.By, this.Ay + this.Ay + this.Ay};
            return Crossing.solveQuad(eqn, res);
        }

        int addBound(double[] bound, int bc2, double[] res, int rc, double minX, double maxX, boolean changeId, int id2) {
            for (int i2 = 0; i2 < rc; ++i2) {
                double rx;
                double t2 = res[i2];
                if (!(t2 > -1.0E-5) || !(t2 < 1.00001) || !(minX <= (rx = t2 * (t2 * (t2 * this.Ax + this.Bx) + this.Cx))) || !(rx <= maxX)) continue;
                bound[bc2++] = t2;
                bound[bc2++] = rx;
                bound[bc2++] = t2 * (t2 * (t2 * this.Ay + this.By) + this.Cy);
                bound[bc2++] = id2;
                if (!changeId) continue;
                ++id2;
            }
            return bc2;
        }
    }

    public static class QuadCurve {
        double ax;
        double ay;
        double bx;
        double by;
        double Ax;
        double Ay;
        double Bx;
        double By;

        public QuadCurve(double x1, double y1, double cx2, double cy2, double x2, double y2) {
            this.ax = x2 - x1;
            this.ay = y2 - y1;
            this.bx = cx2 - x1;
            this.by = cy2 - y1;
            this.Bx = this.bx + this.bx;
            this.Ax = this.ax - this.Bx;
            this.By = this.by + this.by;
            this.Ay = this.ay - this.By;
        }

        int cross(double[] res, int rc, double py1, double py2) {
            int cross = 0;
            for (int i2 = 0; i2 < rc; ++i2) {
                double rxt;
                double t2 = res[i2];
                if (t2 < -1.0E-5 || t2 > 1.00001) continue;
                if (t2 < 1.0E-5) {
                    if (!(py1 < 0.0)) continue;
                    double d2 = this.bx != 0.0 ? this.bx : this.ax - this.bx;
                    if (!(d2 < 0.0)) continue;
                    --cross;
                    continue;
                }
                if (t2 > 0.99999) {
                    if (!(py1 < this.ay)) continue;
                    double d3 = this.ax != this.bx ? this.ax - this.bx : this.bx;
                    if (!(d3 > 0.0)) continue;
                    ++cross;
                    continue;
                }
                double ry = t2 * (t2 * this.Ay + this.By);
                if (!(ry > py2) || (rxt = t2 * this.Ax + this.bx) > -1.0E-5 && rxt < 1.0E-5) continue;
                cross += rxt > 0.0 ? 1 : -1;
            }
            return cross;
        }

        int solvePoint(double[] res, double px) {
            double[] eqn = new double[]{-px, this.Bx, this.Ax};
            return Crossing.solveQuad(eqn, res);
        }

        int solveExtrem(double[] res) {
            int rc = 0;
            if (this.Ax != 0.0) {
                res[rc++] = -this.Bx / (this.Ax + this.Ax);
            }
            if (this.Ay != 0.0) {
                res[rc++] = -this.By / (this.Ay + this.Ay);
            }
            return rc;
        }

        int addBound(double[] bound, int bc2, double[] res, int rc, double minX, double maxX, boolean changeId, int id2) {
            for (int i2 = 0; i2 < rc; ++i2) {
                double rx;
                double t2 = res[i2];
                if (!(t2 > -1.0E-5) || !(t2 < 1.00001) || !(minX <= (rx = t2 * (t2 * this.Ax + this.Bx))) || !(rx <= maxX)) continue;
                bound[bc2++] = t2;
                bound[bc2++] = rx;
                bound[bc2++] = t2 * (t2 * this.Ay + this.By);
                bound[bc2++] = id2;
                if (!changeId) continue;
                ++id2;
            }
            return bc2;
        }
    }
}

