/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.Expression;

public abstract class TermNode
extends Expression {
    protected String name = null;
    protected boolean negate = false;

    public TermNode(String name, boolean negate) {
        this.setName(name);
        this.setNegate(negate);
    }

    public boolean getNegate() {
        return this.negate;
    }

    public void setNegate(boolean b2) {
        this.negate = b2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (!TermNode.isValidName(s2)) {
            throw new IllegalArgumentException("invalid name: " + s2);
        }
        this.name = s2;
    }

    private static boolean isValidName(String s2) {
        if (s2.length() == 0) {
            return false;
        }
        char c2 = s2.charAt(0);
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == ',' || c2 == '(' || c2 == ')' || c2 == '^' || c2 == '*' || c2 == '/' || c2 == '+' || c2 == '-' || c2 == ' ' || c2 == '\t' || c2 == '\n') {
            return false;
        }
        for (int i2 = 1; i2 < s2.length(); ++i2) {
            c2 = s2.charAt(i2);
            if (c2 != ',' && c2 != '(' && c2 != ')' && c2 != '^' && c2 != '*' && c2 != '/' && c2 != '+' && c2 != '-' && c2 != ' ' && c2 != '\t' && c2 != '\n') continue;
            return false;
        }
        return true;
    }
}

