/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.geom;

import com.graphbuilder.geom.Point2d;

public final class Geom {
    public static final Object PARALLEL = new Object();
    public static final Object INTERSECT = new Object();

    private Geom() {
    }

    public static double getAngle(double originX, double originY, double x2, double y2) {
        double adj = x2 - originX;
        double opp = y2 - originY;
        double rad = 0.0;
        if (adj == 0.0) {
            if (opp == 0.0) {
                return 0.0;
            }
            rad = 1.5707963267948966;
        } else {
            rad = Math.atan(opp / adj);
            if (rad < 0.0) {
                rad = -rad;
            }
        }
        if (x2 >= originX) {
            if (y2 < originY) {
                rad = Math.PI * 2 - rad;
            }
        } else {
            rad = y2 < originY ? Math.PI + rad : Math.PI - rad;
        }
        return rad;
    }

    public static double getAngle(Point2d origin, Point2d p2) {
        return Geom.getAngle(origin.getX(), origin.getY(), p2.getX(), p2.getY());
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double x3, double y3, double[] result) {
        double run = x2 - x1;
        double rise = y2 - y1;
        double t2 = 0.0;
        double f2 = run * run + rise * rise;
        if (f2 != 0.0) {
            t2 = (run * (x3 - x1) + rise * (y3 - y1)) / f2;
        }
        double nx = x1 + t2 * run;
        double ny = y1 + t2 * rise;
        if (result != null) {
            result[0] = nx;
            result[1] = ny;
            result[2] = t2;
        }
        double dx2 = x3 - nx;
        double dy2 = y3 - ny;
        return dx2 * dx2 + dy2 * dy2;
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double x3, double y3, double[] result) {
        double run = x2 - x1;
        double rise = y2 - y1;
        double t2 = 0.0;
        double f2 = run * run + rise * rise;
        if (f2 != 0.0) {
            t2 = (run * (x3 - x1) + rise * (y3 - y1)) / f2;
        }
        if (t2 < 0.0) {
            t2 = 0.0;
        } else if (t2 > 1.0) {
            t2 = 1.0;
        }
        double nx = x1 + t2 * run;
        double ny = y1 + t2 * rise;
        if (result != null) {
            result[0] = nx;
            result[1] = ny;
            result[2] = t2;
        }
        double dx2 = x3 - nx;
        double dy2 = y3 - ny;
        return dx2 * dx2 + dy2 * dy2;
    }

    public static double ptLineDistSq(double[] a2, double[] b2, double[] c2, double[] d2, int n2) {
        int i2;
        for (int i3 = 0; i3 < n2; ++i3) {
            d2[i3] = b2[i3] - a2[i3];
        }
        double f2 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            f2 += d2[i4] * d2[i4];
        }
        double t2 = 0.0;
        if (f2 != 0.0) {
            double g2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                g2 += d2[i2] * (c2[i2] - a2[i2]);
            }
            t2 = g2 / f2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            d2[i5] = a2[i5] + t2 * d2[i5];
        }
        d2[n2] = t2;
        double distSq = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            double h2 = c2[i2] - d2[i2];
            distSq += h2 * h2;
        }
        return distSq;
    }

    public static double ptSegDistSq(double[] a2, double[] b2, double[] c2, double[] d2, int n2) {
        int i2;
        for (int i3 = 0; i3 < n2; ++i3) {
            d2[i3] = b2[i3] - a2[i3];
        }
        double f2 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            f2 += d2[i4] * d2[i4];
        }
        double t2 = 0.0;
        if (f2 != 0.0) {
            double g2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                g2 += d2[i2] * (c2[i2] - a2[i2]);
            }
            t2 = g2 / f2;
        }
        if (t2 < 0.0) {
            t2 = 0.0;
        } else if (t2 > 1.0) {
            t2 = 1.0;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            d2[i5] = a2[i5] + t2 * d2[i5];
        }
        d2[n2] = t2;
        double distSq = 0.0;
        for (i2 = 0; i2 < n2; ++i2) {
            double h2 = c2[i2] - d2[i2];
            distSq += h2 * h2;
        }
        return distSq;
    }

    public static Object getLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx2 = x2 - x1;
        double dy2 = y4 - y3;
        double by2 = y2 - y1;
        double dx2 = x4 - x3;
        double b_dot_d_perp = bx2 * dy2 - by2 * dx2;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx2 = x3 - x1;
        double cy2 = y3 - y1;
        double t2 = (cx2 * dy2 - cy2 * dx2) / b_dot_d_perp;
        if (result != null) {
            result[0] = x1 + t2 * bx2;
            result[1] = y1 + t2 * by2;
            result[2] = t2;
        }
        return INTERSECT;
    }

    public static Object getLineSegIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx2 = x2 - x1;
        double dy2 = y4 - y3;
        double by2 = y2 - y1;
        double dx2 = x4 - x3;
        double b_dot_d_perp = bx2 * dy2 - by2 * dx2;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx2 = x3 - x1;
        double cy2 = y3 - y1;
        double u2 = (cx2 * by2 - cy2 * bx2) / b_dot_d_perp;
        if (u2 < 0.0 || u2 > 1.0) {
            return null;
        }
        if (result != null) {
            result[0] = x3 + u2 * dx2;
            result[1] = y3 + u2 * dy2;
            result[2] = u2;
        }
        return INTERSECT;
    }

    public static Object getSegSegIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double[] result) {
        double bx2 = x2 - x1;
        double dy2 = y4 - y3;
        double by2 = y2 - y1;
        double dx2 = x4 - x3;
        double b_dot_d_perp = bx2 * dy2 - by2 * dx2;
        if (b_dot_d_perp == 0.0) {
            return PARALLEL;
        }
        double cx2 = x3 - x1;
        double cy2 = y3 - y1;
        double t2 = (cx2 * dy2 - cy2 * dx2) / b_dot_d_perp;
        if (t2 < 0.0 || t2 > 1.0) {
            return null;
        }
        double u2 = (cx2 * by2 - cy2 * bx2) / b_dot_d_perp;
        if (u2 < 0.0 || u2 > 1.0) {
            return null;
        }
        if (result != null) {
            result[0] = x1 + t2 * bx2;
            result[1] = y1 + t2 * by2;
            result[2] = t2;
        }
        return INTERSECT;
    }

    public static boolean getCircle(double x1, double y1, double x2, double y2, double x3, double y3, double[] result) {
        double ax2 = x2 - x1;
        double cy2 = y1 - y3;
        double ay2 = y2 - y1;
        double cx2 = x1 - x3;
        double aPerpDOTc = ax2 * cy2 - ay2 * cx2;
        if (aPerpDOTc == 0.0) {
            return false;
        }
        double bx2 = x3 - x2;
        double by2 = y3 - y2;
        double bDOTc = bx2 * cx2 + by2 * cy2;
        double qo = bDOTc / aPerpDOTc;
        double sx = x1 + (ax2 - qo * ay2) / 2.0;
        double sy = y1 + (ay2 + qo * ax2) / 2.0;
        double dx2 = x1 - sx;
        double dy2 = y1 - sy;
        double rSquared = dx2 * dx2 + dy2 * dy2;
        if (result != null) {
            result[0] = sx;
            result[1] = sy;
            result[2] = rSquared;
        }
        return true;
    }

    public static double getTriangleAreaSq(double x1, double y1, double x2, double y2, double x3, double y3) {
        double t2;
        double ax2 = x1 - x2;
        double ay2 = y1 - y2;
        double bx2 = x2 - x3;
        double by2 = y2 - y3;
        double cx2 = x3 - x1;
        double cy2 = y3 - y1;
        double a2 = (ax2 * ax2 + ay2 * ay2) / 2.0;
        double b2 = (bx2 * bx2 + by2 * by2) / 2.0;
        double c2 = (cx2 * cx2 + cy2 * cy2) / 2.0;
        if (b2 < a2) {
            t2 = a2;
            a2 = b2;
            b2 = t2;
        }
        if (c2 < a2) {
            t2 = a2;
            a2 = c2;
            c2 = t2;
        }
        double d2 = (a2 + (b2 - c2)) / 2.0;
        return a2 * b2 - d2 * d2;
    }

    public static double getTriangleAreaSq(double a2, double b2, double c2) {
        double t2;
        if (a2 < 0.0) {
            throw new IllegalArgumentException("a >= 0 required");
        }
        if (b2 < 0.0) {
            throw new IllegalArgumentException("b >= 0 required");
        }
        if (c2 < 0.0) {
            throw new IllegalArgumentException("c >= 0 required");
        }
        if (a2 > b2 + c2) {
            throw new IllegalArgumentException("a <= b + c required");
        }
        if (b2 > a2 + c2) {
            throw new IllegalArgumentException("b <= a + c required");
        }
        if (c2 > a2 + b2) {
            throw new IllegalArgumentException("c <= a + b required");
        }
        if (a2 < c2) {
            t2 = c2;
            c2 = a2;
            a2 = t2;
        }
        if (b2 < c2) {
            t2 = c2;
            c2 = b2;
            b2 = t2;
        }
        if (a2 < b2) {
            t2 = b2;
            b2 = a2;
            a2 = t2;
        }
        return (a2 + (b2 + c2)) * (c2 - (a2 - b2)) * (c2 + (a2 - b2)) * (a2 + (b2 - c2)) / 16.0;
    }
}

