/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BSpline;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ValueVector;

public class NURBSpline
extends BSpline {
    private static double[] nw = new double[0];
    private static double[] weight = new double[0];
    private ValueVector weightVector = new ValueVector(new double[]{1.0, 1.0, 1.0, 1.0}, 4);
    private boolean useWeightVector = true;

    public NURBSpline(ControlPath cp2, GroupIterator gi2) {
        super(cp2, gi2);
    }

    protected void eval(double[] p2) {
        int i2;
        int dim = p2.length - 1;
        double t2 = p2[dim];
        double sum2 = 0.0;
        int numPts = this.gi.getGroupSize();
        for (i2 = 0; i2 < numPts; ++i2) {
            NURBSpline.nw[i2] = this.N(t2, i2) * weight[i2];
            sum2 += nw[i2];
        }
        if (sum2 == 0.0) {
            sum2 = 1.0;
        }
        for (i2 = 0; i2 < dim; ++i2) {
            double sum1 = 0.0;
            this.gi.set(0, 0);
            for (int j2 = 0; j2 < numPts; ++j2) {
                sum1 += nw[j2] * this.cp.getPoint(this.gi.next()).getLocation()[i2];
            }
            p2[i2] = sum1 / sum2;
        }
    }

    public ValueVector getWeightVector() {
        return this.weightVector;
    }

    public void setWeightVector(ValueVector v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("Weight-vector cannot be null.");
        }
        this.weightVector = v2;
    }

    public boolean getUseWeightVector() {
        return this.useWeightVector;
    }

    public void setUseWeightVector(boolean b2) {
        this.useWeightVector = b2;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int numPts = this.gi.getGroupSize();
        if (nw.length < numPts) {
            nw = new double[2 * numPts];
            weight = new double[2 * numPts];
        }
        if (this.useWeightVector) {
            if (this.weightVector.size() != numPts) {
                throw new IllegalArgumentException("weightVector.size(" + this.weightVector.size() + ") != group iterator size(" + numPts + ")");
            }
            for (int i2 = 0; i2 < numPts; ++i2) {
                NURBSpline.weight[i2] = this.weightVector.get(i2);
                if (!(weight[i2] < 0.0)) continue;
                throw new IllegalArgumentException("Negative weight not allowed");
            }
        } else {
            for (int i3 = 0; i3 < numPts; ++i3) {
                NURBSpline.weight[i3] = 1.0;
            }
        }
        super.appendTo(mp);
    }

    public void resetMemory() {
        super.resetMemory();
        if (nw.length > 0) {
            nw = new double[0];
            weight = new double[0];
        }
    }
}

