/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.curve.ValueVector;

public class LagrangeCurve
extends ParametricCurve {
    private ValueVector knotVector = new ValueVector(new double[]{0.0, 0.3333333333333333, 0.6666666666666666, 1.0}, 4);
    private int baseIndex = 1;
    private int baseLength = 1;
    private boolean interpolateFirst = false;
    private boolean interpolateLast = false;
    private static double[][] pt = new double[0][];

    public LagrangeCurve(ControlPath cp2, GroupIterator gi2) {
        super(cp2, gi2);
    }

    public int getBaseIndex() {
        return this.baseIndex;
    }

    public void setBaseIndex(int b2) {
        if (b2 < 0) {
            throw new IllegalArgumentException("base index >= 0 required.");
        }
        this.baseIndex = b2;
    }

    public int getBaseLength() {
        return this.baseLength;
    }

    public void setBaseLength(int b2) {
        if (b2 <= 0) {
            throw new IllegalArgumentException("base length > 0 required.");
        }
        this.baseLength = b2;
    }

    public boolean getInterpolateFirst() {
        return this.interpolateFirst;
    }

    public boolean getInterpolateLast() {
        return this.interpolateLast;
    }

    public void setInterpolateFirst(boolean b2) {
        this.interpolateFirst = b2;
    }

    public void setInterpolateLast(boolean b2) {
        this.interpolateLast = b2;
    }

    public ValueVector getKnotVector() {
        return this.knotVector;
    }

    public void setKnotVector(ValueVector v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("Knot-vector cannot be null.");
        }
        this.knotVector = v2;
    }

    public int getSampleLimit() {
        return 1;
    }

    protected void eval(double[] p2) {
        double t2 = p2[p2.length - 1];
        int n2 = this.knotVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] q2 = pt[i2];
            double L = this.L(t2, i2);
            for (int j2 = 0; j2 < p2.length - 1; ++j2) {
                int n3 = j2;
                p2[n3] = p2[n3] + q2[j2] * L;
            }
        }
    }

    private double L(double t2, int i2) {
        double d2 = 1.0;
        int n2 = this.knotVector.size();
        for (int j2 = 0; j2 < n2; ++j2) {
            double e2 = this.knotVector.get(i2) - this.knotVector.get(j2);
            if (e2 == 0.0) continue;
            d2 *= (t2 - this.knotVector.get(j2)) / e2;
        }
        return d2;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        if (this.baseIndex + this.baseLength >= this.knotVector.size()) {
            throw new IllegalArgumentException("baseIndex + baseLength >= knotVector.size");
        }
        if (pt.length < this.knotVector.size()) {
            pt = new double[2 * this.knotVector.size()][];
        }
        this.gi.set(0, 0);
        boolean b2 = false;
        if (this.baseIndex != 0 && this.interpolateFirst) {
            for (int i2 = 0; i2 < this.knotVector.size(); ++i2) {
                if (!this.gi.hasNext()) {
                    throw new IllegalArgumentException("Group iterator ended early");
                }
                LagrangeCurve.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            b2 = this.doBCAA(mp, this.knotVector.get(0), this.knotVector.get(this.baseIndex), b2);
        }
        this.gi.set(0, 0);
        int last_i = 0;
        int last_j = 0;
        while (true) {
            int j2;
            int temp_i = this.gi.index_i();
            int temp_j = this.gi.count_j();
            int index_i = 0;
            int count_j = 0;
            int i3 = 0;
            for (j2 = 0; j2 < this.knotVector.size(); ++j2) {
                if (i3 == this.baseLength) {
                    index_i = this.gi.index_i();
                    count_j = this.gi.count_j();
                }
                if (!this.gi.hasNext()) break;
                LagrangeCurve.pt[j2] = this.cp.getPoint(this.gi.next()).getLocation();
                ++i3;
            }
            if (j2 < this.knotVector.size()) break;
            this.gi.set(index_i, count_j);
            last_i = temp_i;
            last_j = temp_j;
            b2 = this.doBCAA(mp, this.knotVector.get(this.baseIndex), this.knotVector.get(this.baseIndex + this.baseLength), b2);
        }
        if (this.baseIndex + this.baseLength < this.knotVector.size() - 1 && this.interpolateLast) {
            this.gi.set(last_i, last_j);
            for (int i4 = 0; i4 < this.knotVector.size(); ++i4) {
                if (!this.gi.hasNext()) {
                    System.out.println("not enough points to interpolate last");
                    return;
                }
                LagrangeCurve.pt[i4] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            this.doBCAA(mp, this.knotVector.get(this.baseIndex + this.baseLength), this.knotVector.get(this.knotVector.size() - 1), b2);
        }
    }

    private boolean doBCAA(MultiPath mp, double t1, double t2, boolean b2) {
        if (t2 < t1) {
            double temp = t1;
            t1 = t2;
            t2 = temp;
        }
        if (!b2) {
            b2 = true;
            double[] d2 = new double[mp.getDimension() + 1];
            d2[mp.getDimension()] = t1;
            this.eval(d2);
            if (this.connect) {
                mp.lineTo(d2);
            } else {
                mp.moveTo(d2);
            }
        }
        BinaryCurveApproximationAlgorithm.genPts(this, t1, t2, mp);
        return b2;
    }

    public void resetMemory() {
        if (pt.length > 0) {
            pt = new double[0][];
        }
    }
}

