/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class CubicBSpline
extends ParametricCurve {
    private static int section = 0;
    private static int numPoints = 0;
    private static double[][] pt = new double[4][];
    private static double[] b = new double[4];
    private boolean interpolateEndpoints = false;

    public CubicBSpline(ControlPath cp2, GroupIterator gi2) {
        super(cp2, gi2);
    }

    protected void eval(double[] p2) {
        double t2 = p2[p2.length - 1];
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        double u2 = 1.0 - t2;
        double u22 = u2 * u2;
        double u3 = u22 * u2;
        if (numPoints == 4) {
            CubicBSpline.b[0] = u22 * u2;
            CubicBSpline.b[1] = 3.0 * u22 * t2;
            CubicBSpline.b[2] = 3.0 * u2 * t22;
            CubicBSpline.b[3] = t3;
        } else if (numPoints == 5) {
            if (section == 0) {
                CubicBSpline.b[0] = u3;
                CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t22 / 2.0 + 3.0 * t2;
                CubicBSpline.b[2] = -t3 + 3.0 * t22 / 2.0;
                CubicBSpline.b[3] = t3 / 4.0;
            } else {
                CubicBSpline.b[0] = u3 / 4.0;
                CubicBSpline.b[1] = -u3 + 3.0 * u22 / 2.0;
                CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u22 / 2.0 + 3.0 * u2;
                CubicBSpline.b[3] = t3;
            }
        } else if (numPoints == 6) {
            if (section == 0) {
                CubicBSpline.b[0] = u3;
                CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t22 / 2.0 + 3.0 * t2;
                CubicBSpline.b[2] = -11.0 * t3 / 12.0 + 3.0 * t22 / 2.0;
                CubicBSpline.b[3] = t3 / 6.0;
            } else if (section == 1) {
                CubicBSpline.b[0] = u3 / 4.0;
                CubicBSpline.b[1] = 7.0 * t3 / 12.0 - 5.0 * t22 / 4.0 + t2 / 4.0 + 0.5833333333333334;
                CubicBSpline.b[2] = -7.0 * t3 / 12.0 + t22 / 2.0 + t2 / 2.0 + 0.16666666666666666;
                CubicBSpline.b[3] = t3 / 4.0;
            } else {
                CubicBSpline.b[0] = u3 / 6.0;
                CubicBSpline.b[1] = -11.0 * u3 / 12.0 + 3.0 * u22 / 2.0;
                CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u22 / 2.0 + 3.0 * u2;
                CubicBSpline.b[3] = t3;
            }
        } else if (section == 0) {
            CubicBSpline.b[0] = u3;
            CubicBSpline.b[1] = 7.0 * t3 / 4.0 - 9.0 * t22 / 2.0 + 3.0 * t2;
            CubicBSpline.b[2] = -11.0 * t3 / 12.0 + 3.0 * t22 / 2.0;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 1) {
            CubicBSpline.b[0] = u3 / 4.0;
            CubicBSpline.b[1] = 7.0 * t3 / 12.0 - 5.0 * t22 / 4.0 + t2 / 4.0 + 0.5833333333333334;
            CubicBSpline.b[2] = -t3 / 2.0 + t22 / 2.0 + t2 / 2.0 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 2) {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = t3 / 2.0 - t22 + 0.6666666666666666;
            CubicBSpline.b[2] = (-t3 + t22 + t2) / 2.0 + 0.16666666666666666;
            CubicBSpline.b[3] = t3 / 6.0;
        } else if (section == 3) {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = -u3 / 2.0 + u22 / 2.0 + u2 / 2.0 + 0.16666666666666666;
            CubicBSpline.b[2] = 7.0 * u3 / 12.0 - 5.0 * u22 / 4.0 + u2 / 4.0 + 0.5833333333333334;
            CubicBSpline.b[3] = t3 / 4.0;
        } else {
            CubicBSpline.b[0] = u3 / 6.0;
            CubicBSpline.b[1] = -11.0 * u3 / 12.0 + 3.0 * u22 / 2.0;
            CubicBSpline.b[2] = 7.0 * u3 / 4.0 - 9.0 * u22 / 2.0 + 3.0 * u2;
            CubicBSpline.b[3] = t3;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < p2.length - 1; ++j2) {
                p2[j2] = p2[j2] + pt[i2][j2] * b[i2];
            }
        }
    }

    public int getSampleLimit() {
        return 1;
    }

    public void setInterpolateEndpoints(boolean b2) {
        this.interpolateEndpoints = b2;
    }

    public boolean getInterpolateEndpoints() {
        return this.interpolateEndpoints;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int n2 = this.gi.getGroupSize();
        if (n2 < 4) {
            throw new IllegalArgumentException("Group iterator size < 4");
        }
        if (this.interpolateEndpoints) {
            numPoints = n2;
            section = 0;
        } else {
            numPoints = -1;
            section = 2;
        }
        this.gi.set(0, 0);
        int index_i = 0;
        int count_j = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            CubicBSpline.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        double[] d2 = new double[mp.getDimension() + 1];
        this.eval(d2);
        if (this.connect) {
            mp.lineTo(d2);
        } else {
            mp.moveTo(d2);
        }
        int j2 = 3;
        while (true) {
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
            if (++j2 == n2) break;
            this.gi.set(index_i, count_j);
            this.gi.next();
            index_i = this.gi.index_i();
            count_j = this.gi.count_j();
            for (int i3 = 0; i3 < 4; ++i3) {
                CubicBSpline.pt[i3] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            if (!this.interpolateEndpoints) continue;
            if (n2 < 7) {
                ++section;
                continue;
            }
            if (section != 2) {
                ++section;
            }
            if (section != 2 || j2 != n2 - 2) continue;
            ++section;
        }
    }
}

