/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class CatmullRomSpline
extends ParametricCurve {
    private static double[][] pt = new double[4][];

    public CatmullRomSpline(ControlPath cp2, GroupIterator gi2) {
        super(cp2, gi2);
    }

    protected void eval(double[] p2) {
        double t2 = p2[p2.length - 1];
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        for (int i2 = 0; i2 < p2.length - 1; ++i2) {
            p2[i2] = 0.5 * ((pt[3][i2] - pt[0][i2] + 3.0 * (pt[1][i2] - pt[2][i2])) * t3 + (2.0 * (pt[0][i2] + 2.0 * pt[2][i2]) - 5.0 * pt[1][i2] - pt[3][i2]) * t22 + (pt[2][i2] - pt[0][i2]) * t2) + pt[1][i2];
        }
    }

    public int getSampleLimit() {
        return 1;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        if (this.gi.getGroupSize() < 4) {
            throw new IllegalArgumentException("Group iterator size < 4");
        }
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < 4; ++i2) {
            CatmullRomSpline.pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        double[] d2 = new double[mp.getDimension() + 1];
        this.eval(d2);
        if (this.connect) {
            mp.lineTo(d2);
        } else {
            mp.moveTo(d2);
        }
        this.gi.set(0, 0);
        while (true) {
            int index_i = this.gi.index_i();
            int count_j = this.gi.count_j();
            for (int i3 = 0; i3 < 4; ++i3) {
                if (!this.gi.hasNext()) {
                    throw new IllegalArgumentException("Group iterator ended early");
                }
                CatmullRomSpline.pt[i3] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            this.gi.set(index_i, count_j);
            this.gi.next();
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }
}

