/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.geom.Geom;

public final class BinaryCurveApproximationAlgorithm {
    private BinaryCurveApproximationAlgorithm() {
    }

    public static void genPts(ParametricCurve pc, double t_min, double t_max, MultiPath mp) {
        if (t_min > t_max) {
            throw new IllegalArgumentException("t_min <= t_max required.");
        }
        int n2 = mp.getDimension();
        double t1 = t_min;
        double t2 = t_max;
        Object stack = new double[10][];
        int count = 0;
        double[] rdy = new double[n2 + 1];
        rdy[n2] = t1;
        pc.eval(rdy);
        double[] p2 = new double[n2 + 1];
        p2[n2] = t2;
        pc.eval(p2);
        stack[count++] = p2;
        double[][] limit = new double[pc.getSampleLimit()][];
        double flatSq = mp.getFlatness() * mp.getFlatness();
        double[] d2 = new double[n2 + 1];
        while (true) {
            double m2 = (t1 + t2) / 2.0;
            double[] pt = new double[n2 + 1];
            pt[n2] = m2;
            pc.eval(pt);
            double dist = Geom.ptSegDistSq(rdy, stack[count - 1], pt, d2, n2);
            if (Double.isNaN(dist) || Double.isInfinite(dist)) {
                String msg = "NaN or infinity resulted from calling the eval method of the " + pc.getClass().getName() + " class.";
                throw new RuntimeException(msg);
            }
            boolean flag = false;
            if (dist < flatSq) {
                int i2;
                double mm = 0.0;
                for (i2 = 0; i2 < limit.length; ++i2) {
                    mm = (t1 + m2) / 2.0;
                    double[] q2 = new double[n2 + 1];
                    limit[i2] = q2;
                    q2[n2] = mm;
                    pc.eval(q2);
                    if (Geom.ptSegDistSq(rdy, pt, q2, d2, n2) >= flatSq) break;
                    m2 = mm;
                }
                if (i2 == limit.length) {
                    flag = true;
                } else {
                    stack = BinaryCurveApproximationAlgorithm.checkSpace(stack, count);
                    stack[count++] = pt;
                    for (int j2 = 0; j2 <= i2; ++j2) {
                        stack = BinaryCurveApproximationAlgorithm.checkSpace(stack, count);
                        stack[count++] = limit[j2];
                    }
                    t2 = mm;
                }
            }
            if (flag) {
                mp.lineTo(rdy);
                mp.lineTo(pt);
                rdy = stack[--count];
                if (count == 0) break;
                pt = stack[count - 1];
                t1 = t2;
                t2 = pt[n2];
                continue;
            }
            if (!(t2 > m2)) continue;
            stack = BinaryCurveApproximationAlgorithm.checkSpace(stack, count);
            stack[count++] = pt;
            t2 = m2;
        }
        mp.lineTo(rdy);
    }

    private static double[][] checkSpace(double[][] stack, int size) {
        if (size == stack.length) {
            double[][] arr = new double[2 * size][];
            for (int i2 = 0; i2 < size; ++i2) {
                arr[i2] = stack[i2];
            }
            return arr;
        }
        return stack;
    }
}

