/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.curve.ValueVector;

public class BSpline
extends ParametricCurve {
    public static final int UNIFORM_CLAMPED = 0;
    public static final int UNIFORM_UNCLAMPED = 1;
    public static final int NON_UNIFORM = 2;
    private static int[] a = new int[0];
    private static int[] c = new int[0];
    private static double[] knot = new double[0];
    private ValueVector knotVector = new ValueVector(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0}, 8);
    private double t_min = 0.0;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    private int degree = 4;
    private int knotVectorType = 0;
    private boolean useDefaultInterval = true;

    public BSpline(ControlPath cp2, GroupIterator gi2) {
        super(cp2, gi2);
    }

    protected void eval(double[] p2) {
        int dim = p2.length - 1;
        double t2 = p2[dim];
        int numPts = this.gi.getGroupSize();
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < numPts; ++i2) {
            double w2 = this.N(t2, i2);
            double[] loc = this.cp.getPoint(this.gi.next()).getLocation();
            for (int j2 = 0; j2 < dim; ++j2) {
                int n2 = j2;
                p2[n2] = p2[n2] + loc[j2] * w2;
            }
        }
    }

    public void setInterval(double t_min, double t_max) {
        if (t_min > t_max) {
            throw new IllegalArgumentException("t_min <= t_max required.");
        }
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public double t_min() {
        return this.t_min;
    }

    public double t_max() {
        return this.t_max;
    }

    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Sample-limit >= 0 required.");
        }
        this.sampleLimit = limit;
    }

    public int getDegree() {
        return this.degree - 1;
    }

    public void setDegree(int d2) {
        if (d2 <= 0) {
            throw new IllegalArgumentException("Degree > 0 required.");
        }
        this.degree = d2 + 1;
    }

    public ValueVector getKnotVector() {
        return this.knotVector;
    }

    public void setKnotVector(ValueVector v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("Knot-vector cannot be null.");
        }
        this.knotVector = v2;
    }

    public boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public void setUseDefaultInterval(boolean b2) {
        this.useDefaultInterval = b2;
    }

    public int getKnotVectorType() {
        return this.knotVectorType;
    }

    public void setKnotVectorType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Unknown knot-vector type.");
        }
        this.knotVectorType = type;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int numPts = this.gi.getGroupSize();
        int f2 = numPts - this.degree;
        if (f2 < 0) {
            throw new IllegalArgumentException("group iterator size - degree < 0");
        }
        int x2 = numPts + this.degree;
        if (knot.length < x2) {
            knot = new double[2 * x2];
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x2) {
                throw new IllegalArgumentException("knotVector.size(" + this.knotVector.size() + ") != " + x2);
            }
            BSpline.knot[0] = this.knotVector.get(0);
            for (int i2 = 1; i2 < x2; ++i2) {
                BSpline.knot[i2] = this.knotVector.get(i2);
                if (!(knot[i2] < knot[i2 - 1])) continue;
                throw new IllegalArgumentException("Knot not in sorted order! (knot[" + i2 + "] < knot[" + i2 + "-1])");
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x2 - 1);
            for (int i3 = 0; i3 < x2; ++i3) {
                BSpline.knot[i3] = (double)i3 * grad;
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            int i4;
            double grad = 1.0 / (double)(f2 + 1);
            for (int i5 = 0; i5 < this.degree; ++i5) {
                BSpline.knot[i5] = 0.0;
            }
            int j2 = this.degree;
            for (i4 = 1; i4 <= f2; ++i4) {
                BSpline.knot[j2++] = (double)i4 * grad;
            }
            for (i4 = j2; i4 < x2; ++i4) {
                BSpline.knot[i4] = 1.0;
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (a.length < this.degree) {
            a = new int[2 * this.degree];
            c = new int[2 * this.degree];
        }
        double[] p2 = new double[mp.getDimension() + 1];
        p2[mp.getDimension()] = t1;
        this.eval(p2);
        if (this.connect) {
            mp.lineTo(p2);
        } else {
            mp.moveTo(p2);
        }
        BinaryCurveApproximationAlgorithm.genPts(this, t1, t2, mp);
    }

    protected double N(double t2, int i2) {
        double d2 = 0.0;
        block0: for (int j2 = 0; j2 < this.degree; ++j2) {
            int k2;
            double t1 = knot[i2 + j2];
            double t22 = knot[i2 + j2 + 1];
            if (!(t2 >= t1) || !(t2 <= t22) || t1 == t22) continue;
            int dm2 = this.degree - 2;
            for (k2 = this.degree - j2 - 1; k2 >= 0; --k2) {
                BSpline.a[k2] = 0;
            }
            if (j2 > 0) {
                for (k2 = 0; k2 < j2; ++k2) {
                    BSpline.c[k2] = k2;
                }
                BSpline.c[j2] = Integer.MAX_VALUE;
            } else {
                BSpline.c[0] = dm2;
                BSpline.c[1] = this.degree;
            }
            int z2 = 0;
            while (true) {
                if (c[z2] < c[z2 + 1] - 1) {
                    double e2 = 1.0;
                    int bc2 = 0;
                    int y2 = dm2 - j2;
                    int p2 = j2 - 1;
                    int m2 = dm2;
                    int n2 = this.degree;
                    while (m2 >= 0) {
                        int w2;
                        if (p2 >= 0 && c[p2] == m2) {
                            w2 = i2 + bc2;
                            double kd = knot[w2 + n2];
                            e2 *= (kd - t2) / (kd - knot[w2 + 1]);
                            ++bc2;
                            --p2;
                        } else {
                            w2 = i2 + a[y2];
                            double kw = knot[w2];
                            e2 *= (t2 - kw) / (knot[w2 + n2 - 1] - kw);
                            --y2;
                        }
                        --m2;
                        --n2;
                    }
                    if (j2 > 0) {
                        int g2 = 0;
                        boolean reset = false;
                        while (true) {
                            int n3 = ++g2;
                            a[n3] = a[n3] + 1;
                            if (a[g2] <= j2) break;
                            reset = true;
                        }
                        if (reset) {
                            for (int h2 = g2 - 1; h2 >= 0; --h2) {
                                BSpline.a[h2] = a[g2];
                            }
                        }
                    }
                    d2 += e2;
                    int n4 = z2;
                    c[n4] = c[n4] + 1;
                    if (c[z2] > dm2) break block0;
                    for (int k3 = 0; k3 < z2; ++k3) {
                        BSpline.c[k3] = k3;
                    }
                    z2 = 0;
                    continue;
                }
                ++z2;
            }
        }
        return d2;
    }

    public void resetMemory() {
        if (a.length > 0) {
            a = new int[0];
            c = new int[0];
        }
        if (knot.length > 0) {
            knot = new double[0];
        }
    }
}

