/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod am2) {
        String name = am2.getName();
        String str = BeanUtil.okNameForIsGetter(am2, name);
        if (str == null) {
            str = BeanUtil.okNameForRegularGetter(am2, name);
        }
        return str;
    }

    public static String okNameForRegularGetter(AnnotatedMethod am2, String name) {
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) ? BeanUtil.isCglibGetCallbacks(am2) : "getMetaClass".equals(name) && BeanUtil.isGroovyMetaClassGetter(am2)) {
                return null;
            }
            return BeanUtil.manglePropertyName(name.substring(3));
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod am2, String name) {
        if (name.startsWith("is")) {
            Class<?> rt = am2.getRawType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return BeanUtil.manglePropertyName(name.substring(2));
        }
        return null;
    }

    public static String okNameForSetter(AnnotatedMethod am2) {
        String name = BeanUtil.okNameForMutator(am2, "set");
        if (name != null) {
            if ("metaClass".equals(name) && BeanUtil.isGroovyMetaClassSetter(am2)) {
                return null;
            }
            return name;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod am2, String prefix) {
        String name = am2.getName();
        if (name.startsWith(prefix)) {
            return BeanUtil.manglePropertyName(name.substring(prefix.length()));
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod am2) {
        String pname;
        Class<?> rt = am2.getRawType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        Package pkg = compType.getPackage();
        return pkg != null && ((pname = pkg.getName()).startsWith("net.sf.cglib") || pname.startsWith("org.hibernate.repackage.cglib"));
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod am2) {
        Class<?> argType = am2.getRawParameterType(0);
        Package pkg = argType.getPackage();
        return pkg != null && pkg.getName().startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod am2) {
        Class<?> rt = am2.getRawType();
        if (rt == null || rt.isArray()) {
            return false;
        }
        Package pkg = rt.getPackage();
        return pkg != null && pkg.getName().startsWith("groovy.lang");
    }

    protected static String manglePropertyName(String basename) {
        char lower;
        char upper;
        int len = basename.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = null;
        for (int i2 = 0; i2 < len && (upper = basename.charAt(i2)) != (lower = Character.toLowerCase(upper)); ++i2) {
            if (sb == null) {
                sb = new StringBuilder(basename);
            }
            sb.setCharAt(i2, lower);
        }
        return sb == null ? basename : sb.toString();
    }
}

