/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class CollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    public CollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
        super(Collection.class, elemType, staticTyping, vts, property, valueSerializer);
    }

    public CollectionSerializer(CollectionSerializer src, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSerializer) {
        super(src, property, vts, valueSerializer);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new CollectionSerializer(this._elementType, this._staticTyping, vts, this._property, this._elementSerializer);
    }

    public CollectionSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer) {
        return new CollectionSerializer(this, property, vts, elementSerializer);
    }

    @Override
    public boolean isEmpty(Collection<?> value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Collection<?> value) {
        Iterator<?> it2 = value.iterator();
        if (!it2.hasNext()) {
            return false;
        }
        it2.next();
        return !it2.hasNext();
    }

    @Override
    public void serializeContents(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
            return;
        }
        Iterator<?> it2 = value.iterator();
        if (!it2.hasNext()) {
            return;
        }
        PropertySerializerMap serializers = this._dynamicSerializers;
        TypeSerializer typeSer = this._valueTypeSerializer;
        int i2 = 0;
        try {
            do {
                Object elem;
                if ((elem = it2.next()) == null) {
                    provider.defaultSerializeNull(jgen);
                } else {
                    Class<?> cc2 = elem.getClass();
                    JsonSerializer<Object> serializer = serializers.serializerFor(cc2);
                    if (serializer == null) {
                        serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._elementType, cc2), provider) : this._findAndAddDynamic(serializers, cc2, provider);
                        serializers = this._dynamicSerializers;
                    }
                    if (typeSer == null) {
                        serializer.serialize(elem, jgen, provider);
                    } else {
                        serializer.serializeWithType(elem, jgen, provider, typeSer);
                    }
                }
                ++i2;
            } while (it2.hasNext());
        }
        catch (Exception e2) {
            this.wrapAndThrow(provider, (Throwable)e2, value, i2);
        }
    }

    public void serializeContentsUsing(Collection<?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        Iterator<?> it2 = value.iterator();
        if (it2.hasNext()) {
            TypeSerializer typeSer = this._valueTypeSerializer;
            int i2 = 0;
            do {
                Object elem = it2.next();
                try {
                    if (elem == null) {
                        provider.defaultSerializeNull(jgen);
                    } else if (typeSer == null) {
                        ser.serialize(elem, jgen, provider);
                    } else {
                        ser.serializeWithType(elem, jgen, provider, typeSer);
                    }
                    ++i2;
                }
                catch (Exception e2) {
                    this.wrapAndThrow(provider, (Throwable)e2, value, i2);
                }
            } while (it2.hasNext());
        }
    }
}

