/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import java.io.IOException;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> generator) {
        this.generator = generator;
    }

    public boolean writeAsId(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w2) throws IOException, JsonGenerationException {
        if (this.id != null && (this.idWritten || w2.alwaysAsId)) {
            if (jgen.canWriteObjectId()) {
                jgen.writeObjectRef(String.valueOf(this.id));
            } else {
                w2.serializer.serialize(this.id, jgen, provider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        this.id = this.generator.generateId(forPojo);
        return this.id;
    }

    public void writeAsField(JsonGenerator jgen, SerializerProvider provider, ObjectIdWriter w2) throws IOException, JsonGenerationException {
        this.idWritten = true;
        if (jgen.canWriteObjectId()) {
            jgen.writeObjectId(String.valueOf(this.id));
            return;
        }
        SerializableString name = w2.propertyName;
        if (name != null) {
            jgen.writeFieldName(name);
            w2.serializer.serialize(this.id, jgen, provider);
        }
    }
}

