/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final String _mutatorPrefix;
    protected final LinkedHashMap<String, POJOPropertyBuilder> _properties = new LinkedHashMap();
    protected LinkedList<POJOPropertyBuilder> _creatorProperties = null;
    protected LinkedList<AnnotatedMember> _anyGetters = null;
    protected LinkedList<AnnotatedMethod> _anySetters = null;
    protected LinkedList<AnnotatedMethod> _jsonValueGetters = null;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;

    protected POJOPropertiesCollector(MapperConfig<?> config, boolean forSerialization, JavaType type, AnnotatedClass classDef, String mutatorPrefix) {
        this._config = config;
        this._forSerialization = forSerialization;
        this._type = type;
        this._classDef = classDef;
        this._mutatorPrefix = mutatorPrefix == null ? "set" : mutatorPrefix;
        this._annotationIntrospector = config.isAnnotationProcessingEnabled() ? this._config.getAnnotationIntrospector() : null;
        this._visibilityChecker = this._annotationIntrospector == null ? this._config.getDefaultVisibilityChecker() : this._annotationIntrospector.findAutoDetectVisibility(classDef, this._config.getDefaultVisibilityChecker());
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        return new ArrayList<BeanPropertyDefinition>(this._properties.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        return this._injectables;
    }

    public AnnotatedMethod getJsonValueMethod() {
        if (this._jsonValueGetters != null) {
            if (this._jsonValueGetters.size() > 1) {
                this.reportProblem("Multiple value properties defined (" + this._jsonValueGetters.get(0) + " vs " + this._jsonValueGetters.get(1) + ")");
            }
            return this._jsonValueGetters.get(0);
        }
        return null;
    }

    public AnnotatedMember getAnyGetter() {
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getters' defined (" + this._anyGetters.get(0) + " vs " + this._anyGetters.get(1) + ")");
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setters' defined (" + this._anySetters.get(0) + " vs " + this._anySetters.get(1) + ")");
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        ObjectIdInfo info = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (info != null) {
            info = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, info);
        }
        return info;
    }

    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        return this._properties;
    }

    public POJOPropertiesCollector collect() {
        this._properties.clear();
        this._addFields();
        this._addMethods();
        this._addCreators();
        this._addInjectables();
        this._removeUnwantedProperties();
        this._renameProperties();
        PropertyNamingStrategy naming = this._findNamingStrategy();
        if (naming != null) {
            this._renameUsing(naming);
        }
        for (POJOPropertyBuilder property : this._properties.values()) {
            property.trimByVisibility();
        }
        for (POJOPropertyBuilder property : this._properties.values()) {
            property.mergeAnnotations(this._forSerialization);
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers();
        }
        this._sortProperties();
        return this;
    }

    protected void _sortProperties() {
        String[] propertyOrder;
        AnnotationIntrospector intr = this._annotationIntrospector;
        Boolean alpha = intr == null ? null : intr.findSerializationSortAlphabetically((Annotated)this._classDef);
        boolean sort = alpha == null ? this._config.shouldSortPropertiesAlphabetically() : alpha.booleanValue();
        String[] stringArray = propertyOrder = intr == null ? null : intr.findSerializationPropertyOrder(this._classDef);
        if (!sort && this._creatorProperties == null && propertyOrder == null) {
            return;
        }
        int size = this._properties.size();
        AbstractMap all = sort ? new TreeMap() : new LinkedHashMap(size + size);
        for (POJOPropertyBuilder prop : this._properties.values()) {
            all.put(prop.getName(), prop);
        }
        LinkedHashMap<String, POJOPropertyBuilder> ordered = new LinkedHashMap<String, POJOPropertyBuilder>(size + size);
        if (propertyOrder != null) {
            for (String name : propertyOrder) {
                POJOPropertyBuilder w2 = (POJOPropertyBuilder)all.get(name);
                if (w2 == null) {
                    for (POJOPropertyBuilder prop : this._properties.values()) {
                        if (!name.equals(prop.getInternalName())) continue;
                        w2 = prop;
                        name = prop.getName();
                        break;
                    }
                }
                if (w2 == null) continue;
                ordered.put(name, w2);
            }
        }
        if (this._creatorProperties != null) {
            Collection<POJOPropertyBuilder> cr2;
            if (sort) {
                TreeMap<String, POJOPropertyBuilder> sorted = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder prop : this._creatorProperties) {
                    sorted.put(prop.getName(), prop);
                }
                cr2 = sorted.values();
            } else {
                cr2 = this._creatorProperties;
            }
            for (POJOPropertyBuilder prop : cr2) {
                ordered.put(prop.getName(), prop);
            }
        }
        ordered.putAll(all);
        this._properties.clear();
        this._properties.putAll(ordered);
    }

    protected void _addFields() {
        AnnotationIntrospector ai2 = this._annotationIntrospector;
        boolean pruneFinalFields = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        for (AnnotatedField f2 : this._classDef.fields()) {
            boolean ignored;
            boolean visible;
            boolean nameExplicit;
            String implName;
            String string = implName = ai2 == null ? null : ai2.findImplicitPropertyName(f2);
            if (implName == null) {
                implName = f2.getName();
            }
            PropertyName pn = ai2 == null ? null : (this._forSerialization ? ai2.findNameForSerialization(f2) : ai2.findNameForDeserialization(f2));
            boolean bl2 = nameExplicit = pn != null;
            if (nameExplicit && pn.isEmpty()) {
                pn = this._propNameFromSimple(implName);
                nameExplicit = false;
            }
            boolean bl3 = visible = pn != null;
            if (!visible) {
                visible = this._visibilityChecker.isFieldVisible(f2);
            }
            boolean bl4 = ignored = ai2 != null && ai2.hasIgnoreMarker(f2);
            if (pruneFinalFields && pn == null && !ignored && Modifier.isFinal(f2.getModifiers())) continue;
            this._property(implName).addField(f2, pn, nameExplicit, visible, ignored);
        }
    }

    protected void _addCreators() {
        if (this._annotationIntrospector != null) {
            int i2;
            int len;
            for (AnnotatedConstructor ctor : this._classDef.getConstructors()) {
                if (this._creatorProperties == null) {
                    this._creatorProperties = new LinkedList();
                }
                len = ctor.getParameterCount();
                for (i2 = 0; i2 < len; ++i2) {
                    this._addCreatorParam(ctor.getParameter(i2));
                }
            }
            for (AnnotatedMethod factory : this._classDef.getStaticMethods()) {
                if (this._creatorProperties == null) {
                    this._creatorProperties = new LinkedList();
                }
                len = factory.getParameterCount();
                for (i2 = 0; i2 < len; ++i2) {
                    this._addCreatorParam(factory.getParameter(i2));
                }
            }
        }
    }

    protected void _addCreatorParam(AnnotatedParameter param) {
        PropertyName pn;
        boolean expl;
        String impl = this._annotationIntrospector.findImplicitPropertyName(param);
        if (impl == null) {
            impl = "";
        }
        boolean bl2 = expl = (pn = this._annotationIntrospector.findNameForDeserialization(param)) != null && !pn.isEmpty();
        if (!expl) {
            if (impl.isEmpty()) {
                return;
            }
            pn = new PropertyName(impl);
        }
        POJOPropertyBuilder prop = expl ? this._property(pn) : this._property(impl);
        prop.addCtor(param, pn, expl, true, false);
        this._creatorProperties.add(prop);
    }

    protected void _addMethods() {
        AnnotationIntrospector ai2 = this._annotationIntrospector;
        for (AnnotatedMethod m2 : this._classDef.memberMethods()) {
            int argCount = m2.getParameterCount();
            if (argCount == 0) {
                this._addGetterMethod(m2, ai2);
                continue;
            }
            if (argCount == 1) {
                this._addSetterMethod(m2, ai2);
                continue;
            }
            if (argCount != 2 || ai2 == null || !ai2.hasAnySetterAnnotation(m2)) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(m2);
        }
    }

    protected void _addGetterMethod(AnnotatedMethod m2, AnnotationIntrospector ai2) {
        boolean visible;
        String implName;
        boolean nameExplicit;
        if (!m2.hasReturnType()) {
            return;
        }
        if (ai2 != null) {
            if (ai2.hasAnyGetterAnnotation(m2)) {
                if (this._anyGetters == null) {
                    this._anyGetters = new LinkedList();
                }
                this._anyGetters.add(m2);
                return;
            }
            if (ai2.hasAsValueAnnotation(m2)) {
                if (this._jsonValueGetters == null) {
                    this._jsonValueGetters = new LinkedList();
                }
                this._jsonValueGetters.add(m2);
                return;
            }
        }
        PropertyName pn = ai2 == null ? null : ai2.findNameForSerialization(m2);
        boolean bl2 = nameExplicit = pn != null;
        if (!nameExplicit) {
            String string = implName = ai2 == null ? null : ai2.findImplicitPropertyName(m2);
            if (implName == null) {
                implName = BeanUtil.okNameForRegularGetter(m2, m2.getName());
            }
            if (implName == null) {
                implName = BeanUtil.okNameForIsGetter(m2, m2.getName());
                if (implName == null) {
                    return;
                }
                visible = this._visibilityChecker.isIsGetterVisible(m2);
            } else {
                visible = this._visibilityChecker.isGetterVisible(m2);
            }
        } else {
            String string = implName = ai2 == null ? null : ai2.findImplicitPropertyName(m2);
            if (implName == null) {
                implName = BeanUtil.okNameForGetter(m2);
            }
            if (implName == null) {
                implName = m2.getName();
            }
            if (pn.isEmpty()) {
                pn = this._propNameFromSimple(implName);
                nameExplicit = false;
            }
            visible = true;
        }
        boolean ignore = ai2 == null ? false : ai2.hasIgnoreMarker(m2);
        this._property(implName).addGetter(m2, pn, nameExplicit, visible, ignore);
    }

    protected void _addSetterMethod(AnnotatedMethod m2, AnnotationIntrospector ai2) {
        boolean visible;
        String implName;
        boolean nameExplicit;
        PropertyName pn = ai2 == null ? null : ai2.findNameForDeserialization(m2);
        boolean bl2 = nameExplicit = pn != null;
        if (!nameExplicit) {
            String string = implName = ai2 == null ? null : ai2.findImplicitPropertyName(m2);
            if (implName == null) {
                implName = BeanUtil.okNameForMutator(m2, this._mutatorPrefix);
            }
            if (implName == null) {
                return;
            }
            visible = this._visibilityChecker.isSetterVisible(m2);
        } else {
            String string = implName = ai2 == null ? null : ai2.findImplicitPropertyName(m2);
            if (implName == null) {
                implName = BeanUtil.okNameForMutator(m2, this._mutatorPrefix);
            }
            if (implName == null) {
                implName = m2.getName();
            }
            if (pn.isEmpty()) {
                pn = this._propNameFromSimple(implName);
                nameExplicit = false;
            }
            visible = true;
        }
        boolean ignore = ai2 == null ? false : ai2.hasIgnoreMarker(m2);
        this._property(implName).addSetter(m2, pn, nameExplicit, visible, ignore);
    }

    protected void _addInjectables() {
        AnnotationIntrospector ai2 = this._annotationIntrospector;
        if (ai2 == null) {
            return;
        }
        for (AnnotatedField f2 : this._classDef.fields()) {
            this._doAddInjectable(ai2.findInjectableValueId(f2), f2);
        }
        for (AnnotatedMethod m2 : this._classDef.memberMethods()) {
            if (m2.getParameterCount() != 1) continue;
            this._doAddInjectable(ai2.findInjectableValueId(m2), m2);
        }
    }

    protected void _doAddInjectable(Object id2, AnnotatedMember m2) {
        AnnotatedMember prev;
        if (id2 == null) {
            return;
        }
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((prev = this._injectables.put(id2, m2)) != null) {
            String type = id2.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + String.valueOf(id2) + "' (of type " + type + ")");
        }
    }

    private PropertyName _propNameFromSimple(String simpleName) {
        return PropertyName.construct(simpleName, null);
    }

    protected void _removeUnwantedProperties() {
        boolean forceNonVisibleRemoval;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> it2 = this._properties.entrySet().iterator();
        boolean bl2 = forceNonVisibleRemoval = !this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        while (it2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = it2.next();
            POJOPropertyBuilder prop = entry.getValue();
            if (!prop.anyVisible()) {
                it2.remove();
                continue;
            }
            if (prop.anyIgnorals()) {
                if (!prop.isExplicitlyIncluded()) {
                    it2.remove();
                    this._addIgnored(prop.getName());
                    continue;
                }
                prop.removeIgnored();
                if (!this._forSerialization && !prop.couldDeserialize()) {
                    this._addIgnored(prop.getName());
                }
            }
            prop.removeNonVisible(forceNonVisibleRemoval);
        }
    }

    private void _addIgnored(String name) {
        if (!this._forSerialization) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(name);
        }
    }

    protected void _renameProperties() {
        Iterator<Map.Entry<String, POJOPropertyBuilder>> it2 = this._properties.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> renamed = null;
        while (it2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = it2.next();
            POJOPropertyBuilder prop = entry.getValue();
            Set<PropertyName> l2 = prop.findExplicitNames();
            if (l2.isEmpty()) continue;
            it2.remove();
            if (renamed == null) {
                renamed = new LinkedList<POJOPropertyBuilder>();
            }
            if (l2.size() == 1) {
                PropertyName n2 = (PropertyName)l2.iterator().next();
                renamed.add(prop.withName(n2));
                continue;
            }
            renamed.addAll(prop.explode(l2));
        }
        if (renamed != null) {
            for (POJOPropertyBuilder prop : renamed) {
                String name = prop.getName();
                POJOPropertyBuilder old = this._properties.get(name);
                if (old == null) {
                    this._properties.put(name, prop);
                } else {
                    old.addAll(prop);
                }
                this._updateCreatorProperty(prop, this._creatorProperties);
            }
        }
    }

    protected void _renameUsing(PropertyNamingStrategy naming) {
        POJOPropertyBuilder[] props = this._properties.values().toArray(new POJOPropertyBuilder[this._properties.size()]);
        this._properties.clear();
        for (POJOPropertyBuilder prop : props) {
            String simpleName;
            PropertyName fullName = prop.getFullName();
            String rename = null;
            if (!prop.isExplicitlyNamed()) {
                if (this._forSerialization) {
                    if (prop.hasGetter()) {
                        rename = naming.nameForGetterMethod(this._config, prop.getGetter(), fullName.getSimpleName());
                    } else if (prop.hasField()) {
                        rename = naming.nameForField(this._config, prop.getField(), fullName.getSimpleName());
                    }
                } else if (prop.hasSetter()) {
                    rename = naming.nameForSetterMethod(this._config, prop.getSetter(), fullName.getSimpleName());
                } else if (prop.hasConstructorParameter()) {
                    rename = naming.nameForConstructorParameter(this._config, prop.getConstructorParameter(), fullName.getSimpleName());
                } else if (prop.hasField()) {
                    rename = naming.nameForField(this._config, prop.getField(), fullName.getSimpleName());
                } else if (prop.hasGetter()) {
                    rename = naming.nameForGetterMethod(this._config, prop.getGetter(), fullName.getSimpleName());
                }
            }
            if (rename != null && !fullName.hasSimpleName(rename)) {
                prop = prop.withSimpleName(rename);
                simpleName = rename;
            } else {
                simpleName = fullName.getSimpleName();
            }
            POJOPropertyBuilder old = this._properties.get(simpleName);
            if (old == null) {
                this._properties.put(simpleName, prop);
            } else {
                old.addAll(prop);
            }
            this._updateCreatorProperty(prop, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers() {
        Iterator<Map.Entry<String, POJOPropertyBuilder>> it2 = this._properties.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> renamed = null;
        while (it2.hasNext()) {
            PropertyName wrapperName;
            Map.Entry<String, POJOPropertyBuilder> entry = it2.next();
            POJOPropertyBuilder prop = entry.getValue();
            AnnotatedMember member = prop.getPrimaryMember();
            if (member == null || (wrapperName = this._annotationIntrospector.findWrapperName(member)) == null || !wrapperName.hasSimpleName() || wrapperName.equals(prop.getFullName())) continue;
            if (renamed == null) {
                renamed = new LinkedList<POJOPropertyBuilder>();
            }
            prop = prop.withName(wrapperName);
            renamed.add(prop);
            it2.remove();
        }
        if (renamed != null) {
            for (POJOPropertyBuilder prop : renamed) {
                String name = prop.getName();
                POJOPropertyBuilder old = this._properties.get(name);
                if (old == null) {
                    this._properties.put(name, prop);
                    continue;
                }
                old.addAll(prop);
            }
        }
    }

    protected void reportProblem(String msg) {
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + msg);
    }

    protected POJOPropertyBuilder _property(PropertyName name) {
        return this._property(name.getSimpleName());
    }

    protected POJOPropertyBuilder _property(String implName) {
        POJOPropertyBuilder prop = this._properties.get(implName);
        if (prop == null) {
            prop = new POJOPropertyBuilder(new PropertyName(implName), this._annotationIntrospector, this._forSerialization);
            this._properties.put(implName, prop);
        }
        return prop;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy pns;
        Object namingDef;
        Object object = namingDef = this._annotationIntrospector == null ? null : this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (namingDef == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (namingDef instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)namingDef;
        }
        if (!(namingDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + namingDef.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
        }
        Class namingClass = (Class)namingDef;
        if (!PropertyNamingStrategy.class.isAssignableFrom(namingClass)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + namingClass.getName() + "; expected Class<PropertyNamingStrategy>");
        }
        HandlerInstantiator hi2 = this._config.getHandlerInstantiator();
        if (hi2 != null && (pns = hi2.namingStrategyInstance(this._config, this._classDef, namingClass)) != null) {
            return pns;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(namingClass, this._config.canOverrideAccessModifiers());
    }

    protected void _updateCreatorProperty(POJOPropertyBuilder prop, List<POJOPropertyBuilder> creatorProperties) {
        if (creatorProperties != null) {
            int len = creatorProperties.size();
            for (int i2 = 0; i2 < len; ++i2) {
                if (!creatorProperties.get(i2).getInternalName().equals(prop.getInternalName())) continue;
                creatorProperties.set(i2, prop);
                break;
            }
        }
    }
}

