/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Array;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final ArrayType _arrayType;
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;

    public ObjectArrayDeserializer(ArrayType arrayType, JsonDeserializer<Object> elemDeser, TypeDeserializer elemTypeDeser) {
        super(arrayType);
        this._arrayType = arrayType;
        this._elementClass = arrayType.getContentType().getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = elemDeser;
        this._elementTypeDeserializer = elemTypeDeser;
    }

    public ObjectArrayDeserializer withDeserializer(TypeDeserializer elemTypeDeser, JsonDeserializer<?> elemDeser) {
        if (elemDeser == this._elementDeserializer && elemTypeDeser == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this._arrayType, elemDeser, elemTypeDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._elementDeserializer;
        deser = (deser = this.findConvertingContentDeserializer(ctxt, property, deser)) == null ? ctxt.findContextualValueDeserializer(this._arrayType.getContentType(), property) : ctxt.handleSecondaryContextualization(deser, property);
        TypeDeserializer elemTypeDeser = this._elementTypeDeserializer;
        if (elemTypeDeser != null) {
            elemTypeDeser = elemTypeDeser.forProperty(property);
        }
        return this.withDeserializer(elemTypeDeser, deser);
    }

    @Override
    public JavaType getContentType() {
        return this._arrayType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public Object[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!jp.isExpectedStartArrayToken()) {
            return this.handleNonArray(jp, ctxt);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        int ix2 = 0;
        TypeDeserializer typeDeser = this._elementTypeDeserializer;
        try {
            JsonToken t2;
            while ((t2 = jp.nextToken()) != JsonToken.END_ARRAY) {
                Object value = t2 == JsonToken.VALUE_NULL ? this._elementDeserializer.getNullValue() : (typeDeser == null ? this._elementDeserializer.deserialize(jp, ctxt) : this._elementDeserializer.deserializeWithType(jp, ctxt, typeDeser));
                if (ix2 >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix2 = 0;
                }
                chunk[ix2++] = value;
            }
        }
        catch (Exception e2) {
            throw JsonMappingException.wrapWithPath((Throwable)e2, (Object)chunk, ix2);
        }
        Object[] result = this._untyped ? buffer.completeAndClearBuffer(chunk, ix2) : buffer.completeAndClearBuffer(chunk, ix2, this._elementClass);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    public Object[] deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    protected Byte[] deserializeFromBase64(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        byte[] b2 = jp.getBinaryValue(ctxt.getBase64Variant());
        Byte[] result = new Byte[b2.length];
        int len = b2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            result[i2] = b2[i2];
        }
        return result;
    }

    private final Object[] handleNonArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String str;
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = jp.getText()).length() == 0) {
            return null;
        }
        if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING && this._elementClass == Byte.class) {
                return this.deserializeFromBase64(jp, ctxt);
            }
            throw ctxt.mappingException(this._arrayType.getRawClass());
        }
        JsonToken t2 = jp.getCurrentToken();
        Object value = t2 == JsonToken.VALUE_NULL ? this._elementDeserializer.getNullValue() : (this._elementTypeDeserializer == null ? this._elementDeserializer.deserialize(jp, ctxt) : this._elementDeserializer.deserializeWithType(jp, ctxt, this._elementTypeDeserializer));
        Object[] result = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        result[0] = value;
        return result;
    }
}

