/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            if (rawType == Calendar.class) {
                return new CalendarDeserializer();
            }
            if (rawType == java.util.Date.class) {
                return DateDeserializer.instance;
            }
            if (rawType == Date.class) {
                return new SqlDateDeserializer();
            }
            if (rawType == Timestamp.class) {
                return new TimestampDeserializer();
            }
            if (rawType == GregorianCalendar.class) {
                return new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    static {
        Class[] numberTypes;
        _classNames = new HashSet();
        for (Class cls : numberTypes = new Class[]{Calendar.class, GregorianCalendar.class, Date.class, java.util.Date.class, Timestamp.class}) {
            _classNames.add(cls.getName());
        }
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer src, DateFormat df2, String formatString) {
            super(src, df2, formatString);
        }

        protected TimestampDeserializer withDateFormat(DateFormat df2, String formatString) {
            return new TimestampDeserializer(this, df2, formatString);
        }

        @Override
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return new Timestamp(this._parseDate(jp, ctxt).getTime());
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer src, DateFormat df2, String formatString) {
            super(src, df2, formatString);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat df2, String formatString) {
            return new SqlDateDeserializer(this, df2, formatString);
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            java.util.Date d2 = this._parseDate(jp, ctxt);
            return d2 == null ? null : new Date(d2.getTime());
        }
    }

    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer base, DateFormat df2, String formatString) {
            super(base, df2, formatString);
        }

        protected DateDeserializer withDateFormat(DateFormat df2, String formatString) {
            return new DateDeserializer(this, df2, formatString);
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return this._parseDate(jp, ctxt);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Class<? extends Calendar> _calendarClass;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._calendarClass = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> cc2) {
            super(cc2);
            this._calendarClass = cc2;
        }

        public CalendarDeserializer(CalendarDeserializer src, DateFormat df2, String formatString) {
            super(src, df2, formatString);
            this._calendarClass = src._calendarClass;
        }

        protected CalendarDeserializer withDateFormat(DateFormat df2, String formatString) {
            return new CalendarDeserializer(this, df2, formatString);
        }

        @Override
        public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            java.util.Date d2 = this._parseDate(jp, ctxt);
            if (d2 == null) {
                return null;
            }
            if (this._calendarClass == null) {
                return ctxt.constructCalendar(d2);
            }
            try {
                Calendar c2 = this._calendarClass.newInstance();
                c2.setTimeInMillis(d2.getTime());
                TimeZone tz = ctxt.getTimeZone();
                if (tz != null) {
                    c2.setTimeZone(tz);
                }
                return c2;
            }
            catch (Exception e2) {
                throw ctxt.instantiationException(this._calendarClass, e2);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clz) {
            super(clz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> base, DateFormat format, String formatStr) {
            super(base._valueClass);
            this._customFormat = format;
            this._formatString = formatStr;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JsonFormat.Value format;
            if (property != null && (format = ctxt.getAnnotationIntrospector().findFormat(property.getMember())) != null) {
                TimeZone tz = format.getTimeZone();
                if (format.hasPattern()) {
                    String pattern = format.getPattern();
                    Locale loc = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
                    SimpleDateFormat df2 = new SimpleDateFormat(pattern, loc);
                    if (tz == null) {
                        tz = ctxt.getTimeZone();
                    }
                    df2.setTimeZone(tz);
                    return this.withDateFormat(df2, pattern);
                }
                if (tz != null) {
                    DateFormat df3 = ctxt.getConfig().getDateFormat();
                    if (df3.getClass() == StdDateFormat.class) {
                        Locale loc = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
                        StdDateFormat std = (StdDateFormat)df3;
                        std = std.withTimeZone(tz);
                        std = std.withLocale(loc);
                        df3 = std;
                    } else {
                        df3 = (DateFormat)df3.clone();
                        df3.setTimeZone(tz);
                    }
                    return this.withDateFormat(df3, this._formatString);
                }
            }
            return this;
        }

        @Override
        protected java.util.Date _parseDate(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (this._customFormat != null) {
                JsonToken t2 = jp.getCurrentToken();
                if (t2 == JsonToken.VALUE_STRING) {
                    String str = jp.getText().trim();
                    if (str.length() == 0) {
                        return (java.util.Date)this.getEmptyValue();
                    }
                    DateFormat dateFormat = this._customFormat;
                    synchronized (dateFormat) {
                        try {
                            return this._customFormat.parse(str);
                        }
                        catch (ParseException e2) {
                            throw new IllegalArgumentException("Failed to parse Date value '" + str + "' (format: \"" + this._formatString + "\"): " + e2.getMessage());
                        }
                    }
                }
                if (t2 == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    jp.nextToken();
                    java.util.Date parsed = this._parseDate(jp, ctxt);
                    t2 = jp.nextToken();
                    if (t2 != JsonToken.END_ARRAY) {
                        throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'java.util.Date' value but there was more than a single value in the array");
                    }
                    return parsed;
                }
            }
            return super._parseDate(jp, ctxt);
        }
    }
}

