/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.Instantiatable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class DefaultPrettyPrinter
implements PrettyPrinter,
Instantiatable<DefaultPrettyPrinter>,
Serializable {
    private static final long serialVersionUID = -5512586643324525213L;
    public static final SerializedString DEFAULT_ROOT_VALUE_SEPARATOR = new SerializedString(" ");
    protected Indenter _arrayIndenter = FixedSpaceIndenter.instance;
    protected Indenter _objectIndenter = Lf2SpacesIndenter.instance;
    protected final SerializableString _rootSeparator;
    protected boolean _spacesInObjectEntries = true;
    protected transient int _nesting = 0;

    public DefaultPrettyPrinter() {
        this(DEFAULT_ROOT_VALUE_SEPARATOR);
    }

    public DefaultPrettyPrinter(String rootSeparator) {
        this(rootSeparator == null ? null : new SerializedString(rootSeparator));
    }

    public DefaultPrettyPrinter(SerializableString rootSeparator) {
        this._rootSeparator = rootSeparator;
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter base) {
        this(base, base._rootSeparator);
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter base, SerializableString rootSeparator) {
        this._arrayIndenter = base._arrayIndenter;
        this._objectIndenter = base._objectIndenter;
        this._spacesInObjectEntries = base._spacesInObjectEntries;
        this._nesting = base._nesting;
        this._rootSeparator = rootSeparator;
    }

    public DefaultPrettyPrinter withRootSeparator(SerializableString rootSeparator) {
        if (this._rootSeparator == rootSeparator || rootSeparator != null && rootSeparator.equals(this._rootSeparator)) {
            return this;
        }
        return new DefaultPrettyPrinter(this, rootSeparator);
    }

    public void indentArraysWith(Indenter i2) {
        this._arrayIndenter = i2 == null ? NopIndenter.instance : i2;
    }

    public void indentObjectsWith(Indenter i2) {
        this._objectIndenter = i2 == null ? NopIndenter.instance : i2;
    }

    @Deprecated
    public void spacesInObjectEntries(boolean b2) {
        this._spacesInObjectEntries = b2;
    }

    public DefaultPrettyPrinter withArrayIndenter(Indenter i2) {
        if (i2 == null) {
            i2 = NopIndenter.instance;
        }
        if (this._arrayIndenter == i2) {
            return this;
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter(this);
        pp._arrayIndenter = i2;
        return pp;
    }

    public DefaultPrettyPrinter withObjectIndenter(Indenter i2) {
        if (i2 == null) {
            i2 = NopIndenter.instance;
        }
        if (this._objectIndenter == i2) {
            return this;
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter(this);
        pp._objectIndenter = i2;
        return pp;
    }

    public DefaultPrettyPrinter withSpacesInObjectEntries() {
        return this._withSpaces(true);
    }

    public DefaultPrettyPrinter withoutSpacesInObjectEntries() {
        return this._withSpaces(false);
    }

    protected DefaultPrettyPrinter _withSpaces(boolean state) {
        if (this._spacesInObjectEntries == state) {
            return this;
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter(this);
        pp._spacesInObjectEntries = state;
        return pp;
    }

    @Override
    public DefaultPrettyPrinter createInstance() {
        return new DefaultPrettyPrinter(this);
    }

    @Override
    public void writeRootValueSeparator(JsonGenerator jg2) throws IOException, JsonGenerationException {
        if (this._rootSeparator != null) {
            jg2.writeRaw(this._rootSeparator);
        }
    }

    @Override
    public void writeStartObject(JsonGenerator jg2) throws IOException, JsonGenerationException {
        jg2.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            ++this._nesting;
        }
    }

    @Override
    public void beforeObjectEntries(JsonGenerator jg2) throws IOException, JsonGenerationException {
        this._objectIndenter.writeIndentation(jg2, this._nesting);
    }

    @Override
    public void writeObjectFieldValueSeparator(JsonGenerator jg2) throws IOException, JsonGenerationException {
        if (this._spacesInObjectEntries) {
            jg2.writeRaw(" : ");
        } else {
            jg2.writeRaw(':');
        }
    }

    @Override
    public void writeObjectEntrySeparator(JsonGenerator jg2) throws IOException, JsonGenerationException {
        jg2.writeRaw(',');
        this._objectIndenter.writeIndentation(jg2, this._nesting);
    }

    @Override
    public void writeEndObject(JsonGenerator jg2, int nrOfEntries) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfEntries > 0) {
            this._objectIndenter.writeIndentation(jg2, this._nesting);
        } else {
            jg2.writeRaw(' ');
        }
        jg2.writeRaw('}');
    }

    @Override
    public void writeStartArray(JsonGenerator jg2) throws IOException, JsonGenerationException {
        if (!this._arrayIndenter.isInline()) {
            ++this._nesting;
        }
        jg2.writeRaw('[');
    }

    @Override
    public void beforeArrayValues(JsonGenerator jg2) throws IOException, JsonGenerationException {
        this._arrayIndenter.writeIndentation(jg2, this._nesting);
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator jg2) throws IOException, JsonGenerationException {
        jg2.writeRaw(',');
        this._arrayIndenter.writeIndentation(jg2, this._nesting);
    }

    @Override
    public void writeEndArray(JsonGenerator jg2, int nrOfValues) throws IOException, JsonGenerationException {
        if (!this._arrayIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfValues > 0) {
            this._arrayIndenter.writeIndentation(jg2, this._nesting);
        } else {
            jg2.writeRaw(' ');
        }
        jg2.writeRaw(']');
    }

    public static class Lf2SpacesIndenter
    extends NopIndenter {
        private static final String SYS_LF;
        static final int SPACE_COUNT = 64;
        static final char[] SPACES;
        public static final Lf2SpacesIndenter instance;
        protected final String _lf;

        public Lf2SpacesIndenter() {
            this(SYS_LF);
        }

        public Lf2SpacesIndenter(String lf) {
            this._lf = lf;
        }

        public Lf2SpacesIndenter withLinefeed(String lf) {
            if (lf.equals(this._lf)) {
                return this;
            }
            return new Lf2SpacesIndenter(lf);
        }

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public void writeIndentation(JsonGenerator jg2, int level) throws IOException, JsonGenerationException {
            jg2.writeRaw(this._lf);
            if (level > 0) {
                level += level;
                while (level > 64) {
                    jg2.writeRaw(SPACES, 0, 64);
                    level -= SPACES.length;
                }
                jg2.writeRaw(SPACES, 0, level);
            }
        }

        static {
            String lf = null;
            try {
                lf = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYS_LF = lf == null ? "\n" : lf;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
            instance = new Lf2SpacesIndenter();
        }
    }

    public static class FixedSpaceIndenter
    extends NopIndenter {
        public static final FixedSpaceIndenter instance = new FixedSpaceIndenter();

        @Override
        public void writeIndentation(JsonGenerator jg2, int level) throws IOException, JsonGenerationException {
            jg2.writeRaw(' ');
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static class NopIndenter
    implements Indenter,
    Serializable {
        public static final NopIndenter instance = new NopIndenter();

        @Override
        public void writeIndentation(JsonGenerator jg2, int level) throws IOException, JsonGenerationException {
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static interface Indenter {
        public void writeIndentation(JsonGenerator var1, int var2) throws IOException, JsonGenerationException;

        public boolean isInline();
    }
}

