/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

public class BufferRecycler {
    public static final int BYTE_READ_IO_BUFFER = 0;
    public static final int BYTE_WRITE_ENCODING_BUFFER = 1;
    public static final int BYTE_WRITE_CONCAT_BUFFER = 2;
    public static final int BYTE_BASE64_CODEC_BUFFER = 3;
    public static final int CHAR_TOKEN_BUFFER = 0;
    public static final int CHAR_CONCAT_BUFFER = 1;
    public static final int CHAR_TEXT_BUFFER = 2;
    public static final int CHAR_NAME_COPY_BUFFER = 3;
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final byte[][] _byteBuffers;
    protected final char[][] _charBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int bbCount, int cbCount) {
        this._byteBuffers = new byte[bbCount][];
        this._charBuffers = new char[cbCount][];
    }

    public final byte[] allocByteBuffer(int ix2) {
        return this.allocByteBuffer(ix2, 0);
    }

    public byte[] allocByteBuffer(int ix2, int minSize) {
        byte[] buffer;
        int DEF_SIZE = this.byteBufferLength(ix2);
        if (minSize < DEF_SIZE) {
            minSize = DEF_SIZE;
        }
        if ((buffer = this._byteBuffers[ix2]) == null || buffer.length < minSize) {
            buffer = this.balloc(minSize);
        } else {
            this._byteBuffers[ix2] = null;
        }
        return buffer;
    }

    public final void releaseByteBuffer(int ix2, byte[] buffer) {
        this._byteBuffers[ix2] = buffer;
    }

    public final char[] allocCharBuffer(int ix2) {
        return this.allocCharBuffer(ix2, 0);
    }

    public char[] allocCharBuffer(int ix2, int minSize) {
        char[] buffer;
        int DEF_SIZE = this.charBufferLength(ix2);
        if (minSize < DEF_SIZE) {
            minSize = DEF_SIZE;
        }
        if ((buffer = this._charBuffers[ix2]) == null || buffer.length < minSize) {
            buffer = this.calloc(minSize);
        } else {
            this._charBuffers[ix2] = null;
        }
        return buffer;
    }

    public void releaseCharBuffer(int ix2, char[] buffer) {
        this._charBuffers[ix2] = buffer;
    }

    protected int byteBufferLength(int ix2) {
        return BYTE_BUFFER_LENGTHS[ix2];
    }

    protected int charBufferLength(int ix2) {
        return CHAR_BUFFER_LENGTHS[ix2];
    }

    protected byte[] balloc(int size) {
        return new byte[size];
    }

    protected char[] calloc(int size) {
        return new char[size];
    }
}

