/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static final char NC = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    static final char[] LEAD_3 = new char[4000];
    static final char[] FULL_3 = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int v2, char[] b2, int off) {
        boolean hasBillions;
        if (v2 < 0) {
            if (v2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)v2, b2, off);
            }
            b2[off++] = 45;
            v2 = -v2;
        }
        if (v2 < MILLION) {
            if (v2 < 1000) {
                if (v2 < 10) {
                    b2[off++] = (char)(48 + v2);
                } else {
                    off = NumberOutput.leading3(v2, b2, off);
                }
            } else {
                int thousands = v2 / 1000;
                off = NumberOutput.leading3(thousands, b2, off);
                off = NumberOutput.full3(v2 -= thousands * 1000, b2, off);
            }
            return off;
        }
        boolean bl2 = hasBillions = v2 >= BILLION;
        if (hasBillions) {
            if ((v2 -= BILLION) >= BILLION) {
                v2 -= BILLION;
                b2[off++] = 50;
            } else {
                b2[off++] = 49;
            }
        }
        int newValue = v2 / 1000;
        int ones = v2 - newValue * 1000;
        v2 = newValue;
        int thousands = v2 - (newValue /= 1000) * 1000;
        off = hasBillions ? NumberOutput.full3(newValue, b2, off) : NumberOutput.leading3(newValue, b2, off);
        off = NumberOutput.full3(thousands, b2, off);
        off = NumberOutput.full3(ones, b2, off);
        return off;
    }

    public static int outputInt(int v2, byte[] b2, int off) {
        boolean hasB;
        if (v2 < 0) {
            if (v2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)v2, b2, off);
            }
            b2[off++] = 45;
            v2 = -v2;
        }
        if (v2 < MILLION) {
            if (v2 < 1000) {
                if (v2 < 10) {
                    b2[off++] = (byte)(48 + v2);
                } else {
                    off = NumberOutput.leading3(v2, b2, off);
                }
            } else {
                int thousands = v2 / 1000;
                off = NumberOutput.leading3(thousands, b2, off);
                off = NumberOutput.full3(v2 -= thousands * 1000, b2, off);
            }
            return off;
        }
        boolean bl2 = hasB = v2 >= BILLION;
        if (hasB) {
            if ((v2 -= BILLION) >= BILLION) {
                v2 -= BILLION;
                b2[off++] = 50;
            } else {
                b2[off++] = 49;
            }
        }
        int newValue = v2 / 1000;
        int ones = v2 - newValue * 1000;
        v2 = newValue;
        int thousands = v2 - (newValue /= 1000) * 1000;
        off = hasB ? NumberOutput.full3(newValue, b2, off) : NumberOutput.leading3(newValue, b2, off);
        off = NumberOutput.full3(thousands, b2, off);
        off = NumberOutput.full3(ones, b2, off);
        return off;
    }

    public static int outputLong(long v2, char[] b2, int off) {
        int triplet;
        if (v2 < 0L) {
            if (v2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)v2, b2, off);
            }
            if (v2 == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, len, b2, off);
                return off + len;
            }
            b2[off++] = 45;
            v2 = -v2;
        } else if (v2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)v2, b2, off);
        }
        int origOffset = off;
        int ptr = off += NumberOutput.calcLongStrLength(v2);
        while (v2 > MAX_INT_AS_LONG) {
            long newValue = v2 / THOUSAND_L;
            triplet = (int)(v2 - newValue * THOUSAND_L);
            NumberOutput.full3(triplet, b2, ptr -= 3);
            v2 = newValue;
        }
        int ivalue = (int)v2;
        while (ivalue >= 1000) {
            int newValue = ivalue / 1000;
            triplet = ivalue - newValue * 1000;
            NumberOutput.full3(triplet, b2, ptr -= 3);
            ivalue = newValue;
        }
        NumberOutput.leading3(ivalue, b2, origOffset);
        return off;
    }

    public static int outputLong(long v2, byte[] b2, int off) {
        int t2;
        if (v2 < 0L) {
            if (v2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)v2, b2, off);
            }
            if (v2 == Long.MIN_VALUE) {
                int len = SMALLEST_LONG.length();
                for (int i2 = 0; i2 < len; ++i2) {
                    b2[off++] = (byte)SMALLEST_LONG.charAt(i2);
                }
                return off;
            }
            b2[off++] = 45;
            v2 = -v2;
        } else if (v2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)v2, b2, off);
        }
        int origOff = off;
        int ptr = off += NumberOutput.calcLongStrLength(v2);
        while (v2 > MAX_INT_AS_LONG) {
            long newV = v2 / THOUSAND_L;
            t2 = (int)(v2 - newV * THOUSAND_L);
            NumberOutput.full3(t2, b2, ptr -= 3);
            v2 = newV;
        }
        int ivalue = (int)v2;
        while (ivalue >= 1000) {
            int newV = ivalue / 1000;
            t2 = ivalue - newV * 1000;
            NumberOutput.full3(t2, b2, ptr -= 3);
            ivalue = newV;
        }
        NumberOutput.leading3(ivalue, b2, origOff);
        return off;
    }

    public static String toString(int v2) {
        if (v2 < sSmallIntStrs.length) {
            if (v2 >= 0) {
                return sSmallIntStrs[v2];
            }
            int v22 = -v2 - 1;
            if (v22 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[v22];
            }
        }
        return Integer.toString(v2);
    }

    public static String toString(long v2) {
        if (v2 <= Integer.MAX_VALUE && v2 >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)v2);
        }
        return Long.toString(v2);
    }

    public static String toString(double v2) {
        return Double.toString(v2);
    }

    private static int leading3(int t2, char[] b2, int off) {
        char c2;
        int digitOffset = t2 << 2;
        if ((c2 = LEAD_3[digitOffset++]) != '\u0000') {
            b2[off++] = c2;
        }
        if ((c2 = LEAD_3[digitOffset++]) != '\u0000') {
            b2[off++] = c2;
        }
        b2[off++] = LEAD_3[digitOffset];
        return off;
    }

    private static int leading3(int t2, byte[] b2, int off) {
        char c2;
        int digitOffset = t2 << 2;
        if ((c2 = LEAD_3[digitOffset++]) != '\u0000') {
            b2[off++] = (byte)c2;
        }
        if ((c2 = LEAD_3[digitOffset++]) != '\u0000') {
            b2[off++] = (byte)c2;
        }
        b2[off++] = (byte)LEAD_3[digitOffset];
        return off;
    }

    private static int full3(int t2, char[] b2, int off) {
        int digitOffset = t2 << 2;
        b2[off++] = FULL_3[digitOffset++];
        b2[off++] = FULL_3[digitOffset++];
        b2[off++] = FULL_3[digitOffset];
        return off;
    }

    private static int full3(int t2, byte[] b2, int off) {
        int digitOffset = t2 << 2;
        b2[off++] = FULL_TRIPLETS_B[digitOffset++];
        b2[off++] = FULL_TRIPLETS_B[digitOffset++];
        b2[off++] = FULL_TRIPLETS_B[digitOffset];
        return off;
    }

    private static int calcLongStrLength(long v2) {
        int len;
        long cmp = TEN_BILLION_L;
        for (len = 10; v2 >= cmp && len != 19; ++len) {
            cmp = (cmp << 3) + (cmp << 1);
        }
        return len;
    }

    static {
        int ix2 = 0;
        for (int i1 = 0; i1 < 10; ++i1) {
            char f1 = (char)(48 + i1);
            char l1 = i1 == 0 ? (char)'\u0000' : f1;
            for (int i2 = 0; i2 < 10; ++i2) {
                char f2 = (char)(48 + i2);
                char l2 = i1 == 0 && i2 == 0 ? (char)'\u0000' : f2;
                for (int i3 = 0; i3 < 10; ++i3) {
                    char f3 = (char)(48 + i3);
                    NumberOutput.LEAD_3[ix2] = l1;
                    NumberOutput.LEAD_3[ix2 + 1] = l2;
                    NumberOutput.LEAD_3[ix2 + 2] = f3;
                    NumberOutput.FULL_3[ix2] = f1;
                    NumberOutput.FULL_3[ix2 + 1] = f2;
                    NumberOutput.FULL_3[ix2 + 2] = f3;
                    ix2 += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (int i2 = 0; i2 < 4000; ++i2) {
            NumberOutput.FULL_TRIPLETS_B[i2] = (byte)FULL_3[i2];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

