/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.base;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int features) {
        super(features);
    }

    @Override
    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public final int getCurrentTokenId() {
        JsonToken t2 = this._currToken;
        return t2 == null ? 0 : t2.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public JsonToken nextValue() throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 == JsonToken.FIELD_NAME) {
            t2 = this.nextToken();
        }
        return t2;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t2;
            if ((t2 = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (t2.isStructStart()) {
                ++open;
                continue;
            }
            if (t2.isStructEnd() && --open == 0) break;
        }
        return this;
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public abstract String getCurrentName() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText() throws IOException;

    @Override
    public abstract char[] getTextCharacters() throws IOException;

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength() throws IOException;

    @Override
    public abstract int getTextOffset() throws IOException;

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1) throws IOException;

    @Override
    public boolean getValueAsBoolean(boolean defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText().trim();
                    if ("true".equals(str)) {
                        return true;
                    }
                    if ("false".equals(str)) {
                        return false;
                    }
                    if (!this._hasTextualNull(str)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Boolean)) break;
                    return (Boolean)value;
                }
            }
        }
        return defaultValue;
    }

    @Override
    public int getValueAsInt(int defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText();
                    if (this._hasTextualNull(str)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(str, defaultValue);
                }
                case 7: 
                case 8: {
                    return this.getIntValue();
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).intValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public long getValueAsLong(long defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText();
                    if (this._hasTextualNull(str)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(str, defaultValue);
                }
                case 7: 
                case 8: {
                    return this.getLongValue();
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).longValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public double getValueAsDouble(double defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText();
                    if (this._hasTextualNull(str)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble(str, defaultValue);
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).doubleValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public String getValueAsString(String defaultValue) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return defaultValue;
        }
        return this.getText();
    }

    protected void _decodeBase64(String str, ByteArrayBuilder builder, Base64Variant b64variant) throws IOException {
        try {
            b64variant.decode(str, builder);
        }
        catch (IllegalArgumentException e2) {
            this._reportError(e2.getMessage());
        }
    }

    @Deprecated
    protected void _reportInvalidBase64(Base64Variant b64variant, char ch2, int bindex, String msg) throws JsonParseException {
        String base = ch2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(ch2) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units" : (b64variant.usesPaddingChar(ch2) ? "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch2) || Character.isISOControl(ch2) ? "Illegal character (code 0x" + Integer.toHexString(ch2) + ") in base64 content" : "Illegal character '" + ch2 + "' (code 0x" + Integer.toHexString(ch2) + ") in base64 content"));
        if (msg != null) {
            base = base + ": " + msg;
        }
        throw this._constructError(base);
    }

    @Deprecated
    protected void _reportBase64EOF() throws JsonParseException {
        throw this._constructError("Unexpected end-of-String in base64 content");
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected void _reportUnexpectedChar(int ch2, String comment) throws JsonParseException {
        if (ch2 < 0) {
            this._reportInvalidEOF();
        }
        String msg = "Unexpected character (" + ParserMinimalBase._getCharDesc(ch2) + ")";
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this._reportError(msg);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String msg) throws JsonParseException {
        this._reportError("Unexpected end-of-input" + msg);
    }

    protected void _reportInvalidEOFInValue() throws JsonParseException {
        this._reportInvalidEOF(" in a value");
    }

    protected void _reportMissingRootWS(int ch2) throws JsonParseException {
        this._reportUnexpectedChar(ch2, "Expected space separating root-level values");
    }

    protected void _throwInvalidSpace(int i2) throws JsonParseException {
        char c2 = (char)i2;
        String msg = "Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(msg);
    }

    protected void _throwUnquotedSpace(int i2, String ctxtDesc) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || i2 > 32) {
            char c2 = (char)i2;
            String msg = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c2) + "): has to be escaped using backslash to be included in " + ctxtDesc;
            this._reportError(msg);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char ch2) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return ch2;
        }
        if (ch2 == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return ch2;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(ch2));
        return ch2;
    }

    protected static final String _getCharDesc(int ch2) {
        char c2 = (char)ch2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + ch2 + ")";
        }
        if (ch2 > 255) {
            return "'" + c2 + "' (code " + ch2 + " / 0x" + Integer.toHexString(ch2) + ")";
        }
        return "'" + c2 + "' (code " + ch2 + ")";
    }

    protected final void _reportError(String msg) throws JsonParseException {
        throw this._constructError(msg);
    }

    protected final void _wrapError(String msg, Throwable t2) throws JsonParseException {
        throw this._constructError(msg, t2);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String msg, Throwable t2) {
        return new JsonParseException(msg, this.getCurrentLocation(), t2);
    }

    protected static byte[] _asciiBytes(String str) {
        byte[] b2 = new byte[str.length()];
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            b2[i2] = (byte)str.charAt(i2);
        }
        return b2;
    }

    protected static String _ascii(byte[] b2) {
        try {
            return new String(b2, "US-ASCII");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

