/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    static final char CHAR_SPACE = ' ';
    private static final char INT_SPACE = ' ';
    static String sLF = null;
    private static final int EOS = 65536;

    public static String getLF() {
        String lf = sLF;
        if (lf == null) {
            try {
                lf = System.getProperty("line.separator");
                sLF = lf == null ? "\n" : lf;
            }
            catch (Throwable t2) {
                lf = "\n";
                sLF = "\n";
            }
        }
        return lf;
    }

    public static void appendLF(StringBuffer sb) {
        sb.append(StringUtil.getLF());
    }

    public static String concatEntries(Collection coll, String sep, String lastSep) {
        if (lastSep == null) {
            lastSep = sep;
        }
        int len = coll.size();
        StringBuffer sb = new StringBuffer(16 + (len << 3));
        Iterator it2 = coll.iterator();
        int i2 = 0;
        while (it2.hasNext()) {
            if (i2 != 0) {
                if (i2 == len - 1) {
                    sb.append(lastSep);
                } else {
                    sb.append(sep);
                }
            }
            ++i2;
            sb.append(it2.next());
        }
        return sb.toString();
    }

    public static String normalizeSpaces(char[] buf, int origStart, int origEnd) {
        int start;
        int end = --origEnd;
        for (start = origStart; start <= end && buf[start] == ' '; ++start) {
        }
        if (start > end) {
            return "";
        }
        while (end > start && buf[end] == ' ') {
            --end;
        }
        int i2 = start + 1;
        while (i2 < end) {
            if (buf[i2] == ' ') {
                if (buf[i2 + 1] == ' ') break;
                i2 += 2;
                continue;
            }
            ++i2;
        }
        if (i2 >= end) {
            if (start == origStart && end == origEnd) {
                return null;
            }
            return new String(buf, start, end - start + 1);
        }
        StringBuffer sb = new StringBuffer(end - start);
        sb.append(buf, start, i2 - start);
        while (i2 <= end) {
            char c2;
            if ((c2 = buf[i2++]) == ' ') {
                sb.append(' ');
                while ((c2 = buf[i2++]) == ' ') {
                }
                sb.append(c2);
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public static boolean isAllWhitespace(String str) {
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (str.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllWhitespace(char[] ch2, int start, int len) {
        len += start;
        while (start < len) {
            if (ch2[start] > ' ') {
                return false;
            }
            ++start;
        }
        return true;
    }

    public static boolean equalEncodings(String str1, String str2) {
        int len1 = str1.length();
        int len2 = str2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c1 == 65536 || c2 == 65536) {
                return false;
            }
            if (c1 < 127) {
                if (c1 <= 90 && c1 >= 65) {
                    c1 += 32;
                }
            } else {
                c1 = Character.toLowerCase((char)c1);
            }
            if (c2 < 127) {
                if (c2 <= 90 && c2 >= 65) {
                    c2 += 32;
                }
            } else {
                c2 = Character.toLowerCase((char)c2);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean encodingStartsWith(String enc, String prefix) {
        int len1 = enc.length();
        int len2 = prefix.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c2 == 65536) {
                return true;
            }
            if (c1 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }

    public static String trimEncoding(String str, boolean upperCase) {
        char c2;
        int i2;
        int len = str.length();
        for (i2 = 0; i2 < len && (c2 = str.charAt(i2)) > ' ' && Character.isLetterOrDigit(c2); ++i2) {
        }
        if (i2 == len) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (i2 > 0) {
            sb.append(str.substring(0, i2));
        }
        while (i2 < len) {
            char c3 = str.charAt(i2);
            if (c3 > ' ' && Character.isLetterOrDigit(c3)) {
                if (upperCase) {
                    c3 = Character.toUpperCase(c3);
                }
                sb.append(c3);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static boolean matches(String str, char[] cbuf, int offset, int len) {
        if (str.length() != len) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (str.charAt(i2) == cbuf[offset + i2]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSpace(char c2) {
        return c2 <= ' ';
    }
}

