/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dom.WstxDOMWrappingReader;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.evt.DefaultEventAllocator;
import com.ctc.wstx.evt.WstxEventReader;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.DefaultInputResolver;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.SystemId;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.sr.ValidatingStreamReader;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SimpleCache;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2Source;
import org.codehaus.stax2.ri.Stax2FilteredStreamReader;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2EventReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2FilteredEventReader;
import org.xml.sax.InputSource;

public class WstxInputFactory
extends XMLInputFactory2
implements ReaderCreator,
InputConfigFlags {
    static final int MAX_SYMBOL_TABLE_SIZE = 12000;
    static final int MAX_SYMBOL_TABLE_GENERATIONS = 500;
    protected final ReaderConfig mConfig;
    protected XMLEventAllocator mAllocator = null;
    protected SimpleCache mDTDCache = null;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    private SymbolTable mSymbols = mRootSymbols;

    public WstxInputFactory() {
        this.mConfig = ReaderConfig.createFullDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbol(String symbol) {
        SymbolTable symbolTable = this.mSymbols;
        synchronized (symbolTable) {
            this.mSymbols.findSymbol(symbol);
        }
    }

    public synchronized DTDSubset findCachedDTD(DTDId id2) {
        return this.mDTDCache == null ? null : (DTDSubset)this.mDTDCache.find(id2);
    }

    public synchronized void updateSymbolTable(SymbolTable t2) {
        SymbolTable curr = this.mSymbols;
        if (t2.isDirectChildOf(curr)) {
            if (t2.size() > 12000 || t2.version() > 500) {
                this.mSymbols = mRootSymbols;
            } else {
                this.mSymbols.mergeChild(t2);
            }
        }
    }

    public synchronized void addCachedDTD(DTDId id2, DTDSubset extSubset) {
        if (this.mDTDCache == null) {
            this.mDTDCache = new SimpleCache(this.mConfig.getDtdCacheSize());
        }
        this.mDTDCache.add(id2, extSubset);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) {
        return new Stax2FilteredEventReader(Stax2EventReaderAdapter.wrapIfNecessary(reader), filter);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        Stax2FilteredStreamReader fr2 = new Stax2FilteredStreamReader(reader, filter);
        if (!filter.accept(fr2)) {
            fr2.next();
        }
        return fr2;
    }

    public XMLEventReader createXMLEventReader(InputStream in2) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, in2, null, true, false));
    }

    public XMLEventReader createXMLEventReader(InputStream in2, String enc) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, in2, enc, true, false));
    }

    public XMLEventReader createXMLEventReader(Reader r2) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, r2, true, false));
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(source, true));
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream in2) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(SystemId.construct(systemId), in2, null, true, false));
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader r2) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(SystemId.construct(systemId), r2, true, false));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader sr) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), Stax2ReaderAdapter.wrapIfNecessary(sr));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in2) throws XMLStreamException {
        return this.createSR(null, in2, null, false, false);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in2, String enc) throws XMLStreamException {
        return this.createSR(null, in2, enc, false, false);
    }

    public XMLStreamReader createXMLStreamReader(Reader r2) throws XMLStreamException {
        return this.createSR(null, r2, false, false);
    }

    public XMLStreamReader createXMLStreamReader(Source src) throws XMLStreamException {
        return this.createSR(src, false);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in2) throws XMLStreamException {
        return this.createSR(SystemId.construct(systemId), in2, null, false, false);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r2) throws XMLStreamException {
        return this.createSR(SystemId.construct(systemId), r2, false, false);
    }

    public Object getProperty(String name) {
        Object ob = this.mConfig.getProperty(name);
        if (ob == null && name.equals("javax.xml.stream.allocator")) {
            return this.getEventAllocator();
        }
        return ob;
    }

    public void setProperty(String propName, Object value) {
        if (!this.mConfig.setProperty(propName, value) && "javax.xml.stream.allocator".equals(propName)) {
            this.setEventAllocator((XMLEventAllocator)value);
        }
    }

    public XMLEventAllocator getEventAllocator() {
        return this.mAllocator;
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.mAllocator = allocator;
    }

    public void setXMLReporter(XMLReporter r2) {
        this.mConfig.setXMLReporter(r2);
    }

    public void setXMLResolver(XMLResolver r2) {
        this.mConfig.setXMLResolver(r2);
    }

    public XMLEventReader2 createXMLEventReader(URL src) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(this.createPrivateConfig(), src, true, true));
    }

    public XMLEventReader2 createXMLEventReader(File f2) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(f2, true, true));
    }

    public XMLStreamReader2 createXMLStreamReader(URL src) throws XMLStreamException {
        return this.createSR(this.createPrivateConfig(), src, false, true);
    }

    public XMLStreamReader2 createXMLStreamReader(File f2) throws XMLStreamException {
        return this.createSR(f2, false, true);
    }

    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    public void configureForConvenience() {
        this.mConfig.configureForConvenience();
    }

    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    public void configureForLowMemUsage() {
        this.mConfig.configureForLowMemUsage();
    }

    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    private XMLStreamReader2 doCreateSR(ReaderConfig cfg, SystemId systemId, InputBootstrapper bs2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        Reader r2;
        if (!autoCloseInput) {
            autoCloseInput = cfg.willAutoCloseInput();
        }
        try {
            r2 = bs2.bootstrapInput(cfg, true, 0);
            if (bs2.declaredXml11()) {
                cfg.enableXml11(true);
            }
        }
        catch (IOException ie2) {
            throw new WstxIOException(ie2);
        }
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource(cfg, bs2, null, systemId, r2, autoCloseInput);
        return ValidatingStreamReader.createValidatingStreamReader(input, this, cfg, bs2, forER);
    }

    public XMLStreamReader2 createSR(ReaderConfig cfg, String systemId, InputBootstrapper bs2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        URL src = cfg.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie2) {
                throw new WstxIOException(ie2);
            }
        }
        return this.doCreateSR(cfg, SystemId.construct(systemId, src), bs2, forER, autoCloseInput);
    }

    public XMLStreamReader2 createSR(ReaderConfig cfg, SystemId systemId, InputBootstrapper bs2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        return this.doCreateSR(cfg, systemId, bs2, forER, autoCloseInput);
    }

    protected XMLStreamReader2 createSR(SystemId systemId, InputStream in2, String enc, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        if (in2 == null) {
            throw new IllegalArgumentException("Null InputStream is not a valid argument");
        }
        ReaderConfig cfg = this.createPrivateConfig();
        if (enc == null || enc.length() == 0) {
            return this.createSR(cfg, systemId, (InputBootstrapper)StreamBootstrapper.getInstance(null, systemId, in2), forER, autoCloseInput);
        }
        Reader r2 = DefaultInputResolver.constructOptimizedReader(cfg, in2, false, enc);
        return this.createSR(cfg, systemId, (InputBootstrapper)ReaderBootstrapper.getInstance(null, systemId, r2, enc), forER, autoCloseInput);
    }

    protected XMLStreamReader2 createSR(ReaderConfig cfg, URL src, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        SystemId systemId = SystemId.construct(src);
        try {
            return this.createSR(cfg, systemId, URLUtil.inputStreamFromURL(src), forER, autoCloseInput);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    private XMLStreamReader2 createSR(ReaderConfig cfg, SystemId systemId, InputStream in2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        return this.doCreateSR(cfg, systemId, StreamBootstrapper.getInstance(null, systemId, in2), forER, autoCloseInput);
    }

    protected XMLStreamReader2 createSR(SystemId systemId, Reader r2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        return this.createSR(this.createPrivateConfig(), systemId, (InputBootstrapper)ReaderBootstrapper.getInstance(null, systemId, r2, null), forER, autoCloseInput);
    }

    protected XMLStreamReader2 createSR(File f2, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        ReaderConfig cfg = this.createPrivateConfig();
        try {
            URL base;
            if (!f2.isAbsolute() && (base = cfg.getBaseURL()) != null) {
                URL src = new URL(base, f2.getPath());
                return this.createSR(cfg, SystemId.construct(src), URLUtil.inputStreamFromURL(src), forER, autoCloseInput);
            }
            SystemId systemId = SystemId.construct(f2.toURL());
            return this.createSR(cfg, systemId, new FileInputStream(f2), forER, autoCloseInput);
        }
        catch (IOException ie2) {
            throw new WstxIOException(ie2);
        }
    }

    protected XMLStreamReader2 createSR(Source src, boolean forER) throws XMLStreamException {
        boolean autoCloseInput;
        Source ss;
        ReaderConfig cfg = this.createPrivateConfig();
        Reader r2 = null;
        InputStream in2 = null;
        String pubId = null;
        String sysId = null;
        String encoding = null;
        InputBootstrapper bs2 = null;
        if (src instanceof Stax2Source) {
            ss = (Stax2Source)src;
            sysId = ((Stax2Source)ss).getSystemId();
            pubId = ((Stax2Source)ss).getPublicId();
            encoding = ((Stax2Source)ss).getEncoding();
            try {
                if (src instanceof Stax2ByteArraySource) {
                    Stax2ByteArraySource bas = (Stax2ByteArraySource)src;
                    bs2 = StreamBootstrapper.getInstance(pubId, SystemId.construct(sysId), bas.getBuffer(), bas.getBufferStart(), bas.getBufferEnd());
                } else {
                    in2 = ((Stax2Source)ss).constructInputStream();
                    if (in2 == null) {
                        r2 = ((Stax2Source)ss).constructReader();
                    }
                }
            }
            catch (IOException ioe) {
                throw new WstxIOException(ioe);
            }
            autoCloseInput = true;
        } else if (src instanceof StreamSource) {
            ss = (StreamSource)src;
            sysId = ((StreamSource)ss).getSystemId();
            pubId = ((StreamSource)ss).getPublicId();
            in2 = ((StreamSource)ss).getInputStream();
            if (in2 == null) {
                r2 = ((StreamSource)ss).getReader();
            }
            autoCloseInput = cfg.willAutoCloseInput();
        } else if (src instanceof SAXSource) {
            ss = (SAXSource)src;
            sysId = ((SAXSource)ss).getSystemId();
            InputSource isrc = ((SAXSource)ss).getInputSource();
            if (isrc != null) {
                encoding = isrc.getEncoding();
                in2 = isrc.getByteStream();
                if (in2 == null) {
                    r2 = isrc.getCharacterStream();
                }
            }
            autoCloseInput = cfg.willAutoCloseInput();
        } else {
            if (src instanceof DOMSource) {
                DOMSource domSrc = (DOMSource)src;
                return WstxDOMWrappingReader.createFrom(domSrc, cfg);
            }
            throw new IllegalArgumentException("Can not instantiate Stax reader for XML source type " + src.getClass() + " (unrecognized type)");
        }
        if (bs2 == null) {
            if (r2 != null) {
                bs2 = ReaderBootstrapper.getInstance(pubId, SystemId.construct(sysId), r2, encoding);
            } else if (in2 != null) {
                bs2 = StreamBootstrapper.getInstance(pubId, SystemId.construct(sysId), in2);
            } else {
                if (sysId != null && sysId.length() > 0) {
                    autoCloseInput = true;
                    try {
                        return this.createSR(cfg, URLUtil.urlFromSystemId(sysId), forER, autoCloseInput);
                    }
                    catch (IOException ioe) {
                        throw new WstxIOException(ioe);
                    }
                }
                throw new XMLStreamException("Can not create Stax reader for the Source passed -- neither reader, input stream nor system id was accessible; can not use other types of sources (like embedded SAX streams)");
            }
        }
        return this.createSR(cfg, sysId, bs2, forER, autoCloseInput);
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this.mAllocator != null) {
            return this.mAllocator.newInstance();
        }
        return this.mConfig.willPreserveLocation() ? DefaultEventAllocator.getDefaultInstance() : DefaultEventAllocator.getFastInstance();
    }

    public ReaderConfig createPrivateConfig() {
        return this.mConfig.createNonShared(this.mSymbols.makeChild());
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

