/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import javax.xml.namespace.QName;

public final class ElemAttrs {
    private static final int OFFSET_NS_URI = 1;
    private final String[] mRawAttrs;
    private final int mDefaultOffset;
    private final int[] mAttrMap;
    private final int mAttrHashSize;
    private final int mAttrSpillEnd;

    public ElemAttrs(String[] rawAttrs, int defOffset) {
        this.mRawAttrs = rawAttrs;
        this.mAttrMap = null;
        this.mAttrHashSize = 0;
        this.mAttrSpillEnd = 0;
        this.mDefaultOffset = defOffset << 2;
    }

    public ElemAttrs(String[] rawAttrs, int defOffset, int[] attrMap, int hashSize, int spillEnd) {
        this.mRawAttrs = rawAttrs;
        this.mDefaultOffset = defOffset << 2;
        this.mAttrMap = attrMap;
        this.mAttrHashSize = hashSize;
        this.mAttrSpillEnd = spillEnd;
    }

    public String[] getRawAttrs() {
        return this.mRawAttrs;
    }

    public int findIndex(QName name) {
        if (this.mAttrMap != null) {
            return this.findMapIndex(name.getNamespaceURI(), name.getLocalPart());
        }
        String ln = name.getLocalPart();
        String uri = name.getNamespaceURI();
        boolean defaultNs = uri == null || uri.length() == 0;
        String[] raw = this.mRawAttrs;
        int len = raw.length;
        for (int i2 = 0; i2 < len; i2 += 4) {
            if (!ln.equals(raw[i2])) continue;
            String thisUri = raw[i2 + 1];
            if (!(defaultNs ? thisUri == null || thisUri.length() == 0 : thisUri != null && (thisUri == uri || thisUri.equals(uri)))) continue;
            return i2;
        }
        return -1;
    }

    public int getFirstDefaultOffset() {
        return this.mDefaultOffset;
    }

    public boolean isDefault(int ix2) {
        return ix2 >= this.mDefaultOffset;
    }

    private final int findMapIndex(String nsURI, String localName) {
        int hash = localName.hashCode();
        if (nsURI == null) {
            nsURI = "";
        } else if (nsURI.length() > 0) {
            hash ^= nsURI.hashCode();
        }
        int ix2 = this.mAttrMap[hash & this.mAttrHashSize - 1];
        if (ix2 == 0) {
            return -1;
        }
        String[] raw = this.mRawAttrs;
        String thisName = raw[ix2 = ix2 - 1 << 2];
        if (thisName == localName || thisName.equals(localName)) {
            String thisURI = raw[ix2 + 1];
            if (thisURI == nsURI) {
                return ix2;
            }
            if (thisURI == null ? nsURI.length() == 0 : thisURI.equals(nsURI)) {
                return ix2;
            }
        }
        int len = this.mAttrSpillEnd;
        for (int i2 = this.mAttrHashSize; i2 < len; i2 += 2) {
            if (this.mAttrMap[i2] != hash || (thisName = raw[ix2 = this.mAttrMap[i2 + 1] << 2]) != localName && !thisName.equals(localName)) continue;
            String thisURI = raw[ix2 + 1];
            if (thisURI == nsURI) {
                return ix2;
            }
            if (!(thisURI == null ? nsURI.length() == 0 : thisURI.equals(nsURI))) continue;
            return ix2;
        }
        return -1;
    }
}

