/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.util.BaseNsContext;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Namespace;
import org.codehaus.stax2.ri.EmptyIterator;

public class MergedNsContext
extends BaseNsContext {
    final NamespaceContext mParentCtxt;
    final List mNamespaces;
    Map mNsByPrefix = null;
    Map mNsByURI = null;

    protected MergedNsContext(NamespaceContext parentCtxt, List localNs) {
        this.mParentCtxt = parentCtxt;
        this.mNamespaces = localNs == null ? Collections.EMPTY_LIST : localNs;
    }

    public static BaseNsContext construct(NamespaceContext parentCtxt, List localNs) {
        return new MergedNsContext(parentCtxt, localNs);
    }

    public String doGetNamespaceURI(String prefix) {
        Namespace ns;
        if (this.mNsByPrefix == null) {
            this.mNsByPrefix = this.buildByPrefixMap();
        }
        if ((ns = (Namespace)this.mNsByPrefix.get(prefix)) == null && this.mParentCtxt != null) {
            return this.mParentCtxt.getNamespaceURI(prefix);
        }
        return ns == null ? null : ns.getNamespaceURI();
    }

    public String doGetPrefix(String nsURI) {
        Namespace ns;
        if (this.mNsByURI == null) {
            this.mNsByURI = this.buildByNsURIMap();
        }
        if ((ns = (Namespace)this.mNsByURI.get(nsURI)) == null && this.mParentCtxt != null) {
            return this.mParentCtxt.getPrefix(nsURI);
        }
        return ns == null ? null : ns.getPrefix();
    }

    public Iterator doGetPrefixes(String nsURI) {
        ArrayList<String> l2 = null;
        int len = this.mNamespaces.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String prefix;
            Namespace ns = (Namespace)this.mNamespaces.get(i2);
            String uri = ns.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if (!uri.equals(nsURI)) continue;
            if (l2 == null) {
                l2 = new ArrayList<String>();
            }
            l2.add((prefix = ns.getPrefix()) == null ? "" : prefix);
        }
        if (this.mParentCtxt != null) {
            Iterator it2 = this.mParentCtxt.getPrefixes(nsURI);
            if (l2 == null) {
                return it2;
            }
            while (it2.hasNext()) {
                l2.add((String)it2.next());
            }
        }
        return l2 == null ? EmptyIterator.getInstance() : l2.iterator();
    }

    public Iterator getNamespaces() {
        return this.mNamespaces.iterator();
    }

    public void outputNamespaceDeclarations(Writer w2) throws IOException {
        int len = this.mNamespaces.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Namespace ns = (Namespace)this.mNamespaces.get(i2);
            w2.write(32);
            w2.write("xmlns");
            if (!ns.isDefaultNamespaceDeclaration()) {
                w2.write(58);
                w2.write(ns.getPrefix());
            }
            w2.write("=\"");
            w2.write(ns.getNamespaceURI());
            w2.write(34);
        }
    }

    public void outputNamespaceDeclarations(XMLStreamWriter w2) throws XMLStreamException {
        int len = this.mNamespaces.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Namespace ns = (Namespace)this.mNamespaces.get(i2);
            if (ns.isDefaultNamespaceDeclaration()) {
                w2.writeDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            w2.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
        }
    }

    private Map buildByPrefixMap() {
        int len = this.mNamespaces.size();
        if (len == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Namespace> m2 = new LinkedHashMap<String, Namespace>(1 + len + (len >> 1));
        for (int i2 = 0; i2 < len; ++i2) {
            Namespace ns = (Namespace)this.mNamespaces.get(i2);
            String prefix = ns.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            m2.put(prefix, ns);
        }
        return m2;
    }

    private Map buildByNsURIMap() {
        int len = this.mNamespaces.size();
        if (len == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Namespace> m2 = new LinkedHashMap<String, Namespace>(1 + len + (len >> 1));
        for (int i2 = 0; i2 < len; ++i2) {
            Namespace ns = (Namespace)this.mNamespaces.get(i2);
            String uri = ns.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            m2.put(uri, ns);
        }
        return m2;
    }
}

