/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.BaseStartElement;
import com.ctc.wstx.io.TextEscaper;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.util.BaseNsContext;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.SingletonIterator;
import org.codehaus.stax2.ri.evt.AttributeEventImpl;

public class CompactStartElement
extends BaseStartElement {
    private static final int OFFSET_NS_URI = 1;
    private static final int OFFSET_NS_PREFIX = 2;
    private static final int OFFSET_VALUE = 3;
    final ElemAttrs mAttrs;
    final String[] mRawAttrs;
    private ArrayList mAttrList = null;

    protected CompactStartElement(Location loc, QName name, BaseNsContext nsCtxt, ElemAttrs attrs) {
        super(loc, name, nsCtxt);
        this.mAttrs = attrs;
        this.mRawAttrs = attrs == null ? null : attrs.getRawAttrs();
    }

    public Attribute getAttributeByName(QName name) {
        if (this.mAttrs == null) {
            return null;
        }
        int ix2 = this.mAttrs.findIndex(name);
        if (ix2 < 0) {
            return null;
        }
        return this.constructAttr(this.mRawAttrs, ix2, !this.mAttrs.isDefault(ix2));
    }

    public Iterator getAttributes() {
        if (this.mAttrList == null) {
            if (this.mAttrs == null) {
                return EmptyIterator.getInstance();
            }
            String[] rawAttrs = this.mRawAttrs;
            int rawLen = rawAttrs.length;
            int defOffset = this.mAttrs.getFirstDefaultOffset();
            if (rawLen == 4) {
                return new SingletonIterator(this.constructAttr(rawAttrs, 0, defOffset == 0));
            }
            ArrayList<Attribute> l2 = new ArrayList<Attribute>(rawLen >> 2);
            for (int i2 = 0; i2 < rawLen; i2 += 4) {
                l2.add(this.constructAttr(rawAttrs, i2, i2 >= defOffset));
            }
            this.mAttrList = l2;
        }
        return this.mAttrList.iterator();
    }

    protected void outputNsAndAttr(Writer w2) throws IOException {
        String[] raw;
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(w2);
        }
        if ((raw = this.mRawAttrs) != null) {
            int len = raw.length;
            for (int i2 = 0; i2 < len; i2 += 4) {
                w2.write(32);
                String prefix = raw[i2 + 2];
                if (prefix != null && prefix.length() > 0) {
                    w2.write(prefix);
                    w2.write(58);
                }
                w2.write(raw[i2]);
                w2.write("=\"");
                TextEscaper.writeEscapedAttrValue(w2, raw[i2 + 3]);
                w2.write(34);
            }
        }
    }

    protected void outputNsAndAttr(XMLStreamWriter w2) throws XMLStreamException {
        String[] raw;
        if (this.mNsCtxt != null) {
            this.mNsCtxt.outputNamespaceDeclarations(w2);
        }
        if ((raw = this.mRawAttrs) != null) {
            int len = raw.length;
            for (int i2 = 0; i2 < len; i2 += 4) {
                String ln = raw[i2];
                String prefix = raw[i2 + 2];
                String nsURI = raw[i2 + 1];
                w2.writeAttribute(prefix, nsURI, ln, raw[i2 + 3]);
            }
        }
    }

    public Attribute constructAttr(String[] raw, int rawIndex, boolean isDef) {
        return new AttributeEventImpl(this.mLocation, raw[rawIndex], raw[rawIndex + 1], raw[rawIndex + 2], raw[rawIndex + 3], isDef);
    }
}

