/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.PrefixedNameSet;
import com.ctc.wstx.util.PrefixedName;
import java.util.Iterator;
import java.util.TreeSet;

public final class LargePrefixedNameSet
extends PrefixedNameSet {
    static final int MIN_HASH_AREA = 8;
    final boolean mNsAware;
    final PrefixedName[] mNames;
    final Bucket[] mBuckets;

    public LargePrefixedNameSet(boolean nsAware, PrefixedName[] names) {
        int tableSize;
        this.mNsAware = nsAware;
        int len = names.length;
        int minSize = len + (len + 7 >> 3);
        for (tableSize = 8; tableSize < minSize; tableSize += tableSize) {
        }
        this.mNames = new PrefixedName[tableSize];
        Bucket[] buckets = null;
        int mask = tableSize - 1;
        for (int i2 = 0; i2 < len; ++i2) {
            Bucket old;
            PrefixedName nk = names[i2];
            int ix2 = nk.hashCode() & mask;
            if (this.mNames[ix2] == null) {
                this.mNames[ix2] = nk;
                continue;
            }
            ix2 >>= 2;
            if (buckets == null) {
                buckets = new Bucket[tableSize >> 2];
                old = null;
            } else {
                old = buckets[ix2];
            }
            buckets[ix2] = new Bucket(nk, old);
        }
        this.mBuckets = buckets;
    }

    public boolean hasMultiple() {
        return true;
    }

    public boolean contains(PrefixedName name) {
        PrefixedName[] hashArea = this.mNames;
        int index = name.hashCode() & hashArea.length - 1;
        PrefixedName res = hashArea[index];
        if (res != null && res.equals(name)) {
            return true;
        }
        Bucket[] buckets = this.mBuckets;
        if (buckets != null) {
            for (Bucket bucket = buckets[index >> 2]; bucket != null; bucket = bucket.getNext()) {
                res = bucket.getName();
                if (!res.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void appendNames(StringBuffer sb, String sep) {
        int i2;
        TreeSet<PrefixedName> ts = new TreeSet<PrefixedName>();
        for (i2 = 0; i2 < this.mNames.length; ++i2) {
            PrefixedName name = this.mNames[i2];
            if (name == null) continue;
            ts.add(name);
        }
        if (this.mBuckets != null) {
            for (i2 = 0; i2 < this.mNames.length >> 2; ++i2) {
                for (Bucket b2 = this.mBuckets[i2]; b2 != null; b2 = b2.getNext()) {
                    ts.add(b2.getName());
                }
            }
        }
        Iterator it2 = ts.iterator();
        boolean first = true;
        while (it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(sep);
            }
            sb.append(it2.next().toString());
        }
    }

    private static final class Bucket {
        final PrefixedName mName;
        final Bucket mNext;

        public Bucket(PrefixedName name, Bucket next) {
            this.mName = name;
            this.mNext = next;
        }

        public PrefixedName getName() {
            return this.mName;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public boolean contains(PrefixedName n2) {
            return this.mName.equals(n2);
        }
    }
}

