/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.api.ValidatorConfig;
import com.ctc.wstx.dtd.FullDTDReader;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.ReaderSource;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.SystemId;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

public class DTDSchemaFactory
extends XMLValidationSchemaFactory {
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    protected final ValidatorConfig mSchemaConfig;
    protected final ReaderConfig mReaderConfig = ReaderConfig.createFullDefaults();

    public DTDSchemaFactory() {
        super("http://www.w3.org/XML/1998/namespace");
        this.mSchemaConfig = ValidatorConfig.createDefaults();
    }

    public boolean isPropertySupported(String propName) {
        return this.mSchemaConfig.isPropertySupported(propName);
    }

    public boolean setProperty(String propName, Object value) {
        return this.mSchemaConfig.setProperty(propName, value);
    }

    public Object getProperty(String propName) {
        return this.mSchemaConfig.getProperty(propName);
    }

    public XMLValidationSchema createSchema(InputStream in2, String encoding, String publicId, String systemId) throws XMLStreamException {
        ReaderConfig rcfg = this.createPrivateReaderConfig();
        return this.doCreateSchema(rcfg, StreamBootstrapper.getInstance(publicId, SystemId.construct(systemId), in2), publicId, systemId, null);
    }

    public XMLValidationSchema createSchema(Reader r2, String publicId, String systemId) throws XMLStreamException {
        ReaderConfig rcfg = this.createPrivateReaderConfig();
        return this.doCreateSchema(rcfg, ReaderBootstrapper.getInstance(publicId, SystemId.construct(systemId), r2, null), publicId, systemId, null);
    }

    public XMLValidationSchema createSchema(URL url) throws XMLStreamException {
        ReaderConfig rcfg = this.createPrivateReaderConfig();
        try {
            InputStream in2 = URLUtil.inputStreamFromURL(url);
            return this.doCreateSchema(rcfg, StreamBootstrapper.getInstance(null, null, in2), null, url.toExternalForm(), url);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public XMLValidationSchema createSchema(File f2) throws XMLStreamException {
        ReaderConfig rcfg = this.createPrivateReaderConfig();
        try {
            URL url = f2.toURL();
            return this.doCreateSchema(rcfg, StreamBootstrapper.getInstance(null, null, new FileInputStream(f2)), null, url.toExternalForm(), url);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected XMLValidationSchema doCreateSchema(ReaderConfig rcfg, InputBootstrapper bs2, String publicId, String systemIdStr, URL ctxt) throws XMLStreamException {
        try {
            Reader r2 = bs2.bootstrapInput(rcfg, false, 0);
            if (bs2.declaredXml11()) {
                rcfg.enableXml11(true);
            }
            if (ctxt == null) {
                ctxt = URLUtil.urlFromCurrentDir();
            }
            SystemId systemId = SystemId.construct(systemIdStr, ctxt);
            ReaderSource src = InputSourceFactory.constructEntitySource(rcfg, null, null, bs2, publicId, systemId, 0, r2);
            return FullDTDReader.readExternalSubset(src, rcfg, null, true, bs2.getDeclaredVersion());
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    private ReaderConfig createPrivateReaderConfig() {
        return this.mReaderConfig.createNonShared(mRootSymbols.makeChild());
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

