/*
 * Decompiled with CFR 0.152.
 */
package org.swift.jira.cot.functions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.swift.jira.cot.functions.AbstractCreateFunctionPluginFactory;
import org.swift.jira.library.Utilities;

public class CreateSubIssueFunctionPluginFactory
extends AbstractCreateFunctionPluginFactory
implements WorkflowPluginFunctionFactory {
    public CreateSubIssueFunctionPluginFactory(IssueManager issueManager, SubTaskManager subTaskManager, IssueTypeManager issueTypeManager, ConstantsManager constantsManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher, I18nResolver i18nResolver, PluginLicenseManager licenseManager, JiraLicenseService jiraLicenseService) {
        super(issueManager, subTaskManager, issueTypeManager, constantsManager, applicationProperties, authenticationContext, i18nBeanFactory, eventPublisher, i18nResolver, licenseManager, jiraLicenseService);
    }

    @Override
    public void addDescriptorParams(Map<String, String> params, Map<String, Object> conditionParams) {
        params.put("field.createSibling", this.extractSingleParam(conditionParams, "createSibling"));
        params.put("field.subIssueSummary", this.extractSingleParam(conditionParams, "subIssueSummary"));
        params.put("field.subIssueDescription", this.extractSingleParam(conditionParams, "subIssueDescription"));
        params.put("field.entryParent", this.extractSingleParam(conditionParams, "entryParent"));
        params.put("field.subIssueTypeId", this.extractSingleParam(conditionParams, "subIssueTypeId"));
        params.put("field.subIssuePriorityId", this.extractSingleParam(conditionParams, "subIssuePriorityId"));
        params.put("field.subIssueReporter", this.extractSingleParam(conditionParams, "subIssueReporter"));
        params.put("field.subIssueAssignee", this.extractSingleParam(conditionParams, "subIssueAssignee"));
        params.put("field.subIssueAffectedVersions", this.extractSingleParam(conditionParams, "subIssueAffectedVersions"));
        params.put("field.subIssueFixedVersions", this.extractSingleParam(conditionParams, "subIssueFixedVersions"));
        params.put("field.subIssueComponents", this.extractSingleParam(conditionParams, "subIssueComponents"));
        params.put("field.subIssueDueDate", this.extractSingleParam(conditionParams, "subIssueDueDate"));
        params.put("field.subIssueOriginalEstimate", this.extractSingleParam(conditionParams, "subIssueOriginalEstimate"));
        params.put("field.subIssueRemainingEstimate", this.extractSingleParam(conditionParams, "subIssueRemainingEstimate"));
        this.putParameterWithCheck("subtaskPreCreate", params, conditionParams);
    }

    @Override
    protected boolean continueWithView(FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getArgs().get("field.subIssueTypeId") != null;
    }

    @Override
    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor inDescriptor) {
        super.getVelocityParamsForView(velocityParams, inDescriptor);
        FunctionDescriptor descriptor = (FunctionDescriptor)inDescriptor;
        if (this.continueWithView(descriptor)) {
            velocityParams.put("createSibling", descriptor.getArgs().get("field.createSibling"));
            String entryParent = (String)descriptor.getArgs().get("field.entryParent");
            velocityParams.put("entryParent", StringUtils.isBlank((String)entryParent) ? "%parent_key%" : entryParent);
            String issueTypeId = (String)descriptor.getArgs().get("field.subIssueTypeId");
            velocityParams.put("subIssueTypeId", issueTypeId);
            IssueType issueType = this.subTaskManager.getSubTaskIssueType(issueTypeId);
            velocityParams.put("issueTypeName", issueType == null ? "" : issueType.getName());
            velocityParams.put("subIssuePriorityId", descriptor.getArgs().get("field.subIssuePriorityId"));
            Priority priority = this.constantsManager.getPriorityObject((String)descriptor.getArgs().get("field.subIssuePriorityId"));
            velocityParams.put("issuePriorityName", priority != null ? priority.getName() : "");
            velocityParams.put("subIssueSummary", descriptor.getArgs().get("field.subIssueSummary"));
            velocityParams.put("subIssueDescription", descriptor.getArgs().get("field.subIssueDescription"));
            int reporter = 5;
            int assignee = 1;
            try {
                reporter = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueReporter"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                assignee = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueAssignee"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("subIssueReporterName", this.choices.getUserText(reporter));
            velocityParams.put("subIssueAssigneeName", this.choices.getUserText(assignee));
            int affectedVersions = 0;
            int fixedVersions = 0;
            try {
                affectedVersions = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueAffectedVersions"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fixedVersions = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueFixedVersions"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("subIssueAffectedVersionsName", this.choices.getVersionText(affectedVersions));
            velocityParams.put("subIssueFixedVersionsName", this.choices.getVersionText(fixedVersions));
            int components = 1;
            try {
                components = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueComponents"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("subIssueComponentsName", this.choices.getComponentText(components));
            int dueDate = 0;
            try {
                dueDate = Integer.parseInt((String)descriptor.getArgs().get("field.subIssueDueDate"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("subIssueDueDate", this.choices.getDueDateText(dueDate));
            String subIssueOriginalEstimate = (String)descriptor.getArgs().get("field.subIssueOriginalEstimate");
            velocityParams.put("subIssueOriginalEstimate", subIssueOriginalEstimate == null ? "" : subIssueOriginalEstimate);
            String subIssueRemainingEstimate = (String)descriptor.getArgs().get("field.subIssueRemainingEstimate");
            velocityParams.put("subIssueRemainingEstimate", subIssueRemainingEstimate == null ? "" : subIssueRemainingEstimate);
            velocityParams.put("subtaskPreCreate", descriptor.getArgs().get("field.subtaskPreCreate"));
        }
    }

    @Override
    protected void getVelocityParamsForInput(Map velocityParams) {
        super.getVelocityParamsForInput(velocityParams);
        velocityParams.put("createSibling", "0");
        velocityParams.put("entryParent", "%parent_key%");
        velocityParams.put("subIssueTypes", this.subTaskManager.getSubTaskIssueTypeObjects());
        velocityParams.put("subIssuePriorities", this.constantsManager.getPriorities());
        velocityParams.put("currentSubIssueReporter", 5);
        velocityParams.put("currentSubIssueAssignee", 1);
        velocityParams.put("currentSubIssueAffectedVersions", 0);
        velocityParams.put("currentSubIssueFixedVersions", 0);
        velocityParams.put("currentSubIssueComponents", 1);
        velocityParams.put("currentSubIssueSummary", "%parent_summary%");
        velocityParams.put("currentSubIssueDueDate", 0);
        velocityParams.put("currentSubIssueOriginalEstimate", "");
        velocityParams.put("currentSubIssueRemainingEstimate", "");
    }

    @Override
    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor inDescriptor) {
        super.getVelocityParamsForEdit(velocityParams, inDescriptor);
        FunctionDescriptor descriptor = (FunctionDescriptor)inDescriptor;
        String entryParent = (String)descriptor.getArgs().get("field.entryParent");
        velocityParams.put("currentEntryParent", StringUtils.isBlank((String)entryParent) ? "%parent_key%" : entryParent);
        velocityParams.put("currentSubIssueTypeId", descriptor.getArgs().get("field.subIssueTypeId"));
        velocityParams.put("currentCreateSibling", descriptor.getArgs().get("field.createSibling"));
        velocityParams.put("currentSubIssueSummary", descriptor.getArgs().get("field.subIssueSummary"));
        velocityParams.put("currentSubIssueDescription", descriptor.getArgs().get("field.subIssueDescription"));
        velocityParams.put("currentSubIssuePriorityId", descriptor.getArgs().get("field.subIssuePriorityId"));
        velocityParams.put("subIssueTypes", this.subTaskManager.getSubTaskIssueTypeObjects());
        velocityParams.put("subIssuePriorities", this.constantsManager.getPriorities());
        int reporter = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueReporter")), (int)5);
        velocityParams.put("currentSubIssueReporter", reporter);
        int assignee = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueAssignee")), (int)1);
        velocityParams.put("currentSubIssueAssignee", assignee);
        int affectedVersions = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueAffectedVersions")), (int)0);
        velocityParams.put("currentSubIssueAffectedVersions", affectedVersions);
        int fixedVersions = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueFixedVersions")), (int)0);
        velocityParams.put("currentSubIssueFixedVersions", fixedVersions);
        int components = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueComponents")), (int)1);
        velocityParams.put("currentSubIssueComponents", components);
        int dueDate = Utilities.getInt((String)((String)descriptor.getArgs().get("field.subIssueDueDate")), (int)0);
        velocityParams.put("currentSubIssueDueDate", dueDate);
        String subIssueOriginalEstimate = (String)descriptor.getArgs().get("field.subIssueOriginalEstimate");
        velocityParams.put("currentSubIssueOriginalEstimate", subIssueOriginalEstimate == null ? "" : subIssueOriginalEstimate);
        String subIssueRemainingEstimate = (String)descriptor.getArgs().get("field.subIssueRemainingEstimate");
        velocityParams.put("currentSubIssueRemainingEstimate", subIssueRemainingEstimate == null ? "" : subIssueRemainingEstimate);
        String currentSubtaskPreCreate = (String)descriptor.getArgs().get("field.subtaskPreCreate");
        velocityParams.put("currentSubtaskPreCreate", currentSubtaskPreCreate == null ? "" : currentSubtaskPreCreate);
    }
}

