/*
 * Decompiled with CFR 0.152.
 */
package org.swift.jira.cot.functions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.swift.jira.cot.functions.AbstractCreateFunction;
import org.swift.jira.cot.utilities.Helper;
import org.swift.jira.library.Utilities;

public class CreateSubIssueFunction
extends AbstractCreateFunction {
    public CreateSubIssueFunction(CustomFieldManager customFieldManager, SubTaskManager subTaskManager, IssueManager issueManager, IssueFactory issueFactory, ConstantsManager constantsManager, ApplicationProperties applicationProperties, UserUtil userUtil, GroupManager groupManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher, BuildUtilsInfo buildInfo, OptionsManager optionsManager, WatcherManager watcherManager, IssueLinkManager issueLinkManager, IssueLinkTypeManager issueLinkTypeManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueTypeSchemeManager issueTypeSchemeManager, AttachmentManager attachmentManager, AttachmentPathManager attachmentPathManager, CommentManager commentManager, VersionManager versionManager, ProjectManager projectManager, SearchService searchService, JiraHome jiraHome, I18nResolver i18nResolver, PluginLicenseManager licenseManager, JiraLicenseService jiraLicenseService) {
        super(customFieldManager, subTaskManager, issueManager, issueFactory, constantsManager, applicationProperties, userUtil, groupManager, projectRoleManager, permissionManager, authenticationContext, i18nBeanFactory, eventPublisher, buildInfo, optionsManager, watcherManager, issueLinkManager, issueLinkTypeManager, issueSecurityLevelManager, issueTypeSchemeManager, attachmentManager, attachmentPathManager, commentManager, versionManager, projectManager, searchService, jiraHome, i18nResolver, licenseManager, jiraLicenseService);
    }

    @Override
    protected boolean verifyPreConditions(Helper helper) {
        boolean allowSiblingCreate = 1 == Utilities.getInt((String)((String)helper.getReplaceHelper().getArgs().get("field.createSibling")), (int)0);
        return allowSiblingCreate || !helper.getReplaceHelper().getOriginalIssue().getIssueType().isSubTask();
    }

    @Override
    protected boolean verifyPreConditionsAfterJql(Helper helper) {
        boolean shouldContinue = true;
        String entryParent = (String)helper.getReplaceHelper().getArgs().get("field.entryParent");
        if (StringUtils.isNotBlank((CharSequence)entryParent)) {
            entryParent = helper.getReplaceHelper().findReplace(entryParent);
        }
        helper.getReplaceHelper().setEntryParentIssue((Issue)(StringUtils.isBlank((CharSequence)entryParent) || entryParent.trim().equalsIgnoreCase("%parent_key%") ? helper.getReplaceHelper().getParentIssue() : this.issueManager.getIssueObject(entryParent.trim().toUpperCase())));
        if (helper.getReplaceHelper().getEntryParentIssue() == null) {
            this.log.error("Unable to find issue with key {}. Subtasks can not created.", (Object)entryParent);
            shouldContinue = false;
        } else if (helper.getReplaceHelper().getEntryParentIssue().isSubTask()) {
            this.log.error("Issue with key {} is a subtask. This is an invalid parent. Subtasks can not created.", (Object)entryParent);
            shouldContinue = false;
        }
        return shouldContinue;
    }

    @Override
    protected void doPostTasks(Helper helper, Issue newIssue) {
        Issue entryParentIssue = helper.getReplaceHelper().getEntryParentIssue();
        try {
            this.log.debug("Now link new issue: {}, as a subtask of parent: {}", (Object)newIssue.getKey(), (Object)entryParentIssue.getKey());
            this.subTaskManager.createSubTaskIssueLink(entryParentIssue, newIssue, helper.getReplaceHelper().getTransitionUser());
        }
        catch (CreateException exception) {
            this.log.debug("New issue: {}, parent issue: {}", (Object)newIssue, (Object)entryParentIssue);
            this.log.error("Unexpected create exception linking subtask to parent: {}", (Object)exception.toString(), (Object)exception);
        }
        catch (Exception exception) {
            this.log.debug("New issue: {}, parent issue: {}", (Object)newIssue, (Object)entryParentIssue);
            this.log.error("Unexpected exception linking subtask to parent: {}", (Object)exception.toString(), (Object)exception);
        }
        super.doPostTasks(helper, newIssue);
    }

    @Override
    protected void setFields(Helper helper, MutableIssue newIssue) {
        Issue originalIssue = helper.getReplaceHelper().getOriginalIssue();
        Issue parentIssue = helper.getReplaceHelper().getParentIssue();
        Issue entryParentIssue = helper.getReplaceHelper().getEntryParentIssue();
        Map args = helper.getReplaceHelper().getArgs();
        this.log.debug("Set field values for parent issue: {}, initiating issue was: {}", (Object)parentIssue.getKey(), (Object)originalIssue.getKey());
        try {
            IssueType issueType;
            String type;
            boolean subtaskPreCreate;
            Project targetProject = entryParentIssue.getProjectObject();
            newIssue.setProjectId(targetProject.getId());
            boolean bl = subtaskPreCreate = 1 == Utilities.getInt((String)((String)helper.getReplaceHelper().getArgs().get("field.subtaskPreCreate")), (int)0);
            if (subtaskPreCreate) {
                this.log.debug("Subtask pre-create selected");
                newIssue.setParentObject(entryParentIssue);
            }
            if ((type = Utilities.getString((String)((String)args.get("field.subIssueTypeId")), (String)"0")).equals("-1")) {
                type = helper.getReplaceHelper().findReplace((String)args.get("field.specificIssueType"));
            }
            if ((issueType = this.lookupIssueType(targetProject, type, true, null)) != null) {
                newIssue.setIssueTypeObject(issueType);
                this.setCommonFields(helper, newIssue);
                newIssue.setSecurityLevelId(entryParentIssue.getSecurityLevelId());
                int priority = Utilities.getInt((String)((String)args.get("field.subIssuePriorityId")), (int)0);
                Priority priorityObject = null;
                priorityObject = priority == -2 ? this.lookupPriority(helper.getReplaceHelper().findReplace((String)args.get("field.specificPriority")), null) : (priority == 0 ? parentIssue.getPriority() : this.constantsManager.getPriorityObject((String)args.get("field.subIssuePriorityId")));
                newIssue.setPriorityObject(priorityObject);
                String issueSummary = helper.getReplaceHelper().findReplace((String)args.get("field.subIssueSummary"));
                if (issueSummary.length() > 255) {
                    issueSummary = issueSummary.substring(0, 255);
                    this.log.info("Summary was truncated to 255 characters while creating the subtask to avoid failure.");
                }
                newIssue.setSummary(issueSummary);
                newIssue.setDescription(helper.getReplaceHelper().findReplace((String)args.get("field.subIssueDescription")));
                newIssue.setLabels(LabelParser.buildFromString((String)helper.getReplaceHelper().findReplace((String)args.get("field.labels"))));
                int affectedVersions = Utilities.getInt((String)((String)args.get("field.subIssueAffectedVersions")), (int)0);
                newIssue.setAffectedVersions(this.getVersions(helper, affectedVersions, (String)args.get("field.specificAffectedVersions"), newIssue.getProjectObject()));
                int fixedVersions = Utilities.getInt((String)((String)args.get("field.subIssueFixedVersions")), (int)0);
                newIssue.setFixVersions(this.getVersions(helper, fixedVersions, (String)args.get("field.specificFixedVersions"), newIssue.getProjectObject()));
                int components = Utilities.getInt((String)((String)args.get("field.subIssueComponents")), (int)1);
                newIssue.setComponent(this.getComponents(helper, components, (String)args.get("field.specificComponents"), targetProject));
                int reporter = Utilities.getInt((String)((String)args.get("field.subIssueReporter")), (int)5);
                newIssue.setReporter(this.getUser(helper, reporter, (String)args.get("field.specificReporter")));
                int assignee = Utilities.getInt((String)((String)args.get("field.subIssueAssignee")), (int)1);
                if (assignee == 6) {
                    newIssue.setAssignee(this.projectManager.getDefaultAssignee(targetProject, newIssue.getComponents()));
                } else {
                    newIssue.setAssignee(this.getUser(helper, assignee, (String)args.get("field.specificAssignee")));
                }
                boolean excludeNonWorkingDays = this.excludeNonWorkingDays((String)args.get("field.dueDateOffset"));
                int dueDateOffset = excludeNonWorkingDays ? Utilities.getInt((String)((String)args.get("field.dueDateOffset")).replaceAll("[^0-9-]", ""), (int)0) : Utilities.getInt((String)((String)args.get("field.dueDateOffset")), (int)0);
                int dueDate = Utilities.getInt((String)((String)args.get("field.subIssueDueDate")), (int)0);
                newIssue.setDueDate(this.getDueDate(helper, dueDate, (String)args.get("field.specificDueDate"), dueDateOffset, excludeNonWorkingDays));
                Long originalEstimate = this.getTimeDuration(helper, (String)args.get("field.subIssueOriginalEstimate"));
                Long remainingEstimate = this.getTimeDuration(helper, (String)args.get("field.subIssueRemainingEstimate"));
                newIssue.setOriginalEstimate(originalEstimate);
                if (remainingEstimate != null) {
                    newIssue.setEstimate(remainingEstimate);
                } else {
                    newIssue.setEstimate(originalEstimate);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("Unexpected exception: {}", (Object)exception.toString(), (Object)exception);
        }
    }
}

