/*
 * Decompiled with CFR 0.152.
 */
package org.swift.jira.cot.functions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.swift.jira.cot.functions.AbstractCreateFunctionPluginFactory;
import org.swift.jira.library.Utilities;

public class CreateIssueFunctionPluginFactory
extends AbstractCreateFunctionPluginFactory
implements WorkflowPluginFunctionFactory {
    protected final ProjectManager projectManager;

    public CreateIssueFunctionPluginFactory(IssueManager issueManager, SubTaskManager subTaskManager, IssueTypeManager issueTypeManager, ProjectManager projectManager, ConstantsManager constantsManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher, I18nResolver i18nResolver, PluginLicenseManager licenseManager, JiraLicenseService jiraLicenseService) {
        super(issueManager, subTaskManager, issueTypeManager, constantsManager, applicationProperties, authenticationContext, i18nBeanFactory, eventPublisher, i18nResolver, licenseManager, jiraLicenseService);
        this.projectManager = projectManager;
    }

    @Override
    public void addDescriptorParams(Map<String, String> params, Map<String, Object> conditionParams) {
        params.put("field.projectKey", this.extractSingleParam(conditionParams, "projectKey"));
        params.put("field.specificProjectKey", this.extractSingleParam(conditionParams, "specificProjectKey"));
        params.put("field.issueTypeId", this.extractSingleParam(conditionParams, "issueTypeId"));
        params.put("field.issueSummary", this.extractSingleParam(conditionParams, "issueSummary"));
        params.put("field.issueDescription", this.extractSingleParam(conditionParams, "issueDescription"));
        params.put("field.issuePriorityId", this.extractSingleParam(conditionParams, "issuePriorityId"));
        params.put("field.issueReporter", this.extractSingleParam(conditionParams, "issueReporter"));
        params.put("field.issueAssignee", this.extractSingleParam(conditionParams, "issueAssignee"));
        params.put("field.issueAffectedVersions", this.extractSingleParam(conditionParams, "issueAffectedVersions"));
        params.put("field.issueFixedVersions", this.extractSingleParam(conditionParams, "issueFixedVersions"));
        params.put("field.issueComponents", this.extractSingleParam(conditionParams, "issueComponents"));
        params.put("field.issueDueDate", this.extractSingleParam(conditionParams, "issueDueDate"));
        params.put("field.issueOriginalEstimate", this.extractSingleParam(conditionParams, "issueOriginalEstimate"));
        params.put("field.issueRemainingEstimate", this.extractSingleParam(conditionParams, "issueRemainingEstimate"));
        params.put("field.securityLevel", this.extractSingleParam(conditionParams, "securityLevel"));
    }

    @Override
    protected boolean continueWithView(FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getArgs().get("field.issueTypeId") != null;
    }

    @Override
    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor inDescriptor) {
        super.getVelocityParamsForView(velocityParams, inDescriptor);
        FunctionDescriptor descriptor = (FunctionDescriptor)inDescriptor;
        if (this.continueWithView(descriptor)) {
            String projectKey = (String)descriptor.getArgs().get("field.projectKey");
            velocityParams.put("projectOriginal", "0");
            velocityParams.put("projectSpecific", "1");
            velocityParams.put("projectKey", projectKey);
            String specificProjectKey = (String)descriptor.getArgs().get("field.specificProjectKey");
            velocityParams.put("specificProjectKey", specificProjectKey == null ? "" : specificProjectKey);
            velocityParams.put("projectNameForView", this.isDefaultProjectKey(projectKey) ? "0" : ("1".equals(projectKey) ? "(" + specificProjectKey + ")" : "[" + projectKey + "] " + this.projectManager.getProjectObjByKey(projectKey).getName()));
            String issueTypeId = (String)descriptor.getArgs().get("field.issueTypeId");
            velocityParams.put("issueTypeId", issueTypeId == null ? "0" : issueTypeId);
            IssueType issueType = this.issueTypeManager.getIssueType(issueTypeId);
            velocityParams.put("issueTypeName", issueType == null ? "" : issueType.getName());
            velocityParams.put("issuePriorityId", descriptor.getArgs().get("field.issuePriorityId"));
            Priority priority = this.constantsManager.getPriorityObject((String)descriptor.getArgs().get("field.issuePriorityId"));
            velocityParams.put("issuePriorityName", priority != null ? priority.getName() : "");
            velocityParams.put("issueSummary", descriptor.getArgs().get("field.issueSummary"));
            velocityParams.put("issueDescription", descriptor.getArgs().get("field.issueDescription"));
            int reporter = 5;
            int assignee = 1;
            try {
                reporter = Integer.parseInt((String)descriptor.getArgs().get("field.issueReporter"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                assignee = Integer.parseInt((String)descriptor.getArgs().get("field.issueAssignee"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("issueReporterName", this.choices.getUserText(reporter));
            velocityParams.put("issueAssigneeName", this.choices.getUserText(assignee));
            int affectedVersions = 0;
            int fixedVersions = 0;
            try {
                affectedVersions = Integer.parseInt((String)descriptor.getArgs().get("field.issueAffectedVersions"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fixedVersions = Integer.parseInt((String)descriptor.getArgs().get("field.issueFixedVersions"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("issueAffectedVersionsName", this.choices.getVersionText(affectedVersions));
            velocityParams.put("issueFixedVersionsName", this.choices.getVersionText(fixedVersions));
            int components = 1;
            try {
                components = Integer.parseInt((String)descriptor.getArgs().get("field.issueComponents"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("issueComponentsName", this.choices.getComponentText(components));
            int dueDate = 0;
            try {
                dueDate = Integer.parseInt((String)descriptor.getArgs().get("field.issueDueDate"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            velocityParams.put("issueDueDate", this.choices.getDueDateText(dueDate));
            String issueOriginalEstimate = (String)descriptor.getArgs().get("field.issueOriginalEstimate");
            velocityParams.put("issueOriginalEstimate", issueOriginalEstimate == null ? "" : issueOriginalEstimate);
            String issueRemainingEstimate = (String)descriptor.getArgs().get("field.issueRemainingEstimate");
            velocityParams.put("issueRemainingEstimate", issueRemainingEstimate == null ? "" : issueRemainingEstimate);
            String securityLevel = (String)descriptor.getArgs().get("field.securityLevel");
            velocityParams.put("securityLevel", securityLevel == null ? "" : securityLevel);
        }
    }

    @Override
    protected void getVelocityParamsForInput(Map velocityParams) {
        super.getVelocityParamsForInput(velocityParams);
        velocityParams.put("projects", this.projectManager.getProjectObjects());
        velocityParams.put("currentProjectKey", "0");
        velocityParams.put("currentSpecificProjectKey", "");
        velocityParams.put("issueTypes", this.constantsManager.getRegularIssueTypeObjects());
        velocityParams.put("issuePriorities", this.constantsManager.getPriorities());
        velocityParams.put("currentIssueReporter", 5);
        velocityParams.put("currentIssueAssignee", 1);
        velocityParams.put("currentIssueAffectedVersions", 0);
        velocityParams.put("currentIssueFixedVersions", 0);
        velocityParams.put("currentIssueComponents", 1);
        velocityParams.put("currentIssueSummary", "%parent_summary%");
        velocityParams.put("currentIssueDueDate", 0);
        velocityParams.put("currentIssueOriginalEstimate", "");
        velocityParams.put("currentIssueRemainingEstimate", "");
        velocityParams.put("currentSecurityLevel", "");
    }

    @Override
    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor inDescriptor) {
        super.getVelocityParamsForEdit(velocityParams, inDescriptor);
        FunctionDescriptor descriptor = (FunctionDescriptor)inDescriptor;
        velocityParams.put("projects", this.projectManager.getProjectObjects());
        String projectKey = (String)descriptor.getArgs().get("field.projectKey");
        velocityParams.put("currentProjectKey", this.isDefaultProjectKey(projectKey) ? "0" : ("1".equals(projectKey) ? "1" : projectKey));
        String specificProjectKey = (String)descriptor.getArgs().get("field.specificProjectKey");
        velocityParams.put("currentSpecificProjectKey", specificProjectKey == null ? "" : specificProjectKey);
        velocityParams.put("issueTypes", this.constantsManager.getRegularIssueTypeObjects());
        velocityParams.put("currentIssueTypeId", descriptor.getArgs().get("field.issueTypeId"));
        velocityParams.put("currentIssueSummary", descriptor.getArgs().get("field.issueSummary"));
        velocityParams.put("currentIssueDescription", descriptor.getArgs().get("field.issueDescription"));
        velocityParams.put("currentIssuePriorityId", descriptor.getArgs().get("field.issuePriorityId"));
        velocityParams.put("issuePriorities", this.constantsManager.getPriorities());
        int reporter = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueReporter")), (int)5);
        velocityParams.put("currentIssueReporter", reporter);
        int assignee = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueAssignee")), (int)1);
        velocityParams.put("currentIssueAssignee", assignee);
        int affectedVersions = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueAffectedVersions")), (int)0);
        velocityParams.put("currentIssueAffectedVersions", affectedVersions);
        int fixedVersions = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueFixedVersions")), (int)0);
        velocityParams.put("currentIssueFixedVersions", fixedVersions);
        int components = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueComponents")), (int)1);
        velocityParams.put("currentIssueComponents", components);
        int dueDate = Utilities.getInt((String)((String)descriptor.getArgs().get("field.issueDueDate")), (int)0);
        velocityParams.put("currentIssueDueDate", dueDate);
        String issueOriginalEstimate = (String)descriptor.getArgs().get("field.issueOriginalEstimate");
        velocityParams.put("currentIssueOriginalEstimate", issueOriginalEstimate == null ? "" : issueOriginalEstimate);
        String issueRemainingEstimate = (String)descriptor.getArgs().get("field.issueRemainingEstimate");
        velocityParams.put("currentIssueRemainingEstimate", issueRemainingEstimate == null ? "" : issueRemainingEstimate);
        String securityLevel = (String)descriptor.getArgs().get("field.securityLevel");
        velocityParams.put("currentSecurityLevel", securityLevel == null ? "" : securityLevel);
    }

    protected boolean isDefaultProjectKey(String key) {
        return key == null || key.equals("0");
    }
}

