(function () {
	AJS.JETI = {};

    function createRecipientPicker($selectField) {
       return new AJS.MultiSelect({
           element: $selectField,
           itemAttrDisplayed: "label",
           errorMessage: AJS.I18n.getText("jira.ajax.autocomplete.components.error"),
           maxInlineResultsDisplayed: 15
        });
    }//
    function isRichTextEditor() {
        if (typeof tinymce == "undefined") {
            return false;
        }//
        AJS.log("RICHTEXT editor found");
        return (AJS.$("#emailIssueBody").length >0 && AJS.$("#editorTypeName").val() == "RICHTEXT");
    }
    function isJEditor() {
        if (typeof JEDITOR == "undefined") {
            return false;
        }//
        AJS.log("JEDITOR found");
        return (AJS.$("#emailIssueBody").length >0 && AJS.$("#editorTypeName").val() == "JEDITOR");
    }

    function locateSelect(parent) {
        var $parent = AJS.$(parent),
            $selectField;

        if ($parent.is("select")) {
            $selectField = $parent;
        } else {
            $selectField = $parent.find("select");
        }

        return $selectField;
    }

    var DEFAULT_SELECTORS = [
        "div.aui-field-recipientspicker.frother-control-renderer", // aui forms
        "div.aui-field-copyrecipientspicker.frother-control-renderer",
        "div.aui-field-blindcopyrecipientspicker.frother-control-renderer",
        "div.aui-field-attachmentspicker.frother-control-renderer",
        "div.aui-field-permissionRolespicker.frother-control-renderer",
        "div.aui-field-permissionGroupspicker.frother-control-renderer",
        "div.aui-field-restrictionFieldspicker.frother-control-renderer",
        "div.aui-field-hiddenFieldspicker.frother-control-renderer",
        "div.aui-field-restrictionGroupspicker.frother-control-renderer",
        "div.aui-field-restrictionRolespicker.frother-control-renderer",
        "div.aui-field-responsecategorypicker.frother-control-renderer",
        "div.aui-field-templatecategorypicker.frother-control-renderer",
        "div.aui-field-changelogfilterpicker.frother-control-renderer",
        "div.aui-field-eventspicker.frother-control-renderer"
    ];

    AJS.JETI.PICKERS = {};

    function findRecipientSelectAndConvertToPicker(context, selector) {
        //selector = "div.aui-field-recipientspicker.frother-control-renderer";
		selector = DEFAULT_SELECTORS.join(",");
        AJS.$(selector, context).each(function () {
            var $selectField = locateSelect(this);

			if ($selectField.length) {
                var pkr = createRecipientPicker($selectField);
                AJS.JETI.PICKERS[$selectField.attr("id")] = pkr;
            }
        });
    }

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context) {
        findRecipientSelectAndConvertToPicker(context);
    });

AJS.$.fn.extend({
	insertAtCursor: function(myValue) {
		return this.each(function(i) {
			if (document.selection) {
				//For browsers like Internet Explorer
				this.focus();
				sel = document.selection.createRange();
				sel.text = myValue;
				this.focus();
			}
			else if (this.selectionStart || this.selectionStart == '0') {
				//For browsers like Firefox and Webkit based
				var startPos = this.selectionStart;
				var endPos = this.selectionEnd;
				var scrollTop = this.scrollTop;
				this.value = this.value.substring(0, startPos) + myValue +
						    this.value.substring(endPos,this.value.length);
				this.focus();
				this.selectionStart = startPos + myValue.length;
				this.selectionEnd = startPos + myValue.length;
				this.scrollTop = scrollTop;
			} else {
				this.value += myValue;
				this.focus();
			}
		})
	}
})

	AJS.log(AJS.version);

	AJS.$(document).ready(function() {

      AJS.$("#popupOptions").click(function() {
          // create a dialog 860px wide x 530px high
          AJS.$("#issueView").hide();
          AJS.$("#optionsView").removeClass("hidden");
          AJS.$("#optionsView").show();
          AJS.$("#optionsView").css("display", "table-cell");
      });

	    AJS.$("#viewIssue").click(function() {
	        AJS.$("#issueView").toggle();
	        AJS.$("#optionsView").hide();
	    });


	    AJS.JETI.setupJetiTrigger = function() {
		    AJS.$("span.icon-jeti-trigger").css('background', 'transparent url("'+AJS.contextPath()+'/download/resources/com.metainf.jira.plugin.emailissue/images/jeti-icon.png") no-repeat 0 0');
	    }//

	    AJS.JETI.setupJetiTrigger();

        if (JIRA.Events.ISSUE_REFRESHED) {
	        JIRA.bind(JIRA.Events.ISSUE_REFRESHED, function (e, context) {
	        	AJS.JETI.setupJetiTrigger();
	        });
        }//

        AJS.JETI.addCommentToMailBody = function(issueId, commentId, fullDetails) {
             AJS.$.ajax({
                    type: "GET",
                    url : AJS.contextPath()+"/rest/jeti/1.0/comment/"+issueId+"/"+commentId,
                    cache : false,
                    dataType: "json",
                    error : function(msg) {
                        AJS.log("Error calling rest resource to get comment: ");
                        AJS.log(msg) ;
                    },// error
                    success : function(r) {
                        AJS.log("Comment response:");
                        AJS.log(r);
                        if (r) {

                          if (isJEditor()) {
                              if (fullDetails) {
                                  CKEDITOR.instances.emailIssueBody.insertHtml("<p>" + r.author + " " + r.timestamp + "<br/>" + r.body + "</p>");
                              } else {
                                  CKEDITOR.instances.emailIssueBody.insertHtml("<p>" + r.body + "</p>");
                              }
                          } else if (isRichTextEditor() && tinymce.activeEditor) {
                              if (fullDetails) {
                                  tinymce.activeEditor.insertContent("<p>" + r.author + " " + r.timestamp + "<br/>" + r.body + "</p>");
                              } else {
                                  tinymce.activeEditor.insertContent("<p>" + r.body + "</p>");
                              }
                          } else {
                            if (fullDetails) {
                                AJS.$("#emailIssueBody").insertAtCursor("\n*" +r.author + " " + r.timestamp +"*\n"+ r.body+"\n");
                            } else {
                                AJS.$("#emailIssueBody").insertAtCursor("\n" + r.body+"\n");
                            }
                          }//
                        }//
                    }// success
                }
            );
        }//getComment

        AJS.JETI.addResponseToMailBody = function(responseId) {
              AJS.log("Add response to body called: "+responseId);
             AJS.$.ajax({
                    type: "GET",
                    url : AJS.contextPath()+"/rest/jeti/1.0/response/"+responseId+(isJEditor() || isRichTextEditor() ? "?jeditor=true" : ""),
                    cache : false,
                    error : function(msg) {
                        AJS.log("Error calling rest resource to get response: ");
                        AJS.log(msg) ;
                    },// error
                    success : function(r) {
                        AJS.log("Canned response:");
                        AJS.log(r);
                        if (r) {
                          if (isJEditor()) {
                              CKEDITOR.instances.emailIssueBody.insertHtml("<p>" + r + "</p>");
                          } else if (isRichTextEditor()) {
                              tinymce.activeEditor.insertContent("<p>" + r + "</p>");
                          } else {
                            AJS.$("#emailIssueBody").insertAtCursor("\n" + r +"\n")
                          }//
                        }//
                    }// success
                }
            );
        }//addResponseToMailBody

        AJS.JETI.reverseComments = function() {
            if (AJS.$("#issueCommentContainer").length == 1) {
                var container = AJS.$("#issueCommentContainer");
                var arr = AJS.$.makeArray(AJS.$("div.issue-comment",container).detach());
                arr.reverse();
                AJS.$(container).append(arr);
            }
        }//

        AJS.$("#issueCommentSorter").click(function(e){
            AJS.JETI.reverseComments();
            if (AJS.$(this).hasClass("aui-iconfont-down")) {
             AJS.$(this).removeClass("aui-iconfont-down");
             AJS.$(this).addClass("aui-icon aui-icon-small aui-iconfont-up");
             AJS.$(this).attr("title", "Descending order - Click to sort in ascending order");
            } else {
             AJS.$(this).addClass("aui-icon aui-icon-small aui-iconfont-down");
             AJS.$(this).removeClass("aui-iconfont-up");
             AJS.$(this).attr("title", "Ascending order - Click to sort in descending order");
            }
            e.preventDefault();
            return false;
        });

        AJS.JETI.collectAttachedFiles = function() {
            var attachedFiles = AJS.$("#attachedFiles");
            AJS.$("input[name=filetoconvert]:checked").each(function(){
                //if (AJS.$(this)attr("checked")) {
                    if (attachedFiles.val().length > 0) {
                        attachedFiles.val(attachedFiles.val()+",");
                    }
                    attachedFiles.val(attachedFiles.val()+AJS.$(this).val());
                //}
            });
        }

        AJS.JETI.doSendEmail = function() {
            AJS.JETI.collectAttachedFiles();
            AJS.$("#emailIssueBody").val(AJS.JETI.getDataFromEditor());
            AJS.$("#sendEmailForm").submit();

            return false;
        }

        AJS.JETI.sendEmail = function() {
            if (AJS.$("#transition-selector-dialog").length > 0) {
                AJS.JETI.selectTransitions();
            } else {
                AJS.JETI.doSendEmail();
            }
            return false;
        }

        AJS.JETI.sendEmailFromPreview  = function() {
            AJS.dialog2("#email-preview-dialog").hide();
            AJS.JETI.sendEmail();
            return false;
         }

        AJS.JETI.sendEmailAndRememberFromPreview = function() {
            AJS.dialog2("#email-preview-dialog").hide();
            AJS.$('#saveSettings').attr('checked', 'checked');
            AJS.JETI.sendEmail();
            return false;
        }

        AJS.JETI.previewEmail = function() {
            AJS.$("#emailIssueBody").val(AJS.JETI.getDataFromEditor());

            AJS.$.ajax(
                {
                  url: AJS.contextPath() + "/secure/com.metainf.jira.plugin.emailissue.action.EmailThisIssue!preview.jspa",
                  type:"POST",
                  data: AJS.$("#sendEmailForm").serializeArray(),
                  success:function(data, textStatus, jqXHR) {
                      //data: return data from server
                      AJS.log("Preview result:"); AJS.log(AJS.$(data).find("#email-preview-dialog"));

                    if (AJS.$(data).find("#email-preview-dialog").length > 0) {
                        AJS.$("#email-preview-dialog").remove();
                        AJS.$("body").append(AJS.$(data).find("#email-preview-dialog"));

                        AJS.dialog2("#email-preview-dialog").show();
                        AJS.$("#email-preview-dialog-close-button").click(function(e){
                            AJS.dialog2("#email-preview-dialog").hide();
                        });
                        AJS.$("a.aui-dialog2-header-close").click(function(e){
                            AJS.dialog2("#email-preview-dialog").hide();
                        });
                    }
                  },
                  error: function(jqXHR, textStatus, errorThrown) {
                      //if fails
                  }
                }
            );

            return false;
        }

        AJS.JETI.selectTransitions = function(callback) {
            if (AJS.$("#transition-selector-dialog").length > 0) {
                AJS.dialog2("#transition-selector-dialog").show();
            }
            return false;
        }

        if (AJS.$("#transition-selector-dialog").length > 0) {
            AJS.$("#transition-selector-dialog-sendexecute-button").click(function(e){
                AJS.$("#transitionId").val(AJS.$("input[name=selectedTransitionId]:checked").val());
                //AJS.JETI.doSendEmail();
            });
            AJS.$("#transition-selector-dialog-sendonly-button").click(function(e){
                AJS.JETI.doSendEmail();
            });
        }

        AJS.JETI.previewTemplate = function() {
                AJS.$.ajax(
                {
                  url: AJS.contextPath() + "/secure/admin/jeti/jetiSendTestEmail!preview.jspa",
                  type:"POST",
                  data: AJS.$("#sendEmailForm").serializeArray(),
                  success:function(data, textStatus, jqXHR) {
                    if (AJS.$(data).find("#email-preview-dialog").length > 0) {
                        AJS.$("#email-preview-dialog").remove();
                        AJS.$("body").append(AJS.$(data).find("#email-preview-dialog"));

                        AJS.dialog2("#email-preview-dialog").show();
                        AJS.$("#email-preview-dialog-send-button-footer").hide();
                        AJS.$("#email-preview-dialog-send-button").hide();
                        AJS.$("#email-preview-dialog-close-button").click(function(e){
                            AJS.dialog2("#email-preview-dialog").hide();
                        });
                    }
                  },
                  error: function(jqXHR, textStatus, errorThrown) {
                      //if fails
                  }
                });
                return false;
        }

        AJS.JETI.getDataFromEditor = function() {
            if (isJEditor()) {
                return AJS.JETI.jeditor.getData();
            } else if (isRichTextEditor()) {
                //if (AJS.$("#emailFormat_text").is(":checked")) {
                //    return tinymce.activeEditor.getContent({ format: 'text' });
                //} else {
                    return tinymce.activeEditor.getContent();
                //}
            } else {
                return AJS.$("#emailIssueBody").val();
            }
        }

      if (isJEditor()) {
          AJS.JETI.jeditor = CKEDITOR.replace(AJS.$("#emailIssueBody")[0], {toolbar:'JFull'});

          AJS.$("#emailIssueBody-preview_link").hide();
          AJS.$("#viewHelp").hide();

          if (typeof AJS.disableKeyboardShortcuts == 'function') {
            AJS.disableKeyboardShortcuts();
          }//
          if (AJS.$("#emailFormat_html").length > 0) {
            AJS.$("#emailFormat_html").attr("checked", true);
          }

          //in Chrome Browser, JEditor cannot paste image from clipboard, we need to add this support. IE and FF not affected
          if (/chrom(e|ium)/.test(navigator.userAgent.toLowerCase())) {

            AJS.JETI.jeditor.on('paste', function(event) {
                if (!event.data.dataValue) return;
                var clipObj = AJS.$('<div>'+event.data.dataValue+'</div>');

                /* thin table borders */
                if (clipObj.find('table').length)
                {
                  clipObj.find('table').each(function( index, elem ) {
                    AJS.$(elem).css('border-collapse','collapse');
                  });
                }

                /* local filesystem urls */
                if (!CKEDITOR.env.ie && clipObj.find('img').length && clipObj.html().indexOf('file:///')>0)
                {
                    clipObj.find('img').each(function(index,elem) {
                        if (AJS.$(elem).attr('src').indexOf('file:///') == 0) AJS.$(elem).remove();
                    });
                }

                /* upload pasted base64 images */
                if ((CKEDITOR.env.gecko || (CKEDITOR.env.ie && CKEDITOR.env.version == '11')) && clipObj.find('img').length)
                {
                  clipObj.find('img').each(function( index, elem ) {
                    if (AJS.$(elem).attr('src') && AJS.$(elem).attr('src').indexOf('data:image/png;base64')==0)
                    {
                      var pasteUploadUrl = CKEDITOR.config.filebrowserImageUploadUrl+'&linkType=raw&CKEditorFuncNum=0',
                          base64 = AJS.$(elem).attr('src').split(',')[1],
                          blob = b64toBlob(base64, "image/png"),
                          tempFormData = new FormData,
                          xhr = new XMLHttpRequest(),
                          filename = '';
                      if (base64.indexOf('iVB') == 0) filename = 'pastedImage.png';
                      else if (base64.indexOf('/9j') == 0) filename = 'pastedImage.jpg';
                      else if (base64.indexOf('R0l') == 0) filename = 'pastedImage.gif';
                      else filename = 'pastedImage.png';
                      tempFormData.append("upload", blob, filename);
                      xhr.open("POST", pasteUploadUrl, false);
                      xhr.send(tempFormData);
                      AJS.$(elem).attr('src',xhr.responseText);
                    }
                    if (AJS.$(elem).attr('data-cke-saved-src') && AJS.$(elem).attr('data-cke-saved-src').indexOf('data:image/png;base64')==0)
                    {
                        AJS.$(elem).attr('data-cke-saved-src', AJS.$(elem).attr('src'));
                    }
                    AJS.$(elem).wrap('<div class="je-pasted-image"></div>');
                    if (CKEDITOR.env.gecko) AJS.$(elem).after('<span>&nbsp;</span>');
                  });
                }

                /* commit changes */
                event.data.dataValue = clipObj.html();
            });

            AJS.JETI.jeditor.on('focus', function() {
                /* ctrl+v handling */
                var tempCurrentInstance = this;
                if (CKEDITOR.env.webkit && this.document) {
                    this.document.$.body.onpaste = function(event) {
                        var items = event.clipboardData.items;
                        if (items.length == 0) return;
                        var blob = items[0].getAsFile();
                        if (blob != null)
                        {
                            var reader = new FileReader();
                            reader.readAsDataURL(blob);
                            var tempFormData = new FormData,
                                xhr = new XMLHttpRequest();
                            tempFormData.append("upload", blob, "pastedImage.png");
                            var pasteUploadUrl = CKEDITOR.config.filebrowserImageUploadUrl + '&linkType=raw&CKEditorFuncNum=0';
                            xhr.open("POST", pasteUploadUrl);
                            xhr.onreadystatechange = function() {
                                if (this.readyState == 4 && this.status == 200)
                                {
                                    var elementFromImage = CKEDITOR.dom.element.createFromHtml('<div class="je-pasted-image">'
                                                                                               + '<img alt="" src="'
                                                                                               + this.responseText
                                                                                               + '" ></div>');
                                    tempCurrentInstance.insertElement(elementFromImage);
                                }
                            };
                            xhr.send(tempFormData);
                        }
                    }
                }
            });
          }//if Chrome

          AJS.$("#sendEmailForm div.field-tools").hide();
          window.setTimeout(function(){
              AJS.log("Hiding toolbar");
              AJS.$("#sendEmailForm div.wiki-edit div.wiki-edit-toolbar").hide();
          }, 500);

      }
      if (isRichTextEditor()) {
          //replace text area with editor
          if (tinymce.activeEditor) {
              AJS.log("Editor already initialized");
              tinymce.activeEditor.show();
          } else {
              tinymce.init(
                  {
                      selector: "#emailIssueBody",
                      theme: 'modern',
                      width: AJS.$("#emailIssueBody").width() + 'px',
                      height: AJS.$("#emailIssueBody").height() + 'px',
                      plugins: [
                          'advlist autolink link image lists charmap preview hr anchor pagebreak spellchecker',
                          'searchreplace wordcount visualblocks visualchars code fullscreen nonbreaking',
                          'table contextmenu directionality emoticons template paste textcolor'
                      ],
                      //content_css: '/assets/javascripts/tinymce/skins/lightgray/content.min.css',
                      toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image attachments | preview fullpage | forecolor backcolor emoticons',

                      setup: function(editor) {
                          if (AJS.$("#attachments").length > 0 && AJS.$("#attachments option").length > 0) {
                              var menuItems = [];
                              AJS.$("#attachments option").each(function(e){
                                  var value = AJS.$(this).val();
                                  var img = AJS.$(this).data("image");
                                  var label = AJS.$(this).text();
                                  var item = {
                                      text: label,
                                      onclick: function () {
                                          if (img) {
                                              editor.insertContent('<p><img  width="400" src="'+AJS.$("#sendEmailForm").data("baseurl")+'/secure/attachment/'+value+'/'+value+'" /></p>');
                                          } else {
                                              editor.insertContent('<a href="'+AJS.$("#sendEmailForm").data("baseurl")+'/secure/attachment/'+value+'/'+value+'">'+label+'</a>');
                                          }
                                      }
                                  }
                                  menuItems.push(item);
                              });

                              editor.addButton("attachments", {
                                  type: "menubutton",
                                  text: "",
                                  title: "add attachments",
                                  icon: true,
                                  classes: "aui-icon aui-icon-small aui-iconfont-attachment",
                                  image: AJS.contextPath() + "/download/resources/com.metainf.jira.plugin.emailissue/images/paperclip.png",
                                  menu: menuItems
                              });
                          }
                      },
                      paste_data_images: true,
                      relative_urls: false,
                      remove_script_host : false
                  }
              );
          }

          if (AJS.$("#emailFormat_html").length > 0) {
              AJS.$("#emailFormat_html").attr("checked", true);
          }

          AJS.$("#sendEmailForm div.field-tools").hide();
          window.setTimeout(function(){
              AJS.log("Hiding toolbar");
              AJS.$("#sendEmailForm div.wiki-edit div.wiki-edit-toolbar").hide();
          }, 500);
      }
      AJS.JETI.switchToggle = function(toggleContainer) {
        var status = toggleContainer.attr("data-status");
        toggleContainer.find("img.icon").attr("src", toggleContainer.attr("data-icon-"+status));
        toggleContainer.find("span.current-status").text(toggleContainer.attr("data-status-"+status));
        toggleContainer.find("a.toggle-trigger").text(toggleContainer.attr("data-status-"+(status == "on" ? "off" : "on")));

        AJS.log(AJS.$("#"+toggleContainer.attr("data-rel-id")));

        if (status == "on") {
            toggleContainer.find("input.toggle-value").attr("checked", "checked");
            AJS.$("#"+toggleContainer.attr("data-rel-id")).show();
        } else {
            toggleContainer.find("input.toggle-value").removeAttr("checked");
            AJS.$("#"+toggleContainer.attr("data-rel-id")).css("display", "none");
        }
      }//

      AJS.JETI.auditLogToggle = function(auditId) {
          AJS.$('#email-details-'+auditId).toggle();
          if (AJS.$('#email-details-'+auditId).is(":visible")) {
              AJS.$('#email-details-toggle-' + auditId).text(AJS.$('#email-details-toggle-' + auditId).attr("data-collapse-label"));

              if (AJS.$("#email-log-body-" + auditId).children().length == 0) {
              AJS.$.ajax({
                  type: "GET",
                  url: AJS.contextPath() + "/rest/jeti/1.0/auditlog/body/" + auditId,
                  cache: true,
                  dataType: "text",
                  error: function (msg) {
                      AJS.log("Error calling rest resource to get comment: ");
                      AJS.log(msg);
                  },// error
                  success: function (r) {
                      if (r) {
                          AJS.$("#email-log-body-" + auditId).append(r);
                      }
                  }
              });
            }

          } else {
              AJS.$('#email-details-toggle-'+auditId).text(AJS.$('#email-details-toggle-'+auditId).attr("data-expand-label"));
          }
      }

      AJS.$("div.toggle-element").each(function(){
        var toggleContainer = AJS.$(this);
        AJS.JETI.switchToggle(toggleContainer);
        AJS.$(this).find("a.toggle-trigger").click(function(e){
            var status = toggleContainer.attr("data-status");
            toggleContainer.attr("data-status","on" == status ? "off" : "on");
            AJS.JETI.switchToggle(toggleContainer);
            e.preventDefault();
        });
      });

      AJS.$("ol.item-attachments a.jeti-attachment-title").click(function(e) {
        var attachmentId = AJS.$(this).attr("data-attachment-id");
        var opt = AJS.$("#attachment_"+attachmentId);
        if (opt && AJS.JETI.PICKERS["attachments"]) {
            AJS.JETI.PICKERS["attachments"].addItem(AJS.JETI.PICKERS["attachments"].model._parseOption(opt))
        }
        e.preventDefault();
      });


	    AJS.log("JETI javascript loaded");
  }); // AJS.$(document).ready(
})();