AJS.toInit(function () {
  if (!AJS.JETI) {
    AJS.JETI = {};
  }

  if (AJS.$("#jetiConfigurationTabs").size() > 0) {
		AJS.log("tabs loaded");
		AJS.tabs.setup();
	}

	AJS.JETI.addJETIError = function(error) {
	  if (AJS.$("#jetiErrors").size() > 0) {
	    AJS.log("adding error")
	    var li = AJS.$("<li></li>").text(error);
      AJS.$("#jetiErrors").append(li);
      AJS.$("#jetiErrorsContainer").show().removeClass("hidden");
	  }
	}//

  AJS.JETI.validateTemplateEditor = function() {
    var valid = true;

    AJS.$("#jetiErrors li").each(function(){
      AJS.$(this).remove();
    });

    if (!AJS.$("#jetiTemplateName").val()) {
      AJS.JETI.addJETIError("Template name is required.");
      valid = false;
    }//
    if (!AJS.$("#jetiTemplateHtml").val()) {
      AJS.JETI.addJETIError("HTML Template is required.");
      valid = false;
    }//
    if (!AJS.$("#jetiTemplateText").val()) {
      AJS.JETI.addJETIError("Text Template is required.");
      valid = false;
    }//

    return valid;
  }//function

    AJS.JETI.validateEventEditor = function() {
      AJS.log("validateEventEditor");
      var valid = true;

      AJS.$("#jetiErrors li").each(function(){
        AJS.$(this).remove();
      });

      if (!AJS.$("#emailIssueTo").val() && !AJS.$("#emailIssueCc").val() && !AJS.$("#emailIssueBcc").val() && !AJS.$("#recipients").val() && !AJS.$("#copyrecipients").val() && !AJS.$("#blindcopyrecipients").val()) {
        AJS.JETI.addJETIError("At least one recipient is required.");
        valid = false;
      }//

      if (!AJS.$("#eventTypeIds").val()) {
        AJS.JETI.addJETIError("Event Type is required.");
        valid = false;
      }

      return valid;
    }//function

      AJS.JETI.createAddNotificationDialog = function() {

         AJS.JETI.addNotificationDialog = AJS.InlineDialog(AJS.$("#jetiNotificationDialog"), "jetiNotificationInlineDialog",

          function(content, trigger, showPopup) {
            var dialogContent = JETI.Templates.Config.inlineAddNotification6();
            AJS.$(content).empty().append(dialogContent);
            AJS.$(content).click(function(e){e.stopPropagation()});
            AJS.$("#jetiAddNotification").click(function(e){
              if (AJS.$("#notificationName").val()) {
                AJS.JETI.addNotificationDialog.hide();
              } else {
                AJS.$("#jetiNotificationErrorsContainer").show();
                e.stopPropagation();
                return false;
              }//
            });
            AJS.$("#jetiCancelNotification").click(function(e){
              AJS.JETI.addNotificationDialog.hide();
            });
            showPopup();
          },
          {useLiveEvents:true, width:400, height:500, fadeTime:500,
            hideCallback:function(){
            },
            initCallback:function(){
              AJS.$("#inline-dialog-jetiNotificationInlineDialog").css("z-index", "5000");
            }//initCallback
          }
        ); //AJS.InlineDialog
      }//AJS.JETI.addNotificationDialog

      AJS.JETI.createAddEventDialog = function() {

         AJS.JETI.addEventDialog = AJS.InlineDialog(AJS.$("#jetiNotificationEventDialog"), "jetiEventInlineDialog",
          function(content, trigger, showPopup) {
            AJS.$(content).append(AJS.$("#jetiAddEventFormContainer"));
            AJS.$(content).click(function(e){e.stopPropagation()});
            AJS.$("#jetiCancelNotificationEvent").click(function(e){
              AJS.JETI.addEventDialog.hide();
              e.stopPropagation();
              return false;
            });
            AJS.$("#jetiAddNotificationEvent").click(function(e){
              if (AJS.$("#eventTypeId").val()) {
                AJS.JETI.addEventDialog.hide();
              } else {
                AJS.$("#jetiEventErrorsContainer").show();
                e.stopPropagation();
                return false;
              }//
            });
            showPopup();
          },
          {useLiveEvents:true, width:400, height:500, fadeTime:500,
            hideCallback:function(){
              AJS.$("#jetiEventErrorsContainer").hide();
            },
            initCallback:function(){
              AJS.$("#inline-dialog-jetiEventInlineDialog").css("z-index", "5000");
            }//initCallback
          }
        ); //AJS.InlineDialog
      }//AJS.JETI.createAddEventDialog

      AJS.JETI.createAddTemplateDialog = function() {

         AJS.JETI.addTemplateDialog = AJS.InlineDialog(AJS.$("#jetiAddTemplateTrigger"), "jetiTemplateInlineDialog",
          function(content, trigger, showPopup) {
            AJS.$(content).append(AJS.$("#jetiAddTemplateFormContainer"));
            AJS.$(content).click(function(e){e.stopPropagation()});
            AJS.$("#jetiCancelTemplate").click(function(e){
              AJS.JETI.addTemplateDialog.hide();
              e.stopPropagation();
              return false;
            });
            showPopup();
          },
          {useLiveEvents:true, width:500, height:500, fadeTime:500,
            hideCallback:function(){
              AJS.$("#jetiTemplateErrorsContainer").hide();
            },
            initCallback:function(){
              AJS.$("#inline-dialog-jetiTemplateInlineDialog").css("z-index", "5000");
            }//initCallback
          }
        ); //AJS.InlineDialog
      }//AJS.JETI.createAddTemplateDialog

      AJS.JETI.createAddResponseDialog = function() {

         AJS.JETI.addResponseDialog = AJS.InlineDialog(AJS.$("#jetiAddResponseTrigger"), "jetiResponseDialog",
          function(content, trigger, showPopup) {
            AJS.$(content).append(AJS.$("#jetiResponseFormContainer"));
            AJS.$(content).click(function(e){e.stopPropagation()});
            AJS.$("#jetiCancelResponse").click(function(e){
              AJS.JETI.addEventDialog.hide();
              e.stopPropagation();
              return false;
            });
            AJS.$("#jetiAddResponse").click(function(e){
              if (AJS.$("#name").val() && AJS.$("#response").val()) {
                AJS.JETI.addResponseDialog.hide();
              } else {
                AJS.$("#jetiResponseErrorsContainer").show();
                e.stopPropagation();
                return false;
              }//
            });
            showPopup();
          },
          {useLiveEvents:true, width:400, height:500, fadeTime:500,
            hideCallback:function(){
              AJS.$("#jetiResponseErrorsContainer").hide();
            },
            initCallback:function(){
              AJS.$("#inline-dialog-jetiResponseDialog").css("z-index", "5000");
            }//initCallback
          }
        ); //AJS.InlineDialog
      }//AJS.JETI.createAddResponse

      AJS.JETI.createAddPatternDialog = function() {

           AJS.JETI.addPatternDialog = AJS.InlineDialog(AJS.$("#jetiAddPatternTrigger"), "jetiPatternDialog",
            function(content, trigger, showPopup) {
              AJS.$(content).append(AJS.$("#jetiMD5FormContainer"));
              AJS.$(content).click(function(e){e.stopPropagation()});
              AJS.$("#jetiCancelPattern").click(function(e){
                AJS.JETI.addEventDialog.hide();
                e.stopPropagation();
                return false;
              });
              AJS.$("#jetiAddPattern").click(function(e){
                if (AJS.$("#desc").val() && AJS.$("#pattern").val()) {
                  AJS.JETI.addPatternDialog.hide();
                } else {
                  AJS.$("#jetiPatternErrorsContainer").show();
                  e.stopPropagation();
                  return false;
                }//
              });
                AJS.$("#jetiAddBlacklist").click(function(e){
                    if (AJS.$("#regexDescription").val() && AJS.$("#blacklist").val()) {
                        AJS.JETI.addPatternDialog.hide();
                    } else {
                        AJS.$("#jetiBlacklistErrorsContainer").show();
                        e.stopPropagation();
                        return false;
                    }//
                });
              showPopup();
            },
            {useLiveEvents:true, width:400, height:500, fadeTime:500,
              hideCallback:function(){
                AJS.$("#jetiPatternErrorsContainer").hide();
              },
              initCallback:function(){
                AJS.$("#inline-dialog-jetiPatternDialog").css("z-index", "5000");
              }//initCallback
            }
          ); //AJS.InlineDialog
        }//AJS.JETI.createAddPattern

        AJS.JETI.createAddAttachmentSizeThreasholdDialog = function() {
             AJS.JETI.jetiAttachmentSizeThresholdDialog = AJS.InlineDialog(AJS.$("#jetiAttachmentSizeThresholdTrigger"), "jetiAttachmentSizeThresholdDialog",
              function(content, trigger, showPopup) {
                AJS.$(content).append(AJS.$("#attachmentSizeThresholdFormContainer"));
                AJS.$(content).click(function(e){e.stopPropagation()});
                AJS.$("#jetiCancelThreshold").click(function(e){
                  AJS.JETI.addEventDialog.hide();
                  e.stopPropagation();
                  return false;
                });
                AJS.$("#saveSizeThreshold").click(function(e){
                  AJS.JETI.addPatternDialog.hide();
                });
                showPopup();
              },
              {useLiveEvents:true, width:450, height:500, fadeTime:500,
                hideCallback:function(){
                },
                initCallback:function(){
                  AJS.$("#inline-dialog-jetiAttachmentSizeThresholdDialog").css("z-index", "5000");
                }//initCallback
              }
            ); //AJS.InlineDialog
          }//AJS.JETI.createAddPattern

        AJS.JETI.onChangeMailHandlerProcessingStrategy = function() {

          AJS.$("#processingStrategy").change(function(e) {

            AJS.log(AJS.$("#"+AJS.$(this).val()).attr('data-criteria-enabled'));

            if (AJS.$("#"+AJS.$(this).val()).attr('data-criteria-enabled') == "true") {
              AJS.$('#commentCriteriaContainer').show();
            } else {
              AJS.$('#commentCriteriaContainer').hide();
            };

            if (AJS.$("#"+AJS.$(this).val()).attr('data-link-enabled') == "true") {
              AJS.$('#linkTypeContainer').show();
            } else {
              AJS.$('#linkTypeContainer').hide();
            };

            var element = document.getElementById("processingStrategy");
            AJS.$('#processingStrategyDescription span.message').text(element.options[element.selectedIndex].title);
            e.preventDefault();

            //Service Desk Handler
            AJS.$('#sdParametersContainer').toggle(AJS.$(this).val() == "SERVICEDESK");

          });
        };

    AJS.JETI.onChangeProject = function() {
        AJS.$("#projectId").change(function(e){
            AJS.JETI.loadRequestTypes();
        });
    }

    AJS.JETI.onChangeIssueType = function() {
        AJS.$("#issueTypeId").change(function(e){
            AJS.JETI.loadRequestTypes();
        });
    }

    AJS.JETI.loadRequestTypes = function() {
        if (AJS.$("#projectId").val() && AJS.$("#issueTypeId").val()) {
            AJS.$.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/jeti/1.0/servicedesk/requesttypes/" + AJS.$("#projectId").val() + "/" + AJS.$("#issueTypeId").val(),
                cache: false,
                error : function(msg) {
                    AJS.log("Error calling rest resource to get response: ");
                    AJS.log(msg) ;
                },// error
                success : function(r) {
                    AJS.log(r);
                    AJS.$("#sdRequestType option").remove();
                    if (r && r.length > 0) {
                        AJS.$.each(r, function(index, value){
                            AJS.$("#sdRequestType").append(AJS.$("<option />").attr("value", value.key).text(value.name));
                        });
                    }
                }// success
            });
        }
    }

    AJS.JETI.deleteMailHandlerLog = function(mailHandlerLogId) {
        AJS.log("deleting mail handler log item: "+mailHandlerLogId);
        AJS.$.ajax({
                type: "DELETE",
                url : AJS.contextPath()+"/rest/jeti/1.0/mailhandlerlog/"+mailHandlerLogId,
                cache : false,
                error : function(msg) {
                    AJS.log("Error calling rest resource to get response: ");
                    AJS.log(msg) ;
                },// error
                success : function(r) {
                    AJS.$("#handlerlog-"+mailHandlerLogId).remove();
                }// success
            }
        );
    }//deleteMailHandlerLog

    //findRecipientSelectAndConvertToPicker();
    AJS.JETI.createAddNotificationDialog();
    AJS.JETI.createAddEventDialog();
    AJS.JETI.createAddTemplateDialog();
    AJS.JETI.createAddResponseDialog();
    AJS.JETI.createAddPatternDialog();
    AJS.JETI.createAddAttachmentSizeThreasholdDialog();
    AJS.JETI.onChangeMailHandlerProcessingStrategy();
    AJS.JETI.onChangeProject();
    AJS.JETI.onChangeIssueType();

    AJS.JETI.showFieldPickerCode = function(key) {
        if (key) {AJS.$('#jetiFieldTemplate').html(key).show();} else {AJS.$('#jetiFieldTemplate').html('').hide();};
    }
    AJS.inlineHelp();
    if (AJS.$("#jetiTemplateHtml").length > 0) {
        AJS.log("We are on the edtor page")


        if (typeof tinymce !== "undefined" && AJS.$("#theme").val() != "" && AJS.$("#editor").val() != "html") {
            if (tinymce.activeEditor) {
                AJS.log("Editor already initialized");
                tinymce.activeEditor.show();
            } else {
                tinymce.init(
                    {
                        selector: "#jetiTemplateHtml",
                        theme: 'modern',
                        width: AJS.$("#jetiTemplateText").width() + 'px',
                        height: AJS.$("#jetiTemplateText").height() + 'px',
                        plugins: [
                            'advlist autolink link image lists charmap preview hr anchor pagebreak spellchecker',
                            'searchreplace wordcount visualblocks visualchars code fullscreen nonbreaking',
                            'table contextmenu directionality emoticons template paste textcolor'
                        ],
                        //content_css: '/assets/javascripts/tinymce/skins/lightgray/content.min.css',
                        toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | preview fullpage | forecolor backcolor emoticons'

                    }
                );
            }
            if (AJS.$("#saveTemplate").length > 0) {
                AJS.$("#saveTemplate").click(function (e) {
                    AJS.$("#jetiTemplateHtml").val(tinymce.activeEditor.getContent());
                });
            }//

        } else if (CodeMirror) {
            AJS.JETI.htmlEditor = CodeMirror(document.getElementById("htmlCode"), {
                mode: "text/html",
                extraKeys: {"Ctrl-Space": "autocomplete"},
                value: AJS.$("#jetiTemplateHtml").val(),
                autoCloseTags: true,
                lineNumbers: true,
                matchTags: {bothTags: true}
            });
            AJS.$("div.CodeMirror").css("border-top", "1px solid #888").css("border-bottom", "1px solid #888");
            AJS.JETI.htmlEditor.setSize(AJS.$("#jetiTemplateText").width(), AJS.$("#jetiTemplateText").height());

            if (AJS.$("#saveTemplate").length > 0) {
                AJS.$("#saveTemplate").click(function (e) {
                    AJS.$("#jetiTemplateHtml").val(AJS.JETI.htmlEditor.getValue());
                });
            }//
        }//
    }//if on the edit template screen

    AJS.$("#fieldRuleGoal").change(function(e){
        if (AJS.$(this).val() == 'WORKFLOW'){
            AJS.$('#issueFieldSelector').hide();
            AJS.$('#emailAction').hide();
            AJS.$('#fieldRuleValue').show();
        } else if (AJS.$(this).val() == 'FILTER') {
            AJS.$('#issueFieldSelector').hide();
            AJS.$('#emailAction').show();
            AJS.$('#fieldRuleValue').hide();
        } else {
            AJS.$('#issueFieldSelector').show();
            AJS.$('#emailAction').hide();
            AJS.$('#fieldRuleValue').show();
        }
    });

    AJS.$("select.field-rule-emai-field").change(function(e){
        if (AJS.$(this).val() == 'HEADER') {
            AJS.$("#emailHeaderName").show();
        } else {
            AJS.$("#emailHeaderName").hide();
        }
    });

    AJS.JETI.confirmButton = function(auiButton, callback) {
        if (AJS.$(auiButton).hasClass("aui-button-primary")) {
            callback();
        } else {
            var oldText = AJS.$(auiButton).addClass("aui-button-primary").text();
            AJS.$(auiButton).addClass("aui-button-primary").css('background-color', '#D04437').text("Confirm: "+oldText);
        }
    }

    AJS.$("table.entity-list tr.entity-header").click(function(e){
        if (AJS.$(e.target).closest('td').hasClass('no-row-toggle')) {
            return;
        }

        var entityId = AJS.$(this).data("entity-id");
        AJS.$("tr.entity-details-row[data-entity-id="+entityId+"]").toggle();

        if (AJS.$("tr.entity-details-row[data-entity-id="+entityId+"]").is(":visible")) {
            AJS.$(this).find("td:first span").removeClass("aui-iconfont-collapsed").addClass("aui-iconfont-expanded");
        } else {
            AJS.$(this).find("td:first span").addClass("aui-iconfont-collapsed").removeClass("aui-iconfont-expanded");
        }
        e.preventDefault();
    });

    AJS.$("#eventQueueConfigForm #maximumPoolSize").change(function(e){
        AJS.$("#eventQueueConfigForm").submit();
    })

    AJS.$("#jetiAddTemplateForm").submit(function(e){
        if (AJS.$("#jetiAddTemplateForm #fromTheme").is(":checked")) {
            AJS.$("#jetiAddTemplateForm #baseTemplateOrThemeId").val(AJS.$("#jetiAddTemplateForm #baseThemeId").val());
        } else {
            AJS.$("#jetiAddTemplateForm #baseTemplateOrThemeId").val(AJS.$("#jetiAddTemplateForm #baseTemplateId").val());
        }
    });

    AJS.$("#jetiAddTemplateForm #fromTemplate").click(function(e){

    });
    AJS.log("jeti admin script loaded");
});
