/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;

public class PSFontUtils
extends org.apache.xmlgraphics.ps.PSFontUtils {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$render$ps$PSFontUtils == null ? (class$org$apache$fop$render$ps$PSFontUtils = PSFontUtils.class$("org.apache.fop.render.ps.PSFontUtils")) : class$org$apache$fop$render$ps$PSFontUtils);
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSFontUtils;

    public static Map writeFontDict(PSGenerator gen, FontInfo fontInfo) throws IOException {
        return PSFontUtils.writeFontDict(gen, fontInfo, fontInfo.getFonts());
    }

    public static Map writeFontDict(PSGenerator gen, FontInfo fontInfo, Map fonts) throws IOException {
        gen.commentln("%FOPBeginFontDict");
        HashMap<String, PSResource> fontResources = new HashMap<String, PSResource>();
        Iterator iter = fonts.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Typeface tf = PSFontUtils.getTypeFace(fontInfo, fonts, key);
            PSResource fontRes = new PSResource("font", tf.getFontName());
            fontResources.put(key, fontRes);
            PSFontUtils.embedFont(gen, tf, fontRes);
        }
        gen.commentln("%FOPEndFontDict");
        PSFontUtils.reencodeFonts(gen, fonts);
        return fontResources;
    }

    private static void reencodeFonts(PSGenerator gen, Map fonts) throws IOException {
        gen.commentln("%FOPBeginFontReencode");
        PSFontUtils.defineWinAnsiEncoding(gen);
        Iterator iter = fonts.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Typeface fm = (Typeface)fonts.get(key);
            if (fm instanceof LazyFont && ((LazyFont)fm).getRealFont() == null || null == fm.getEncoding()) continue;
            if ("WinAnsiEncoding".equals(fm.getEncoding())) {
                PSFontUtils.redefineFontEncoding(gen, fm.getFontName(), fm.getEncoding());
                continue;
            }
            gen.commentln("%WARNING: Only WinAnsiEncoding is supported. Font '" + fm.getFontName() + "' asks for: " + fm.getEncoding());
        }
        gen.commentln("%FOPEndFontReencode");
    }

    private static Typeface getTypeFace(FontInfo fontInfo, Map fonts, String key) {
        Typeface tf = (Typeface)fonts.get(key);
        if (tf instanceof LazyFont) {
            tf = ((LazyFont)tf).getRealFont();
        }
        if (tf == null) {
            String fallbackKey = fontInfo.getInternalFontKey(Font.DEFAULT_FONT);
            tf = (Typeface)fonts.get(fallbackKey);
        }
        return tf;
    }

    public static void embedFont(PSGenerator gen, Typeface tf, PSResource fontRes) throws IOException {
        CustomFont cf;
        boolean embeddedFont = false;
        if (FontType.TYPE1 == tf.getFontType() && tf instanceof CustomFont && PSFontUtils.isEmbeddable(cf = (CustomFont)tf)) {
            InputStream in = PSFontUtils.getInputStreamOnFont(gen, cf);
            if (in != null) {
                gen.writeDSCComment("BeginResource", fontRes);
                PSFontUtils.embedType1Font(gen, in);
                gen.writeDSCComment("EndResource");
                gen.getResourceTracker().registerSuppliedResource(fontRes);
                embeddedFont = true;
            } else {
                gen.commentln("%WARNING: Could not embed font: " + cf.getFontName());
                log.warn("Font " + cf.getFontName() + " is marked as supplied in the" + " PostScript file but could not be embedded!");
            }
        }
        if (!embeddedFont) {
            gen.writeDSCComment("IncludeResource", fontRes);
        }
    }

    private static boolean isEmbeddable(CustomFont font) {
        return font.isEmbeddable() && (font.getEmbedFileName() != null || font.getEmbedResourceName() != null);
    }

    private static InputStream getInputStreamOnFont(PSGenerator gen, CustomFont font) throws IOException {
        if (PSFontUtils.isEmbeddable(font)) {
            Source source = font.getEmbedFileSource();
            if (source == null && font.getEmbedResourceName() != null) {
                source = new StreamSource((class$org$apache$fop$render$ps$PSFontUtils == null ? (class$org$apache$fop$render$ps$PSFontUtils = PSFontUtils.class$("org.apache.fop.render.ps.PSFontUtils")) : class$org$apache$fop$render$ps$PSFontUtils).getResourceAsStream(font.getEmbedResourceName()));
            }
            if (source == null) {
                return null;
            }
            InputStream in = null;
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                try {
                    in = new URL(source.getSystemId()).openStream();
                }
                catch (MalformedURLException e) {
                    new FileNotFoundException("File not found. URL could not be resolved: " + e.getMessage());
                }
            }
            if (in == null) {
                return null;
            }
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return in;
        }
        return null;
    }

    public static Map determineSuppliedFonts(ResourceTracker resTracker, FontInfo fontInfo, Map fonts) {
        HashMap<String, PSResource> fontResources = new HashMap<String, PSResource>();
        Iterator iter = fonts.keySet().iterator();
        while (iter.hasNext()) {
            CustomFont cf;
            String key = (String)iter.next();
            Typeface tf = PSFontUtils.getTypeFace(fontInfo, fonts, key);
            PSResource fontRes = new PSResource("font", tf.getFontName());
            fontResources.put(key, fontRes);
            if (FontType.TYPE1 != tf.getFontType() || !(tf instanceof CustomFont) || !PSFontUtils.isEmbeddable(cf = (CustomFont)tf)) continue;
            resTracker.registerSuppliedResource(fontRes);
        }
        return fontResources;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

