/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.java2d.FontSetup;
import org.apache.fop.render.java2d.Java2DGraphics2DAdapter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.util.CharUtilities;
import org.w3c.dom.Document;

public abstract class Java2DRenderer
extends AbstractPathOrientedRenderer
implements Printable {
    public static final String JAVA2D_TRANSPARENT_PAGE_BACKGROUND = "transparent-page-background";
    protected double scaleFactor = 1.0;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected List pageViewportList = new ArrayList();
    private int currentPageNumber = 0;
    private int numberOfPages;
    protected boolean antialiasing = true;
    protected boolean qualityRendering = true;
    protected boolean transparentPageBackground = false;
    protected Java2DGraphicsState state;
    private Stack stateStack = new Stack();
    private boolean renderingDone;
    private GeneralPath currentPath = null;

    public void setUserAgent(FOUserAgent foUserAgent) {
        super.setUserAgent(foUserAgent);
        this.userAgent.setRendererOverride(this);
        String s = (String)this.userAgent.getRendererOptions().get(JAVA2D_TRANSPARENT_PAGE_BACKGROUND);
        if (s != null) {
            this.transparentPageBackground = "true".equalsIgnoreCase(s);
        }
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        BufferedImage fontImage = new BufferedImage(100, 100, 1);
        Graphics2D g = fontImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontSetup.setup(this.fontInfo, g);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new Java2DGraphics2DAdapter(this.state);
    }

    public void setScaleFactor(double newScaleFactor) {
        this.scaleFactor = newScaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void startRenderer(OutputStream out) throws IOException {
    }

    public void stopRenderer() throws IOException {
        log.debug("Java2DRenderer stopped");
        this.renderingDone = true;
        this.numberOfPages = this.currentPageNumber;
        if (this.numberOfPages == 0) {
            new FOPException("No page could be rendered");
        }
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(int c) {
        this.currentPageNumber = c;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void clearViewportList() {
        this.pageViewportList.clear();
        this.setCurrentPageNumber(0);
    }

    public void renderPage(PageViewport pageViewport) throws IOException {
        this.pageViewportList.add(pageViewport.clone());
        ++this.currentPageNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPageImage(PageViewport pageViewport) {
        this.currentPageViewport = pageViewport;
        try {
            Rectangle2D bounds = pageViewport.getViewArea();
            this.pageWidth = (int)Math.round(bounds.getWidth() / 1000.0);
            this.pageHeight = (int)Math.round(bounds.getHeight() / 1000.0);
            log.info("Rendering Page " + pageViewport.getPageNumberString() + " (pageWidth " + this.pageWidth + ", pageHeight " + this.pageHeight + ")");
            double scaleX = this.scaleFactor * 0.35277777777777775 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            double scaleY = this.scaleFactor * 0.35277777777777775 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            int bitmapWidth = (int)((double)this.pageWidth * scaleX + 0.5);
            int bitmapHeight = (int)((double)this.pageHeight * scaleY + 0.5);
            BufferedImage currentPageImage = this.getBufferedImage(bitmapWidth, bitmapHeight);
            Graphics2D graphics = currentPageImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (this.antialiasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.qualityRendering) {
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            AffineTransform at = graphics.getTransform();
            at.scale(scaleX, scaleY);
            graphics.setTransform(at);
            if (!this.transparentPageBackground) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.pageWidth, this.pageHeight);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(-1, -1, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(this.pageWidth + 2, 0, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(this.pageWidth + 3, 1, this.pageWidth + 3, this.pageHeight + 3);
            graphics.drawLine(0, this.pageHeight + 2, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(1, this.pageHeight + 3, this.pageWidth + 3, this.pageHeight + 3);
            this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
            try {
                this.currentBPPosition = 0;
                this.currentIPPosition = 0;
                this.renderPageAreas(pageViewport.getPage());
            }
            finally {
                this.state = null;
            }
            BufferedImage bufferedImage = currentPageImage;
            return bufferedImage;
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected BufferedImage getBufferedImage(int bitmapWidth, int bitmapHeight) {
        return new BufferedImage(bitmapWidth, bitmapHeight, 2);
    }

    public PageViewport getPageViewport(int pageNum) throws FOPException {
        if (pageNum < 0 || pageNum >= this.pageViewportList.size()) {
            throw new FOPException("Requested page number is out of range: " + pageNum + "; only " + this.pageViewportList.size() + " page(s) available.");
        }
        return (PageViewport)this.pageViewportList.get(pageNum);
    }

    public BufferedImage getPageImage(int pageNum) throws FOPException {
        return this.getPageImage(this.getPageViewport(pageNum));
    }

    protected void saveGraphicsState() {
        this.stateStack.push(this.state);
        this.state = new Java2DGraphicsState(this.state);
    }

    protected void restoreGraphicsState() {
        this.state.dispose();
        this.state = (Java2DGraphicsState)this.stateStack.pop();
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        this.state.transform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
    }

    protected void endVParea() {
        this.restoreGraphicsState();
    }

    protected List breakOutOfStateStack() {
        log.debug("Block.FIXED --> break out");
        ArrayList<Java2DGraphicsState> breakOutList = new ArrayList<Java2DGraphicsState>();
        while (!this.stateStack.isEmpty()) {
            breakOutList.add(0, this.state);
            this.state = (Java2DGraphicsState)this.stateStack.pop();
        }
        return breakOutList;
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        log.debug("Block.FIXED --> restoring context after break-out");
        Iterator i = breakOutList.iterator();
        while (i.hasNext()) {
            Java2DGraphicsState s = (Java2DGraphicsState)i.next();
            this.stateStack.push(this.state);
            this.state = s;
        }
    }

    protected void updateColor(Color col, boolean fill) {
        this.state.updateColor(col);
    }

    protected void clip() {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.state.updateClip(this.currentPath);
        this.currentPath = null;
    }

    protected void closePath() {
        this.currentPath.closePath();
    }

    protected void lineTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(x, y);
    }

    protected void moveTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(x, y);
    }

    protected void clipRect(float x, float y, float width, float height) {
        this.state.updateClip(new Rectangle2D.Float(x, y, width, height));
    }

    protected void fillRect(float x, float y, float width, float height) {
        this.state.getGraph().fill(new Rectangle2D.Float(x, y, width, height));
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        Graphics2D g2d = this.state.getGraph();
        Java2DRenderer.drawBorderLine(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1), horz, startOrBefore, style, col, g2d);
    }

    public static void drawBorderLine(Rectangle2D.Float lineRect, boolean horz, boolean startOrBefore, int style, Color col, Graphics2D g2d) {
        float x1 = lineRect.x;
        float y1 = lineRect.y;
        float x2 = x1 + lineRect.width;
        float y2 = y1 + lineRect.height;
        float w = lineRect.width;
        float h = lineRect.height;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                g2d.setColor(col);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 36: {
                g2d.setColor(col);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 37: {
                g2d.setColor(col);
                if (horz) {
                    float h3 = h / 3.0f;
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    BasicStroke s = new BasicStroke(h3);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    g2d.draw(new Line2D.Float(x1, ym2, x2, ym2));
                    break;
                }
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                BasicStroke s = new BasicStroke(w3);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                g2d.draw(new Line2D.Float(xm2, y1, xm2, y2));
                break;
            }
            case 55: 
            case 119: {
                float colFactor;
                float f = colFactor = style == 55 ? 0.4f : -0.4f;
                if (horz) {
                    Color uppercol = Java2DRenderer.lightenColor(col, -colFactor);
                    Color lowercol = Java2DRenderer.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    float ym1 = y1 + h3 / 2.0f;
                    g2d.setStroke(new BasicStroke(h3));
                    g2d.setColor(uppercol);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    g2d.setColor(col);
                    g2d.draw(new Line2D.Float(x1, ym1 + h3, x2, ym1 + h3));
                    g2d.setColor(lowercol);
                    g2d.draw(new Line2D.Float(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3));
                    break;
                }
                Color leftcol = Java2DRenderer.lightenColor(col, -colFactor);
                Color rightcol = Java2DRenderer.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                g2d.setStroke(new BasicStroke(w3));
                g2d.setColor(leftcol);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                g2d.setColor(col);
                g2d.draw(new Line2D.Float(xm1 + w3, y1, xm1 + w3, y2));
                g2d.setColor(rightcol);
                g2d.draw(new Line2D.Float(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2));
                break;
            }
            case 67: 
            case 101: {
                float colFactor;
                float f = colFactor = style == 101 ? 0.4f : -0.4f;
                if (horz) {
                    col = Java2DRenderer.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                    g2d.setStroke(new BasicStroke(h));
                    float ym1 = y1 + h / 2.0f;
                    g2d.setColor(col);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    break;
                }
                col = Java2DRenderer.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                float xm1 = x1 + w / 2.0f;
                g2d.setStroke(new BasicStroke(w));
                g2d.setColor(col);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                break;
            }
            case 57: {
                break;
            }
            default: {
                g2d.setColor(col);
                if (horz) {
                    float ym = y1 + h / 2.0f;
                    g2d.setStroke(new BasicStroke(h));
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float xm = x1 + w / 2.0f;
                g2d.setStroke(new BasicStroke(w));
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
            }
        }
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        int saveIP = this.currentIPPosition;
        Font font = this.getFontFromArea(text);
        this.state.updateFont(font.getFontName(), font.getFontSize());
        this.saveGraphicsState();
        AffineTransform at = new AffineTransform();
        at.translate((float)rx / 1000.0f, (float)bl / 1000.0f);
        this.state.transform(at);
        Java2DRenderer.renderText(text, this.state.getGraph(), font);
        this.restoreGraphicsState();
        this.currentIPPosition = saveIP + text.getAllocIPD();
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        int fontsize = text.getTraitAsInteger(Trait.FONT_SIZE);
        this.renderTextDecoration(tf, fontsize, text, bl, rx);
    }

    public static void renderText(TextArea text, Graphics2D g2d, Font font) {
        Color col = (Color)text.getTrait(Trait.COLOR);
        g2d.setColor(col);
        float textCursor = 0.0f;
        Iterator iter = text.getChildAreas().iterator();
        while (iter.hasNext()) {
            String s;
            InlineArea child = (InlineArea)iter.next();
            if (child instanceof WordArea) {
                WordArea word = (WordArea)child;
                s = word.getWord();
                int[] letterAdjust = word.getLetterAdjustArray();
                GlyphVector gv = g2d.getFont().createGlyphVector(g2d.getFontRenderContext(), s);
                double additionalWidth = 0.0;
                if (letterAdjust != null || text.getTextLetterSpaceAdjust() != 0 || text.getTextWordSpaceAdjust() != 0) {
                    int[] offsets = Java2DRenderer.getGlyphOffsets(s, font, text, letterAdjust);
                    float cursor = 0.0f;
                    for (int i = 0; i < offsets.length; ++i) {
                        Point2D pt = gv.getGlyphPosition(i);
                        pt.setLocation(cursor, pt.getY());
                        gv.setGlyphPosition(i, pt);
                        cursor += (float)offsets[i] / 1000.0f;
                    }
                    additionalWidth = (double)cursor - gv.getLogicalBounds().getWidth();
                }
                g2d.drawGlyphVector(gv, textCursor, 0.0f);
                textCursor = (float)((double)textCursor + (gv.getLogicalBounds().getWidth() + additionalWidth));
                continue;
            }
            if (child instanceof SpaceArea) {
                SpaceArea space = (SpaceArea)child;
                s = space.getSpace();
                char sp = s.charAt(0);
                int tws = space.isAdjustable() ? text.getTextWordSpaceAdjust() + 2 * text.getTextLetterSpaceAdjust() : 0;
                textCursor += (float)(font.getCharWidth(sp) + tws) / 1000.0f;
                continue;
            }
            throw new IllegalStateException("Unsupported child element: " + child);
        }
    }

    private static int[] getGlyphOffsets(String s, Font font, TextArea text, int[] letterAdjust) {
        int textLen = s.length();
        int[] offsets = new int[textLen];
        for (int i = 0; i < textLen; ++i) {
            char c = s.charAt(i);
            char mapped = font.mapChar(c);
            int wordSpace = CharUtilities.isAdjustableSpace(mapped) ? text.getTextWordSpaceAdjust() : 0;
            int cw = font.getWidth(mapped);
            int ladj = letterAdjust != null && i < textLen - 1 ? letterAdjust[i + 1] : 0;
            int tls = i < textLen - 1 ? text.getTextLetterSpaceAdjust() : 0;
            offsets[i] = cw + ladj + tls + wordSpace;
        }
        return offsets;
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        this.state.updateColor(col);
        Line2D.Float line = new Line2D.Float();
        ((Line2D)line).setLine(startx, starty, endx, starty);
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        int style = area.getRuleStyle();
        switch (style) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 36: {
                this.state.updateStroke(ruleThickness, style);
                float rt2 = ruleThickness / 2.0f;
                ((Line2D)line).setLine(((Line2D)line).getX1(), ((Line2D)line).getY1() + (double)rt2, ((Line2D)line).getX2(), ((Line2D)line).getY2() + (double)rt2);
                this.state.getGraph().draw(line);
                break;
            }
            case 55: 
            case 119: {
                float half = (float)area.getRuleThickness() / 2000.0f;
                this.state.updateColor(Java2DRenderer.lightenColor(col, 0.6f));
                this.moveTo(startx, starty);
                this.lineTo(endx, starty);
                this.lineTo(endx, starty + 2.0f * half);
                this.lineTo(startx, starty + 2.0f * half);
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
                this.state.updateColor(col);
                if (style == 55) {
                    this.moveTo(startx, starty);
                    this.lineTo(endx, starty);
                    this.lineTo(endx, starty + half);
                    this.lineTo(startx + half, starty + half);
                    this.lineTo(startx, starty + 2.0f * half);
                } else {
                    this.moveTo(endx, starty);
                    this.lineTo(endx, starty + 2.0f * half);
                    this.lineTo(startx, starty + 2.0f * half);
                    this.lineTo(startx, starty + half);
                    this.lineTo(endx - half, starty + half);
                }
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
            }
            case 95: {
                break;
            }
        }
        super.renderLeader(area);
    }

    public void renderImage(Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.drawImage(url, pos);
    }

    protected void drawImage(String url, Rectangle2D pos, Map foreignAttributes) {
        int x = this.currentIPPosition + (int)Math.round(pos.getX());
        int y = this.currentBPPosition + (int)Math.round(pos.getY());
        url = ImageFactory.getURL(url);
        ImageFactory fact = this.userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        int w = fopimage.getWidth();
        int h = fopimage.getHeight();
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, foreignAttributes);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos, foreignAttributes);
        } else if ("image/eps".equals(mime)) {
            log.warn("EPS images are not supported by this renderer");
        } else {
            if (!fopimage.load(4)) {
                log.warn("Loading of bitmap failed: " + url);
                return;
            }
            byte[] raw = fopimage.getBitmaps();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), new int[]{8, 8, 8}, false, false, 1, 0);
            PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(0, w, h, 3, w * 3, new int[]{0, 1, 2});
            DataBufferByte dbuf = new DataBufferByte(raw, w * h * 3);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
            BufferedImage awtImage = new BufferedImage(cm, raster, false, null);
            this.state.getGraph().drawImage(awtImage, (int)((float)x / 1000.0f), (int)((float)y / 1000.0f), (int)(pos.getWidth() / 1000.0), (int)(pos.getHeight() / 1000.0), null);
        }
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("state", this.state);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        if (this.state != null) {
            throw new IllegalStateException("state must be null");
        }
        Graphics2D graphics = (Graphics2D)g;
        try {
            PageViewport viewport = this.getPageViewport(pageIndex);
            AffineTransform at = graphics.getTransform();
            this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            this.renderPageAreas(viewport.getPage());
            int n = 0;
            return n;
        }
        catch (FOPException e) {
            log.error(e);
            int n = 1;
            return n;
        }
        finally {
            this.state = null;
        }
    }

    protected void beginTextObject() {
    }

    protected void endTextObject() {
    }

    public void setTransparentPageBackground(boolean transparentPageBackground) {
        this.transparentPageBackground = transparentPageBackground;
    }
}

