/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.fop.render.afp.exceptions.FontRuntimeException;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.fonts.CharacterSet;
import org.apache.fop.render.afp.fonts.OutlineFont;
import org.apache.fop.render.afp.fonts.RasterFont;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class MapCodedFont
extends AbstractAFPObject {
    private ArrayList _fontlist = new ArrayList();

    public void writeDataStream(OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(90);
        baos.write(new byte[]{0, 0});
        baos.write(new byte[]{-45, -85, -118});
        baos.write(new byte[]{0, 0, 0});
        for (int i = 0; i < this._fontlist.size(); ++i) {
            FontDefinition fd = (FontDefinition)this._fontlist.get(i);
            baos.write(0);
            if (fd._scale == 0) {
                baos.write(34);
            } else {
                baos.write(58);
            }
            baos.write(12);
            baos.write(2);
            baos.write(-122);
            baos.write(0);
            baos.write(fd._characterset);
            baos.write(12);
            baos.write(2);
            baos.write(-123);
            baos.write(0);
            baos.write(fd._codepage);
            baos.write(4);
            baos.write(38);
            baos.write(fd._orientation);
            baos.write(0);
            baos.write(4);
            baos.write(36);
            baos.write(5);
            baos.write(fd._fontReferenceKey);
            if (fd._scale == 0) continue;
            baos.write(20);
            baos.write(31);
            baos.write(0);
            baos.write(0);
            baos.write(BinaryUtils.convert(fd._scale, 2));
            baos.write(new byte[]{0, 0});
            baos.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            baos.write(96);
            baos.write(4);
            baos.write(93);
            baos.write(BinaryUtils.convert(fd._scale, 2));
        }
        byte[] data = baos.toByteArray();
        byte[] rl1 = BinaryUtils.convert(data.length - 1, 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        os.write(data);
    }

    public void addFont(byte fontReference, AFPFont font, int size, int orientation) throws MaximumSizeExceededException {
        FontDefinition fd = new FontDefinition();
        fd._fontReferenceKey = fontReference;
        switch (orientation) {
            case 90: {
                fd._orientation = (byte)45;
                break;
            }
            case 180: {
                fd._orientation = (byte)90;
                break;
            }
            case 270: {
                fd._orientation = (byte)-121;
                break;
            }
            default: {
                fd._orientation = (byte)0;
            }
        }
        try {
            if (font instanceof RasterFont) {
                RasterFont raster = (RasterFont)font;
                CharacterSet cs = raster.getCharacterSet(size);
                if (cs == null) {
                    String msg = "Character set not found for font " + font.getFontName() + " with point size " + size;
                    log.error(msg);
                    throw new FontRuntimeException(msg);
                }
                FontDefinition.access$102(fd, cs.getNameBytes());
                if (fd._characterset.length != 8) {
                    throw new IllegalArgumentException("The character set " + new String(fd._characterset, "Cp1146") + " must have a fixed length of 8 characters.");
                }
                FontDefinition.access$202(fd, cs.getCodePage().getBytes("Cp1146"));
                if (fd._codepage.length != 8) {
                    throw new IllegalArgumentException("The code page " + new String(fd._codepage, "Cp1146") + " must have a fixed length of 8 characters.");
                }
            } else if (font instanceof OutlineFont) {
                OutlineFont outline = (OutlineFont)font;
                CharacterSet cs = outline.getCharacterSet();
                FontDefinition.access$102(fd, cs.getNameBytes());
                fd._scale = size / 1000 * 20;
                FontDefinition.access$202(fd, cs.getCodePage().getBytes("Cp1146"));
                if (fd._codepage.length != 8) {
                    throw new IllegalArgumentException("The code page " + new String(fd._codepage, "Cp1146") + " must have a fixed length of 8 characters.");
                }
            } else {
                String msg = "Font of type " + font.getClass().getName() + " not recognized.";
                log.error(msg);
                throw new FontRuntimeException(msg);
            }
            if (this._fontlist.size() > 253) {
                throw new MaximumSizeExceededException();
            }
            this._fontlist.add(fd);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FontRuntimeException("Failed to create font  due to a UnsupportedEncodingException", ex);
        }
    }

    private class FontDefinition {
        private byte[] _codepage;
        private byte[] _characterset;
        private byte _fontReferenceKey;
        private byte _orientation;
        private int _scale = 0;

        private FontDefinition() {
        }

        static /* synthetic */ byte[] access$102(FontDefinition x0, byte[] x1) {
            x0._characterset = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$202(FontDefinition x0, byte[] x1) {
            x0._codepage = x1;
            return x1;
        }
    }
}

