/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.exceptions.FontRuntimeException;
import org.apache.fop.render.afp.fonts.CharacterSet;
import org.apache.fop.render.afp.fonts.CharacterSetOrientation;
import org.apache.fop.render.afp.tools.StructuredFieldReader;

public final class AFPFontReader {
    protected static final Log log = LogFactory.getLog("org.apache.fop.render.afp.fonts");
    private static final CharacterSetOrientation[] EMPTY_CSO_ARRAY = new CharacterSetOrientation[0];
    private static final byte[] CODEPAGE_SF = new byte[]{-45, -88, -121};
    private static final byte[] CHARACTER_TABLE_SF = new byte[]{-45, -116, -121};
    private static final byte[] FONT_CONTROL_SF = new byte[]{-45, -89, -119};
    private static final byte[] FONT_ORIENTATION_SF = new byte[]{-45, -82, -119};
    private static final byte[] FONT_POSITION_SF = new byte[]{-45, -84, -119};
    private static final byte[] FONT_INDEX_SF = new byte[]{-45, -116, -119};
    private static final int FOP_100_DPI_FACTOR = 1;
    private static final int FOP_240_DPI_FACTOR = 300000;
    private static final int FOP_300_DPI_FACTOR = 240000;
    private static final String ASCII_ENCODING = "UTF8";
    private HashMap _codePages = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$render$afp$fonts$AFPFontReader;

    public void loadCharacterSetMetric(CharacterSet characterSet) {
        InputStream inputStream = null;
        try {
            String msg;
            String filterpattern;
            FilenameFilter filter;
            File directory;
            File[] csfont;
            URL url;
            String cp = new String(characterSet.getCodePage());
            String path = characterSet.getPath();
            HashMap codepage = (HashMap)this._codePages.get(cp);
            if (codepage == null) {
                codepage = AFPFontReader.loadCodePage(cp, characterSet.getEncoding(), path);
                this._codePages.put(cp, codepage);
            }
            String characterset = characterSet.getName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = (class$org$apache$fop$render$afp$fonts$AFPFontReader == null ? (class$org$apache$fop$render$afp$fonts$AFPFontReader = AFPFontReader.class$("org.apache.fop.render.afp.fonts.AFPFontReader")) : class$org$apache$fop$render$afp$fonts$AFPFontReader).getClassLoader();
            }
            if ((url = classLoader.getResource(path)) == null) {
                try {
                    File file = new File(path);
                    url = file.toURL();
                    if (url == null) {
                        String msg2 = "CharacterSet file not found for " + characterset + " in classpath: " + path;
                        log.error(msg2);
                        throw new FileNotFoundException(msg2);
                    }
                }
                catch (MalformedURLException ex) {
                    String msg3 = "CharacterSet file not found for " + characterset + " in classpath: " + path;
                    log.error(msg3);
                    throw new FileNotFoundException(msg3);
                }
            }
            if ((csfont = (directory = new File(url.getPath())).listFiles(filter = new FilenameFilter(filterpattern = characterset.trim()){
                private final /* synthetic */ String val$filterpattern;
                {
                    this.val$filterpattern = val$filterpattern;
                }

                public boolean accept(File dir, String name) {
                    return name.startsWith(this.val$filterpattern);
                }
            })).length < 1) {
                String msg4 = "CharacterSet file search for " + characterset + " located " + csfont.length + " files";
                log.error(msg4);
                throw new FileNotFoundException(msg4);
            }
            if (csfont.length > 1) {
                msg = "CharacterSet file search for " + characterset + " located " + csfont.length + " files";
                log.warn(msg);
            }
            inputStream = csfont[0].toURL().openStream();
            if (inputStream == null) {
                msg = "Failed to open character set resource " + characterset;
                log.error(msg);
                throw new FileNotFoundException(msg);
            }
            StructuredFieldReader sfr = new StructuredFieldReader(inputStream);
            FontControl fnc = AFPFontReader.processFontControl(sfr);
            CharacterSetOrientation[] csoArray = AFPFontReader.processFontOrientation(sfr);
            AFPFontReader.processFontPosition(sfr, csoArray, fnc.getDpi());
            for (int i = 0; i < csoArray.length; ++i) {
                AFPFontReader.processFontIndex(sfr, csoArray[i], codepage, fnc.getDpi());
                characterSet.addCharacterSetOrientation(csoArray[i]);
            }
        }
        catch (Exception ex) {
            throw new FontRuntimeException("Failed to load the character set metrics for code page " + characterSet.getCodePage(), ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception ex) {}
        }
    }

    private static HashMap loadCodePage(String codePage, String encoding, String path) throws IOException, FileNotFoundException {
        InputStream is;
        File directory;
        URL url;
        HashMap<String, String> codepages = new HashMap<String, String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$fop$render$afp$fonts$AFPFontReader == null ? (class$org$apache$fop$render$afp$fonts$AFPFontReader = AFPFontReader.class$("org.apache.fop.render.afp.fonts.AFPFontReader")) : class$org$apache$fop$render$afp$fonts$AFPFontReader).getClassLoader();
        }
        if ((url = classLoader.getResource(path)) == null) {
            try {
                File file = new File(path);
                url = file.toURL();
                if (url == null) {
                    String msg = "CodePage file not found for " + codePage + " in classpath: " + path;
                    log.error(msg);
                    throw new FileNotFoundException(msg);
                }
            }
            catch (MalformedURLException ex) {
                String msg = "CodePage file not found for " + codePage + " in classpath: " + path;
                log.error(msg);
                throw new FileNotFoundException(msg);
            }
        }
        if (!(directory = new File(url.getPath())).canRead()) {
            String msg = "Failed to read directory " + url.getPath();
            log.error(msg);
            throw new FileNotFoundException(msg);
        }
        final String filterpattern = codePage.trim();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(filterpattern);
            }
        };
        File[] codepage = directory.listFiles(filter);
        if (codepage.length < 1) {
            String msg = "CodePage file search for " + codePage + " located " + codepage.length + " files";
            log.error(msg);
            throw new FileNotFoundException(msg);
        }
        if (codepage.length > 1) {
            String msg = "CodePage file search for " + codePage + " located " + codepage.length + " files";
            log.warn(msg);
        }
        if ((is = codepage[0].toURL().openStream()) == null) {
            String msg = "AFPFontReader:: loadCodePage(String):: code page file not found for " + codePage;
            log.error(msg);
            throw new FileNotFoundException(msg);
        }
        StructuredFieldReader sfr = new StructuredFieldReader(is);
        byte[] data = sfr.getNext(CHARACTER_TABLE_SF);
        int position = 0;
        byte[] gcgiBytes = new byte[8];
        byte[] charBytes = new byte[1];
        for (int index = 3; index < data.length; ++index) {
            if (position < 8) {
                gcgiBytes[position] = data[index];
                ++position;
                continue;
            }
            if (position == 9) {
                position = 0;
                charBytes[0] = data[index];
                String gcgiString = new String(gcgiBytes, "Cp1146");
                String charString = new String(charBytes, encoding);
                char value = charString.charAt(0);
                codepages.put(gcgiString, charString);
                continue;
            }
            ++position;
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return codepages;
    }

    private static FontControl processFontControl(StructuredFieldReader sfr) throws IOException {
        byte[] fncData = sfr.getNext(FONT_CONTROL_SF);
        boolean position = false;
        AFPFontReader aFPFontReader = new AFPFontReader();
        aFPFontReader.getClass();
        FontControl fontControl = aFPFontReader.new FontControl();
        if (fncData[7] == 2) {
            fontControl.setRelative(true);
        }
        int dpi = (((fncData[9] & 0xFF) << 8) + (fncData[10] & 0xFF)) / 10;
        fontControl.setDpi(dpi);
        return fontControl;
    }

    private static CharacterSetOrientation[] processFontOrientation(StructuredFieldReader sfr) throws IOException {
        byte[] data = sfr.getNext(FONT_ORIENTATION_SF);
        int position = 0;
        byte[] fnoData = new byte[26];
        ArrayList<CharacterSetOrientation> orientations = new ArrayList<CharacterSetOrientation>();
        for (int index = 3; index < data.length; ++index) {
            fnoData[position] = data[index];
            if (++position != 26) continue;
            position = 0;
            int orientation = 0;
            switch (fnoData[2]) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 45: {
                    orientation = 90;
                    break;
                }
                case 90: {
                    orientation = 180;
                    break;
                }
                case -121: {
                    orientation = 270;
                    break;
                }
                default: {
                    System.out.println("ERROR: Oriantation");
                }
            }
            CharacterSetOrientation cso = new CharacterSetOrientation(orientation);
            orientations.add(cso);
        }
        return orientations.toArray(EMPTY_CSO_ARRAY);
    }

    private static void processFontPosition(StructuredFieldReader sfr, CharacterSetOrientation[] csoArray, int dpi) throws IOException {
        byte[] data = sfr.getNext(FONT_POSITION_SF);
        int position = 0;
        byte[] fpData = new byte[26];
        int csoIndex = 0;
        int fopFactor = 0;
        switch (dpi) {
            case 100: {
                fopFactor = 1;
                break;
            }
            case 240: {
                fopFactor = 300000;
                break;
            }
            case 300: {
                fopFactor = 240000;
                break;
            }
            default: {
                String msg = "Unsupported font resolution of " + dpi + " dpi.";
                log.error(msg);
                throw new IOException(msg);
            }
        }
        for (int index = 3; index < data.length; ++index) {
            if (position < 22) {
                fpData[position] = data[index];
            } else if (position == 22) {
                position = 0;
                CharacterSetOrientation cso = csoArray[csoIndex];
                int xHeight = ((fpData[2] & 0xFF) << 8) + (fpData[3] & 0xFF);
                int capHeight = ((fpData[4] & 0xFF) << 8) + (fpData[5] & 0xFF);
                int ascHeight = ((fpData[6] & 0xFF) << 8) + (fpData[7] & 0xFF);
                int dscHeight = ((fpData[8] & 0xFF) << 8) + (fpData[9] & 0xFF);
                cso.setXHeight(xHeight * fopFactor);
                cso.setCapHeight(capHeight * fopFactor);
                cso.setAscender(ascHeight * fopFactor);
                cso.setDescender((dscHeight *= -1) * fopFactor);
                ++csoIndex;
                fpData[position] = data[index];
            }
            ++position;
        }
    }

    private static void processFontIndex(StructuredFieldReader sfr, CharacterSetOrientation cso, HashMap codepage, int dpi) throws IOException {
        byte[] data = sfr.getNext(FONT_INDEX_SF);
        int fopFactor = 0;
        switch (dpi) {
            case 100: {
                fopFactor = 1;
                break;
            }
            case 240: {
                fopFactor = 300000;
                break;
            }
            case 300: {
                fopFactor = 240000;
                break;
            }
            default: {
                String msg = "Unsupported font resolution of " + dpi + " dpi.";
                log.error(msg);
                throw new IOException(msg);
            }
        }
        int position = 0;
        byte[] gcgid = new byte[8];
        byte[] fiData = new byte[20];
        char lowest = '\u00ff';
        char highest = '\u0000';
        for (int index = 3; index < data.length; ++index) {
            if (position < 8) {
                gcgid[position] = data[index];
                ++position;
                continue;
            }
            if (position < 27) {
                fiData[position - 8] = data[index];
                ++position;
                continue;
            }
            if (position != 27) continue;
            fiData[position - 8] = data[index];
            position = 0;
            String gcgiString = new String(gcgid, "Cp1146");
            String idx = (String)codepage.get(gcgiString);
            if (idx == null) continue;
            char cidx = idx.charAt(0);
            int width = ((fiData[0] & 0xFF) << 8) + (fiData[1] & 0xFF);
            if (cidx < lowest) {
                lowest = cidx;
            }
            if (cidx > highest) {
                highest = cidx;
            }
            int a = width * fopFactor;
            cso.setWidth(cidx, a);
        }
        cso.setFirstChar(lowest);
        cso.setLastChar(highest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FontControl {
        private int _dpi;
        private boolean isRelative = false;

        private FontControl() {
        }

        public int getDpi() {
            return this._dpi;
        }

        public void setDpi(int i) {
            this._dpi = i;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean b) {
            this.isRelative = b;
        }
    }
}

