/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.TimesRoman;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.TIFFImage;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.afp.AFPFontAttributes;
import org.apache.fop.render.afp.AFPGraphics2DAdapter;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.fonts.AFPFontInfo;
import org.apache.fop.render.afp.fonts.FopCharacterSet;
import org.apache.fop.render.afp.fonts.OutlineFont;
import org.apache.fop.render.afp.modca.AFPDataStream;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.PageObject;
import org.w3c.dom.Document;

public class AFPRenderer
extends AbstractPathOrientedRenderer {
    private static final int DPI_CONVERSION_FACTOR_240 = 300;
    private AFPDataStream _afpDataStream = null;
    private HashMap _rootExtensionMap = null;
    private HashMap _pageSegmentsMap = null;
    private HashMap _currentPageFonts = null;
    private Color _currentColor = null;
    private int _pageFontCounter = 0;
    private String _currentFontFamily = "";
    private int _currentFontSize = 0;
    private Map _afpOptions = null;
    private int _pageWidth = 0;
    private int _pageHeight = 0;
    private String _pageSequenceId = null;
    private int _portraitRotation = 0;
    private int _landscapeRotation = 270;
    private HashSet _lineCache = null;
    private float _x;
    private float _y;
    private Map _pages = null;
    private boolean colorImages = false;
    private int bitsPerPixel = 8;
    private List viewPortPositions = new ArrayList();

    public void setupFontInfo(FontInfo inFontInfo) {
        OutlineFont bf;
        FopCharacterSet cs;
        this.fontInfo = inFontInfo;
        int num = 1;
        if (this.fontList != null && this.fontList.size() > 0) {
            Iterator it = this.fontList.iterator();
            while (it.hasNext()) {
                AFPFontInfo afi = (AFPFontInfo)it.next();
                AFPFont bf2 = afi.getAFPFont();
                Iterator it2 = afi.getFontTriplets().iterator();
                while (it2.hasNext()) {
                    FontTriplet ft = (FontTriplet)it2.next();
                    this.fontInfo.addFontProperties("F" + num, ft.getName(), ft.getStyle(), ft.getWeight());
                    this.fontInfo.addMetrics("F" + num, bf2);
                    ++num;
                }
            }
        } else {
            log.warn("No AFP fonts configured - using default setup");
        }
        if (this.fontInfo.fontLookup("sans-serif", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZH200  ", 1, new Helvetica());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "sans-serif", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("serif", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZN200  ", 1, new TimesRoman());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "serif", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("monospace", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZ4200  ", 1, new Courier());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "monospace", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("any", "normal", 400) == null) {
            FontTriplet ft = this.fontInfo.fontLookup("sans-serif", "normal", 400);
            this.fontInfo.addFontProperties(this.fontInfo.getInternalFontKey(ft), "any", "normal", 400);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this._currentPageFonts = new HashMap();
        this._currentColor = new Color(255, 255, 255);
        this._afpDataStream = new AFPDataStream();
        this._afpDataStream.setPortraitRotation(this._portraitRotation);
        this._afpDataStream.setLandscapeRotation(this._landscapeRotation);
        this._afpDataStream.startDocument(outputStream);
    }

    public void stopRenderer() throws IOException {
        this._afpDataStream.endDocument();
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void preparePage(PageViewport pageViewport) {
        this._currentFontFamily = "";
        this._currentFontSize = 0;
        this._pageFontCounter = 0;
        this._currentPageFonts.clear();
        this._lineCache = new HashSet();
        Rectangle2D bounds = pageViewport.getViewArea();
        this._pageWidth = this.mpts2units(bounds.getWidth());
        this._pageHeight = this.mpts2units(bounds.getHeight());
        this._afpDataStream.startPage(this._pageWidth, this._pageHeight, 0);
        this.renderPageObjectExtensions(pageViewport);
        if (this._pages == null) {
            this._pages = new HashMap();
        }
        this._pages.put(pageViewport, this._afpDataStream.savePage());
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new AFPGraphics2DAdapter();
    }

    public void startVParea(CTM ctm, Rectangle2D clippingRect) {
    }

    public void endVParea() {
    }

    public void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            Rectangle2D view = port.getViewArea();
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            RegionReference regionReference = port.getRegionReference();
            this.handleRegionTraits(port);
            this.pushViewPortPos(new ViewPortPos(view, regionReference.getCTM()));
            if (regionReference.getRegionClass() == 36) {
                this.renderBodyRegion((BodyRegion)regionReference);
            } else {
                this.renderRegion(regionReference);
            }
            this.popViewPortPos();
        }
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float x = (float)(bv.getXOffset() + this.containingIPPosition) / 1000.0f;
        float y = (float)(bv.getYOffset() + this.containingBPPosition) / 1000.0f;
        float width = (float)bv.getIPD() / 1000.0f;
        float height = (float)bv.getBPD() / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            this.currentIPPosition = bv.getXOffset();
            this.currentBPPosition = bv.getYOffset();
            List breakOutList = null;
            if (bv.getPositioning() == 3) {
                breakOutList = this.breakOutOfStateStack();
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentIPPosition += bv.getSpaceStart();
            this.currentBPPosition += bv.getSpaceBefore();
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(bv, x += (float)bv.getSpaceStart() / 1000.0f, y += (float)bv.getSpaceBefore() / 1000.0f, width + bpwidth, height + bpheight);
            this.currentIPPosition += borderPaddingStart;
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            this.pushViewPortPos(new ViewPortPos(clippingRect, ctm));
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.popViewPortPos();
            if (breakOutList != null) {
                this.restoreStateStackAfterBreakOut(breakOutList);
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.currentBPPosition += bv.getSpaceBefore();
            this.handleBlockTraits(bv);
            this.currentIPPosition += bv.getStartIndent();
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            this.pushViewPortPos(new ViewPortPos(clippingRect, ctm));
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.popViewPortPos();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
    }

    public void renderPage(PageViewport pageViewport) {
        this._currentFontFamily = "";
        this._currentFontSize = 0;
        this._pageFontCounter = 0;
        this._currentPageFonts.clear();
        this._lineCache = new HashSet();
        Rectangle2D bounds = pageViewport.getViewArea();
        this._pageWidth = this.mpts2units(bounds.getWidth());
        this._pageHeight = this.mpts2units(bounds.getHeight());
        if (this._pages != null && this._pages.containsKey(pageViewport)) {
            this._afpDataStream.restorePage((PageObject)this._pages.remove(pageViewport));
        } else {
            this._afpDataStream.startPage(this._pageWidth, this._pageHeight, 0);
            this.renderPageObjectExtensions(pageViewport);
        }
        this.pushViewPortPos(new ViewPortPos());
        this.renderPageAreas(pageViewport.getPage());
        Iterator i = this._currentPageFonts.values().iterator();
        while (i.hasNext()) {
            AFPFontAttributes afpFontAttributes = (AFPFontAttributes)i.next();
            this._afpDataStream.createFont(afpFontAttributes.getFontReference(), afpFontAttributes.getFont(), afpFontAttributes.getPointSize());
        }
        try {
            this._afpDataStream.endPage();
        }
        catch (IOException ioex) {
            // empty catch block
        }
        this.popViewPortPos();
    }

    public void clip() {
    }

    public void clipRect(float x, float y, float width, float height) {
    }

    public void moveTo(float x, float y) {
    }

    public void lineTo(float x, float y) {
    }

    public void closePath() {
    }

    public void fillRect(float x, float y, float width, float height) {
        this._afpDataStream.createLine(this.pts2units(x), this.pts2units(y), this.pts2units(x + width), this.pts2units(y), this.pts2units(height), this._currentColor);
    }

    public void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 37: {
                if (horz) {
                    float h3 = h / 3.0f;
                    float ym1 = y1;
                    float ym2 = ym1 + h3 + h3;
                    this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1), this.pts2units(x2), this.pts2units(ym1), this.pts2units(h3), col);
                    this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym2), this.pts2units(x2), this.pts2units(ym2), this.pts2units(h3), col);
                    break;
                }
                float w3 = w / 3.0f;
                float xm1 = x1;
                float xm2 = xm1 + w3 + w3;
                this._afpDataStream.createLine(this.pts2units(xm1), this.pts2units(y1), this.pts2units(xm1), this.pts2units(y2), this.pts2units(w3), col);
                this._afpDataStream.createLine(this.pts2units(xm2), this.pts2units(y1), this.pts2units(xm2), this.pts2units(y2), this.pts2units(w3), col);
                break;
            }
            case 31: {
                if (horz) {
                    float w2 = 2.0f * h;
                    while (x1 + w2 < x2) {
                        this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1 + w2), this.pts2units(y1), this.pts2units(h), col);
                        x1 += 2.0f * w2;
                    }
                } else {
                    float h2 = 2.0f * w;
                    while (y1 + h2 < y2) {
                        this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1), this.pts2units(y1 + h2), this.pts2units(w), col);
                        y1 += 2.0f * h2;
                    }
                }
                break;
            }
            case 36: {
                if (horz) {
                    while (x1 + h < x2) {
                        this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1 + h), this.pts2units(y1), this.pts2units(h), col);
                        x1 += 2.0f * h;
                    }
                } else {
                    while (y1 + w < y2) {
                        this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1), this.pts2units(y1 + w), this.pts2units(w), col);
                        y1 += 2.0f * w;
                    }
                }
                break;
            }
            case 55: 
            case 119: {
                float colFactor;
                float f = colFactor = style == 55 ? 0.4f : -0.4f;
                if (horz) {
                    Color uppercol = AFPRenderer.lightenColor(col, -colFactor);
                    Color lowercol = AFPRenderer.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    float ym1 = y1;
                    this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1), this.pts2units(x2), this.pts2units(ym1), this.pts2units(h3), uppercol);
                    this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1 + h3), this.pts2units(x2), this.pts2units(ym1 + h3), this.pts2units(h3), col);
                    this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1 + h3 + h3), this.pts2units(x2), this.pts2units(ym1 + h3 + h3), this.pts2units(h3), lowercol);
                    break;
                }
                Color leftcol = AFPRenderer.lightenColor(col, -colFactor);
                Color rightcol = AFPRenderer.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                this._afpDataStream.createLine(this.pts2units(xm1), this.pts2units(y1), this.pts2units(xm1), this.pts2units(y2), this.pts2units(w3), leftcol);
                this._afpDataStream.createLine(this.pts2units(xm1 + w3), this.pts2units(y1), this.pts2units(xm1 + w3), this.pts2units(y2), this.pts2units(w3), col);
                this._afpDataStream.createLine(this.pts2units(xm1 + w3 + w3), this.pts2units(y1), this.pts2units(xm1 + w3 + w3), this.pts2units(y2), this.pts2units(w3), rightcol);
                break;
            }
            case 57: {
                break;
            }
            default: {
                this._afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(horz ? x2 : x1), this.pts2units(horz ? y1 : y2), this.pts2units(Math.abs(horz ? y2 - y1 : x2 - x1)), col);
            }
        }
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("afpGrayscale", new Boolean(!this.colorImages));
        return context;
    }

    public void drawImage(String url, Rectangle2D pos, Map foreignAttributes) {
        String name = null;
        if (this._pageSegmentsMap != null) {
            name = (String)this._pageSegmentsMap.get(url);
        }
        if (name != null) {
            int x = this.mpts2units(pos.getX() + (double)this.currentIPPosition);
            int y = this.mpts2units(pos.getY() + (double)this.currentBPPosition);
            this._afpDataStream.createIncludePageSegment(name, x, y);
        } else {
            url = ImageFactory.getURL(url);
            ImageFactory fact = this.userAgent.getFactory().getImageFactory();
            FopImage fopimage = fact.getImage(url, this.userAgent);
            if (fopimage == null) {
                return;
            }
            if (!fopimage.load(1)) {
                return;
            }
            String mime = fopimage.getMimeType();
            if ("text/xml".equals(mime) || "image/svg+xml".equals(mime)) {
                if (!fopimage.load(2)) {
                    return;
                }
                Document doc = ((XMLImage)fopimage).getDocument();
                String ns = ((XMLImage)fopimage).getNameSpace();
                this.renderDocument(doc, ns, pos, foreignAttributes);
            } else if ("application/postscript".equals(mime)) {
                log.warn("EPS images are not supported by this renderer");
            } else if ("image/tiff".equals(mime) && fopimage instanceof TIFFImage) {
                TIFFImage tiffImage = (TIFFImage)fopimage;
                int x = this.mpts2units(pos.getX() + (double)this.currentIPPosition);
                int y = this.mpts2units(pos.getY() + (double)this.currentBPPosition);
                int w = this.mpts2units(pos.getWidth());
                int h = this.mpts2units(pos.getHeight());
                ImageObject io = this._afpDataStream.getImageObject(x, y, w, h);
                io.setImageParameters((int)(fopimage.getHorizontalResolution() * 10.0), (int)(fopimage.getVerticalResolution() * 10.0), fopimage.getWidth(), fopimage.getHeight());
                if (tiffImage.getStripCount() == 1) {
                    int comp = tiffImage.getCompression();
                    if (comp == 3) {
                        if (!fopimage.load(2)) {
                            return;
                        }
                        io.setImageEncoding((byte)-127);
                        io.setImageData(fopimage.getRessourceBytes());
                    } else if (comp == 4) {
                        if (!fopimage.load(2)) {
                            return;
                        }
                        io.setImageEncoding((byte)-126);
                        io.setImageData(fopimage.getRessourceBytes());
                    } else {
                        if (!fopimage.load(4)) {
                            return;
                        }
                        this.convertToGrayScaleImage(io, fopimage.getBitmaps(), fopimage.getWidth(), fopimage.getHeight());
                    }
                } else {
                    if (!fopimage.load(4)) {
                        return;
                    }
                    this.convertToGrayScaleImage(io, fopimage.getBitmaps(), fopimage.getWidth(), fopimage.getHeight());
                }
            } else {
                if (!fopimage.load(4)) {
                    return;
                }
                fact.releaseImage(url, this.userAgent);
                int x = this.mpts2units(pos.getX() + (double)this.currentIPPosition);
                int y = this.mpts2units(pos.getY() + (double)this.currentBPPosition);
                int w = this.mpts2units(pos.getWidth());
                int h = this.mpts2units(pos.getHeight());
                ImageObject io = this._afpDataStream.getImageObject(x, y, w, h);
                io.setImageParameters((int)(fopimage.getHorizontalResolution() * 10.0), (int)(fopimage.getVerticalResolution() * 10.0), fopimage.getWidth(), fopimage.getHeight());
                if (this.colorImages) {
                    io.setImageIDESize((byte)24);
                    io.setImageData(fopimage.getBitmaps());
                } else {
                    this.convertToGrayScaleImage(io, fopimage.getBitmaps(), fopimage.getWidth(), fopimage.getHeight());
                }
            }
        }
    }

    public static void writeImage(BufferedImage img, OutputStream out) throws IOException {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] tmpMap = img.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int p = tmpMap[i * w + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                out.write((byte)(r & 0xFF));
                out.write((byte)(g & 0xFF));
                out.write((byte)(b & 0xFF));
            }
        }
    }

    public void drawBufferedImage(BufferedImage bi, int resolution, int x, int y, int w, int h) {
        int afpx = this.mpts2units(x);
        int afpy = this.mpts2units(y);
        int afpw = this.mpts2units(w);
        int afph = this.mpts2units(h);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        try {
            AFPRenderer.writeImage(bi, (OutputStream)baout);
            byte[] buf = baout.toByteArray();
            ImageObject io = this._afpDataStream.getImageObject(afpx, afpy, afpw, afph);
            io.setImageParameters(resolution, resolution, bi.getWidth(), bi.getHeight());
            if (this.colorImages) {
                io.setImageIDESize((byte)24);
                io.setImageData(buf);
            } else {
                this.convertToGrayScaleImage(io, buf, bi.getWidth(), bi.getHeight());
            }
        }
        catch (IOException ioe) {
            log.error("Error while serializing bitmap: " + ioe.getMessage(), ioe);
        }
    }

    public void updateColor(Color col, boolean fill) {
        if (fill) {
            this._currentColor = col;
        }
    }

    public void restoreStateStackAfterBreakOut(List breakOutList) {
    }

    public List breakOutOfStateStack() {
        return null;
    }

    public void saveGraphicsState() {
    }

    public void restoreGraphicsState() {
    }

    public void beginTextObject() {
    }

    public void endTextObject() {
    }

    public void renderImage(Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.drawImage(url, pos);
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        String name = this.getInternalFontNameForArea(text);
        this._currentFontSize = (Integer)text.getTrait(Trait.FONT_SIZE);
        AFPFont tf = (AFPFont)this.fontInfo.getFonts().get(name);
        Color col = (Color)text.getTrait(Trait.COLOR);
        int vsci = this.mpts2units(tf.getWidth(32, this._currentFontSize) / 1000 + text.getTextWordSpaceAdjust() + text.getTextLetterSpaceAdjust());
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        String worddata = text.getText();
        AFPFontAttributes afpFontAttributes = new AFPFontAttributes(name, tf, this._currentFontSize);
        if (!this._currentPageFonts.containsKey(afpFontAttributes.getFontKey())) {
            ++this._pageFontCounter;
            afpFontAttributes.setFontReference(this._pageFontCounter);
            this._currentPageFonts.put(afpFontAttributes.getFontKey(), afpFontAttributes);
        } else {
            afpFontAttributes = (AFPFontAttributes)this._currentPageFonts.get(afpFontAttributes.getFontKey());
        }
        String encoding = null;
        try {
            encoding = tf.getCharacterSet(this._currentFontSize).getEncoding();
        }
        catch (Throwable ex) {
            encoding = "Cp1146";
            log.warn("renderText():: Error getting encoding for font  - using default encoding " + encoding);
        }
        try {
            this._afpDataStream.createText(afpFontAttributes.getFontReference(), this.mpts2units(rx), this.mpts2units(bl), col, vsci, this.mpts2units(text.getTextLetterSpaceAdjust()), worddata.getBytes(encoding));
        }
        catch (UnsupportedEncodingException usee) {
            log.error("renderText:: Font " + afpFontAttributes.getFontKey() + " caused UnsupportedEncodingException");
        }
        super.renderText(text);
        this.renderTextDecoration(tf, this._currentFontSize, text, bl, rx);
    }

    public void renderWord(WordArea word) {
        String name = this.getInternalFontNameForArea(word.getParentArea());
        int size = (Integer)word.getParentArea().getTrait(Trait.FONT_SIZE);
        AFPFont tf = (AFPFont)this.fontInfo.getFonts().get(name);
        String s = word.getWord();
        FontMetrics metrics = this.fontInfo.getMetricsFor(name);
        super.renderWord(word);
    }

    public void renderSpace(SpaceArea space) {
        String name = this.getInternalFontNameForArea(space.getParentArea());
        int size = (Integer)space.getParentArea().getTrait(Trait.FONT_SIZE);
        AFPFont tf = (AFPFont)this.fontInfo.getFonts().get(name);
        String s = space.getSpace();
        FontMetrics metrics = this.fontInfo.getMetricsFor(name);
        super.renderSpace(space);
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        switch (style) {
            case 31: 
            case 36: 
            case 37: 
            case 55: 
            case 119: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        super.renderLeader(area);
    }

    public void setOptions(Map options) {
        this._afpOptions = options;
    }

    private int getOrientation(String orientationString) {
        int orientation = 0;
        if (orientationString != null && orientationString.length() > 0) {
            try {
                orientation = Integer.parseInt(orientationString);
            }
            catch (NumberFormatException nfe) {
                log.error("Cannot use orientation of " + orientation + " defaulting to zero.");
                orientation = 0;
            }
        } else {
            orientation = 0;
        }
        switch (orientation) {
            case 0: {
                break;
            }
            case 90: {
                break;
            }
            case 180: {
                break;
            }
            case 270: {
                break;
            }
            default: {
                log.error("Cannot use orientation of " + orientation + " defaulting to zero.");
                orientation = 0;
            }
        }
        return orientation;
    }

    public void setPortraitRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The portrait rotation must be one of the values 0, 90, 180, 270");
        }
        this._portraitRotation = rotation;
    }

    public void setLandscapeRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The landscape rotation must be one of the values 0, 90, 180, 270");
        }
        this._landscapeRotation = rotation;
    }

    public String getMimeType() {
        return "application/x-afp";
    }

    private void renderPageObjectExtensions(PageViewport pageViewport) {
        this._pageSegmentsMap = null;
        if (pageViewport.getExtensionAttachments() != null && pageViewport.getExtensionAttachments().size() > 0) {
            Iterator i = pageViewport.getExtensionAttachments().iterator();
            while (i.hasNext()) {
                String content;
                String name;
                String element;
                ExtensionAttachment attachment = (ExtensionAttachment)i.next();
                if (!"apache:fop:extensions:afp".equals(attachment.getCategory()) || !(attachment instanceof AFPPageSetup)) continue;
                AFPPageSetup aps = (AFPPageSetup)attachment;
                if (log.isDebugEnabled()) {
                    log.debug(aps);
                }
                if ("include-page-overlay".equals(element = aps.getElementName())) {
                    String overlay = aps.getName();
                    if (overlay == null) continue;
                    this._afpDataStream.createIncludePageOverlay(overlay);
                    continue;
                }
                if ("include-page-segment".equals(element)) {
                    name = aps.getName();
                    String source = aps.getValue();
                    if (this._pageSegmentsMap == null) {
                        this._pageSegmentsMap = new HashMap();
                    }
                    this._pageSegmentsMap.put(source, name);
                    continue;
                }
                if ("tag-logical-element".equals(element)) {
                    name = aps.getName();
                    String value = aps.getValue();
                    if (this._pageSegmentsMap == null) {
                        this._pageSegmentsMap = new HashMap();
                    }
                    this._afpDataStream.createTagLogicalElement(name, value);
                    continue;
                }
                if (!"no-operation".equals(element) || (content = aps.getContent()) == null) continue;
                this._afpDataStream.createNoOperation(content);
            }
        }
    }

    private int mpts2units(int mpt) {
        return this.mpts2units((double)mpt);
    }

    private int pts2units(float mpt) {
        return this.mpts2units((double)mpt * 1000.0);
    }

    private int mpts2units(double mpt) {
        return (int)Math.round(mpt / 300.0);
    }

    private void convertToGrayScaleImage(ImageObject io, byte[] raw, int width, int height) {
        int pixelsPerByte = 8 / this.bitsPerPixel;
        int bytewidth = width / pixelsPerByte;
        if (width % pixelsPerByte != 0) {
            ++bytewidth;
        }
        byte[] bw = new byte[height * bytewidth];
        for (int y = 0; y < height; ++y) {
            byte ib = 0;
            int i = 3 * y * width;
            int x = 0;
            while (x < width) {
                double greyVal = 0.212671 * (double)(raw[i] & 0xFF) + 0.71516 * (double)(raw[i + 1] & 0xFF) + 0.072169 * (double)(raw[i + 2] & 0xFF);
                switch (this.bitsPerPixel) {
                    case 1: {
                        if (!(greyVal < 128.0)) break;
                        ib = (byte)(ib | (byte)(1 << 7 - x % 8));
                        break;
                    }
                    case 4: {
                        ib = (byte)(ib | (byte)((byte)(greyVal /= 16.0) << (1 - x % 2) * 4));
                        break;
                    }
                    case 8: {
                        ib = (byte)greyVal;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported bits per pixel: " + this.bitsPerPixel);
                    }
                }
                if (x % pixelsPerByte == pixelsPerByte - 1 || x + 1 == width) {
                    bw[y * bytewidth + x / pixelsPerByte] = ib;
                    ib = 0;
                }
                ++x;
                i += 3;
            }
        }
        io.setImageIDESize((byte)this.bitsPerPixel);
        io.setImageData(bw);
    }

    private void pushViewPortPos(ViewPortPos vpp) {
        this.viewPortPositions.add(vpp);
        this._afpDataStream.setOffsets(vpp.x, vpp.y, vpp.rot);
    }

    private void popViewPortPos() {
        this.viewPortPositions.remove(this.viewPortPositions.size() - 1);
        if (this.viewPortPositions.size() > 0) {
            ViewPortPos vpp = (ViewPortPos)this.viewPortPositions.get(this.viewPortPositions.size() - 1);
            this._afpDataStream.setOffsets(vpp.x, vpp.y, vpp.rot);
        }
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
        switch (bitsPerPixel) {
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                log.warn("Invalid bits_per_pixel value, must be 1, 4 or 8.");
                bitsPerPixel = 8;
            }
        }
    }

    public void setColorImages(boolean colorImages) {
        this.colorImages = colorImages;
    }

    private class ViewPortPos {
        int x = 0;
        int y = 0;
        int rot = 0;

        ViewPortPos() {
        }

        ViewPortPos(Rectangle2D view, CTM ctm) {
            int yOrigin;
            int xOrigin;
            int height;
            int width;
            ViewPortPos currentVP = (ViewPortPos)AFPRenderer.this.viewPortPositions.get(AFPRenderer.this.viewPortPositions.size() - 1);
            switch (currentVP.rot) {
                case 90: {
                    width = AFPRenderer.this.mpts2units(view.getHeight());
                    height = AFPRenderer.this.mpts2units(view.getWidth());
                    xOrigin = AFPRenderer.this._pageWidth - width - AFPRenderer.this.mpts2units(view.getY()) - currentVP.y;
                    yOrigin = AFPRenderer.this.mpts2units(view.getX()) + currentVP.x;
                    break;
                }
                case 180: {
                    width = AFPRenderer.this.mpts2units(view.getWidth());
                    height = AFPRenderer.this.mpts2units(view.getHeight());
                    xOrigin = AFPRenderer.this._pageWidth - width - AFPRenderer.this.mpts2units(view.getX()) - currentVP.x;
                    yOrigin = AFPRenderer.this._pageHeight - height - AFPRenderer.this.mpts2units(view.getY()) - currentVP.y;
                    break;
                }
                case 270: {
                    width = AFPRenderer.this.mpts2units(view.getHeight());
                    height = AFPRenderer.this.mpts2units(view.getWidth());
                    xOrigin = AFPRenderer.this.mpts2units(view.getY()) + currentVP.y;
                    yOrigin = AFPRenderer.this._pageHeight - height - AFPRenderer.this.mpts2units(view.getX()) - currentVP.x;
                    break;
                }
                default: {
                    xOrigin = AFPRenderer.this.mpts2units(view.getX()) + currentVP.x;
                    yOrigin = AFPRenderer.this.mpts2units(view.getY()) + currentVP.y;
                    width = AFPRenderer.this.mpts2units(view.getWidth());
                    height = AFPRenderer.this.mpts2units(view.getHeight());
                }
            }
            this.rot = currentVP.rot;
            double[] ctmf = ctm.toArray();
            if (ctmf[0] == 0.0 && ctmf[1] == -1.0 && ctmf[2] == 1.0 && ctmf[3] == 0.0) {
                this.rot += 270;
            } else if (ctmf[0] == -1.0 && ctmf[1] == 0.0 && ctmf[2] == 0.0 && ctmf[3] == -1.0) {
                this.rot += 180;
            } else if (ctmf[0] == 0.0 && ctmf[1] == 1.0 && ctmf[2] == -1.0 && ctmf[3] == 0.0) {
                this.rot += 90;
            }
            this.rot %= 360;
            switch (this.rot) {
                case 0: {
                    this.x = xOrigin;
                    this.y = yOrigin;
                    break;
                }
                case 90: {
                    this.x = yOrigin;
                    this.y = AFPRenderer.this._pageWidth - width - xOrigin;
                    break;
                }
                case 180: {
                    this.x = AFPRenderer.this._pageWidth - width - xOrigin;
                    this.y = AFPRenderer.this._pageHeight - height - yOrigin;
                    break;
                }
                case 270: {
                    this.x = AFPRenderer.this._pageHeight - height - yOrigin;
                    this.y = xOrigin;
                }
            }
        }

        public String toString() {
            return "x:" + this.x + " y:" + this.y + " rot:" + this.rot;
        }
    }
}

