/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.CachedFontInfo;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.apache.fop.render.AbstractRendererConfigurator;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.fop.util.LogUtil;

public class PrintRendererConfigurator
extends AbstractRendererConfigurator
implements RendererConfigurator {
    private static boolean autodetectedFonts = false;
    protected static Log log = LogFactory.getLog(class$org$apache$fop$render$PrintRendererConfigurator == null ? (class$org$apache$fop$render$PrintRendererConfigurator = PrintRendererConfigurator.class$("org.apache.fop.render.PrintRendererConfigurator")) : class$org$apache$fop$render$PrintRendererConfigurator);
    static /* synthetic */ Class class$org$apache$fop$render$PrintRendererConfigurator;

    public PrintRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = this.getRendererConfig(renderer);
        if (cfg == null) {
            return;
        }
        PrintRenderer printRenderer = (PrintRenderer)renderer;
        FontResolver fontResolver = printRenderer.getFontResolver();
        if (fontResolver == null) {
            fontResolver = FontSetup.createMinimalFontResolver();
        }
        FopFactory factory = this.userAgent.getFactory();
        boolean strict = factory.validateUserConfigStrictly();
        FontCache fontCache = factory.getFontCache();
        List fontInfoList = PrintRendererConfigurator.buildFontListFromConfiguration(cfg, this.userAgent.getFontBaseURL(), fontResolver, strict, fontCache);
        if (fontCache != null && fontCache.hasChanged()) {
            fontCache.save();
        }
        printRenderer.addFontList(fontInfoList);
    }

    public static List buildFontListFromConfiguration(Configuration cfg, String fontBaseURL, FontResolver fontResolver, boolean strict, FontCache fontCache) throws FOPException {
        ArrayList<EmbedFontInfo> fontInfoList = new ArrayList<EmbedFontInfo>();
        Configuration fonts = cfg.getChild("fonts");
        if (fonts != null) {
            boolean autodetectFonts;
            long start = 0L;
            if (log.isDebugEnabled()) {
                log.debug("Starting font configuration...");
                start = System.currentTimeMillis();
            }
            boolean bl = autodetectFonts = fonts.getChild("auto-detect", false) != null;
            if (!autodetectedFonts && autodetectFonts) {
                FontFileFinder fontFileFinder = new FontFileFinder();
                if (fontBaseURL != null) {
                    try {
                        File fontBase = FileUtils.toFile((URL)new URL(fontBaseURL));
                        if (fontBase != null) {
                            PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(fontBase.getAbsolutePath()), fontInfoList, fontResolver, fontCache);
                        }
                    }
                    catch (IOException e) {
                        LogUtil.handleException(log, e, strict);
                    }
                }
                try {
                    PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(), fontInfoList, fontResolver, fontCache);
                }
                catch (IOException e) {
                    LogUtil.handleException(log, e, strict);
                }
                autodetectedFonts = true;
            }
            Configuration[] directories = fonts.getChildren("directory");
            for (int i = 0; i < directories.length; ++i) {
                boolean recursive = directories[i].getAttributeAsBoolean("recursive", false);
                String directory = null;
                try {
                    directory = directories[i].getValue();
                }
                catch (ConfigurationException e) {
                    LogUtil.handleException(log, e, strict);
                    continue;
                }
                if (directory == null) {
                    LogUtil.handleException(log, new FOPException("directory defined without value"), strict);
                    continue;
                }
                FontFileFinder fontFileFinder = new FontFileFinder(recursive ? -1 : 1);
                try {
                    PrintRendererConfigurator.addFontInfoListFromFileList(fontFileFinder.find(directory), fontInfoList, fontResolver, fontCache);
                    continue;
                }
                catch (IOException e) {
                    LogUtil.handleException(log, e, strict);
                }
            }
            Configuration[] font = fonts.getChildren("font");
            for (int i = 0; i < font.length; ++i) {
                EmbedFontInfo fontInfo = PrintRendererConfigurator.getFontInfoFromConfiguration(font[i], fontResolver, strict, fontCache);
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
            if (log.isDebugEnabled()) {
                log.debug("Finished font configuration in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        return fontInfoList;
    }

    private static void addFontInfoListFromFileList(List fontFileList, List fontInfoList, FontResolver resolver, FontCache fontCache) {
        Iterator iter = fontFileList.iterator();
        while (iter.hasNext()) {
            FontInfoFinder finder = new FontInfoFinder();
            File fontFile = (File)iter.next();
            EmbedFontInfo fontInfo = finder.find(fontFile, resolver, fontCache);
            if (fontInfo == null) continue;
            fontInfoList.add(fontInfo);
        }
    }

    public static EmbedFontInfo getFontInfoFromConfiguration(Configuration fontCfg, FontResolver fontResolver, boolean strict, FontCache fontCache) throws FOPException {
        int j;
        StreamSource source;
        String metricsUrl = fontCfg.getAttribute("metrics-url", null);
        String embedUrl = fontCfg.getAttribute("embed-url", null);
        if (metricsUrl == null && embedUrl == null) {
            LogUtil.handleError(log, "Font configuration without metric-url or embed-url", strict);
            return null;
        }
        if (embedUrl != null) {
            source = (StreamSource)fontResolver.resolve(embedUrl);
            if (source == null) {
                LogUtil.handleError(log, "Failed to resolve font with embed-url '" + embedUrl + "'", strict);
                return null;
            }
            embedUrl = source.getSystemId();
        }
        if (metricsUrl != null) {
            source = (StreamSource)fontResolver.resolve(metricsUrl);
            if (source == null) {
                LogUtil.handleError(log, "Failed to resolve font with metric-url '" + metricsUrl + "'", strict);
                return null;
            }
            metricsUrl = source.getSystemId();
        }
        boolean useKerning = fontCfg.getAttributeAsBoolean("kerning", true);
        EmbedFontInfo fontInfo = null;
        Configuration[] tripletCfg = fontCfg.getChildren("font-triplet");
        if (tripletCfg.length == 0) {
            LogUtil.handleError(log, "font without font-triplet", strict);
            File fontFile = CachedFontInfo.getFileFromUrls(new String[]{embedUrl, metricsUrl});
            if (fontFile != null) {
                FontInfoFinder finder = new FontInfoFinder();
                return finder.find(fontFile, fontResolver, fontCache);
            }
            return null;
        }
        ArrayList<FontTriplet> tripleList = new ArrayList<FontTriplet>();
        for (j = 0; j < tripletCfg.length; ++j) {
            try {
                String name = tripletCfg[j].getAttribute("name");
                if (name == null) {
                    LogUtil.handleError(log, "font-triplet without name", strict);
                    continue;
                }
                String weightStr = tripletCfg[j].getAttribute("weight");
                if (weightStr == null) {
                    LogUtil.handleError(log, "font-triplet without weight", strict);
                    continue;
                }
                int weight = FontUtil.parseCSS2FontWeight(weightStr);
                String style = tripletCfg[j].getAttribute("style");
                if (style == null) {
                    LogUtil.handleError(log, "font-triplet without style", strict);
                    continue;
                }
                tripleList.add(FontInfo.createFontKey(name, style, weight));
                continue;
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, e, strict);
            }
        }
        fontInfo = new EmbedFontInfo(metricsUrl, useKerning, tripleList, embedUrl);
        if (fontCache != null && !fontCache.containsFont(fontInfo)) {
            fontCache.addFont(fontInfo);
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding font " + fontInfo.getEmbedFile() + ", metric file " + fontInfo.getMetricsFile());
            for (j = 0; j < tripleList.size(); ++j) {
                FontTriplet triplet = (FontTriplet)tripleList.get(j);
                log.debug("  Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight());
            }
        }
        return fontInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

