/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.EmptyGridUnit;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;

public class TableRowIterator {
    public static final int BODY = 0;
    public static final int HEADER = 1;
    public static final int FOOTER = 2;
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$TableRowIterator == null ? (class$org$apache$fop$layoutmgr$table$TableRowIterator = TableRowIterator.class$("org.apache.fop.layoutmgr.table.TableRowIterator")) : class$org$apache$fop$layoutmgr$table$TableRowIterator);
    protected Table table;
    private ColumnSetup columns;
    private int tablePart;
    private List currentRow = new ArrayList();
    private List previousRowsSpanningCells = new ArrayList();
    private int fetchIndex = -1;
    private int pendingRowSpans;
    private List fetchedRows = new ArrayList();
    private int iteratorIndex = 0;
    private ListIterator tablePartIterator = null;
    private ListIterator tablePartChildIterator = null;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableRowIterator;

    public TableRowIterator(Table table, ColumnSetup columns, int tablePart) {
        this.table = table;
        this.columns = columns;
        this.tablePart = tablePart;
        switch (tablePart) {
            case 1: {
                ArrayList<TableBody> bodyList = new ArrayList<TableBody>();
                bodyList.add(table.getTableHeader());
                this.tablePartIterator = bodyList.listIterator();
                break;
            }
            case 2: {
                ArrayList<TableBody> bodyList = new ArrayList<TableBody>();
                bodyList.add(table.getTableFooter());
                this.tablePartIterator = bodyList.listIterator();
                break;
            }
            default: {
                this.tablePartIterator = table.getChildNodes();
            }
        }
    }

    public EffRow[] getNextRowGroup() {
        boolean allFinished;
        EffRow firstRowInGroup = this.getNextRow();
        if (firstRowInGroup == null) {
            return null;
        }
        EffRow lastRowInGroup = firstRowInGroup;
        int lastIndex = lastRowInGroup.getIndex();
        do {
            allFinished = true;
            Iterator iter = lastRowInGroup.getGridUnits().iterator();
            while (iter.hasNext()) {
                GridUnit gu = (GridUnit)iter.next();
                if (gu.isLastGridUnitRowSpan()) continue;
                allFinished = false;
                break;
            }
            lastIndex = lastRowInGroup.getIndex();
            if (allFinished || (lastRowInGroup = this.getNextRow()) != null) continue;
            allFinished = true;
        } while (!allFinished);
        int rowCount = lastIndex - firstRowInGroup.getIndex() + 1;
        EffRow[] rowGroup = new EffRow[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rowGroup[i] = this.getCachedRow(i + firstRowInGroup.getIndex());
        }
        return rowGroup;
    }

    private EffRow getRow(int index) {
        boolean moreRows = true;
        while (moreRows && this.fetchedRows.size() <= index) {
            moreRows = this.prefetchNext();
        }
        return this.getCachedRow(index);
    }

    private EffRow getNextRow() {
        return this.getRow(this.iteratorIndex++);
    }

    public EffRow getPrecedingRow(EffRow row) {
        return this.getRow(row.getIndex() - 1);
    }

    public EffRow getFollowingRow(EffRow row) {
        return this.getRow(row.getIndex() + 1);
    }

    public EffRow getFirstRow() {
        if (this.fetchedRows.size() == 0) {
            this.prefetchNext();
        }
        return this.getCachedRow(0);
    }

    public EffRow getLastRow() {
        while (this.prefetchNext()) {
        }
        return this.getCachedRow(this.fetchedRows.size() - 1);
    }

    private EffRow getCachedRow(int index) {
        if (index < 0 || index >= this.fetchedRows.size()) {
            return null;
        }
        return (EffRow)this.fetchedRows.get(index);
    }

    private boolean prefetchNext() {
        boolean firstInTable = false;
        boolean firstInTablePart = false;
        if (this.tablePartChildIterator != null && !this.tablePartChildIterator.hasNext()) {
            if (this.pendingRowSpans > 0) {
                this.currentRow.clear();
                ++this.fetchIndex;
                EffRow gridUnits = this.buildGridRow(this.currentRow, null);
                log.debug(gridUnits);
                this.fetchedRows.add(gridUnits);
                return true;
            }
            this.tablePartChildIterator = null;
            if (this.fetchedRows.size() > 0) {
                this.getCachedRow(this.fetchedRows.size() - 1).setFlagForAllGridUnits(4, true);
            }
        }
        if (this.tablePartChildIterator == null) {
            if (this.tablePartIterator.hasNext()) {
                this.tablePartChildIterator = ((TableBody)this.tablePartIterator.next()).getChildNodes();
                if (this.fetchedRows.size() == 0) {
                    firstInTable = true;
                }
                firstInTablePart = true;
            } else {
                if (this.fetchedRows.size() > 0) {
                    this.getCachedRow(this.fetchedRows.size() - 1).setFlagForAllGridUnits(4, true);
                    if (this.tablePart == 2 || this.tablePart == 0 && this.table.getTableFooter() == null) {
                        this.getCachedRow(this.fetchedRows.size() - 1).setFlagForAllGridUnits(5, true);
                    }
                }
                return false;
            }
        }
        Object node = this.tablePartChildIterator.next();
        while (node instanceof Marker) {
            node = this.tablePartChildIterator.next();
        }
        this.currentRow.clear();
        ++this.fetchIndex;
        TableRow rowFO = null;
        if (node instanceof TableRow) {
            rowFO = (TableRow)node;
            FONode.FONodeIterator cellIterator = rowFO.getChildNodes();
            while (cellIterator.hasNext()) {
                this.currentRow.add(cellIterator.next());
            }
        } else if (node instanceof TableCell) {
            this.currentRow.add(node);
            if (!((TableCell)node).endsRow()) {
                while (this.tablePartChildIterator.hasNext()) {
                    TableCell cell = (TableCell)this.tablePartChildIterator.next();
                    if (cell.startsRow()) {
                        this.tablePartChildIterator.previous();
                    } else {
                        this.currentRow.add(cell);
                        if (!cell.endsRow()) continue;
                    }
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Illegal class found: " + node.getClass().getName());
        }
        EffRow gridUnits = this.buildGridRow(this.currentRow, rowFO);
        if (firstInTablePart) {
            gridUnits.setFlagForAllGridUnits(3, true);
        }
        if (firstInTable && (this.tablePart == 1 || this.table.getTableHeader() == null) && this.tablePart != 2) {
            gridUnits.setFlagForAllGridUnits(2, true);
        }
        log.debug(gridUnits);
        this.fetchedRows.add(gridUnits);
        return true;
    }

    private void safelySetListItem(List list, int position, Object obj) {
        while (position >= list.size()) {
            list.add(null);
        }
        list.set(position, obj);
    }

    private Object safelyGetListItem(List list, int position) {
        if (position >= list.size()) {
            return null;
        }
        return list.get(position);
    }

    private EffRow buildGridRow(List cells, TableRow rowFO) {
        EffRow row = new EffRow(this.fetchIndex, this.tablePart);
        List gridUnits = row.getGridUnits();
        TableBody bodyFO = null;
        int colnum = 1;
        GridUnit[] horzSpan = null;
        if (this.pendingRowSpans > 0) {
            ListIterator<GridUnit> spanIter = this.previousRowsSpanningCells.listIterator();
            while (spanIter.hasNext()) {
                GridUnit gu = (GridUnit)spanIter.next();
                if (gu != null) {
                    if (gu.getColSpanIndex() == 0) {
                        horzSpan = new GridUnit[gu.getCell().getNumberColumnsSpanned()];
                    }
                    GridUnit newGU = gu.createNextRowSpanningGridUnit();
                    newGU.setRow(rowFO);
                    this.safelySetListItem(gridUnits, colnum - 1, newGU);
                    horzSpan[newGU.getColSpanIndex()] = newGU;
                    if (newGU.isLastGridUnitColSpan()) {
                        newGU.getPrimary().addRow(horzSpan);
                        horzSpan = null;
                    }
                    if (newGU.isLastGridUnitRowSpan()) {
                        spanIter.set(null);
                        --this.pendingRowSpans;
                    } else {
                        spanIter.set(newGU);
                    }
                }
                ++colnum;
            }
        }
        if (this.pendingRowSpans < 0) {
            throw new IllegalStateException("pendingRowSpans must not become negative!");
        }
        colnum = 1;
        ListIterator iter = cells.listIterator();
        while (iter.hasNext()) {
            boolean hasRowSpanningLeft;
            TableCell cell = (TableCell)iter.next();
            colnum = cell.getColumnNumber();
            GridUnit other = (GridUnit)this.safelyGetListItem(gridUnits, colnum - 1);
            if (other != null) {
                String err = "A table-cell (" + cell.getContextInfo() + ") is overlapping with another (" + other.getCell().getContextInfo() + ") in column " + colnum;
                throw new IllegalStateException(err + " (this should have been catched by FO tree validation)");
            }
            TableColumn col = this.columns.getColumn(colnum);
            PrimaryGridUnit gu = new PrimaryGridUnit(cell, col, colnum - 1, this.fetchIndex);
            this.safelySetListItem(gridUnits, colnum - 1, gu);
            boolean bl = hasRowSpanningLeft = !gu.isLastGridUnitRowSpan();
            if (hasRowSpanningLeft) {
                ++this.pendingRowSpans;
                this.safelySetListItem(this.previousRowsSpanningCells, colnum - 1, gu);
            }
            if (gu.hasSpanning()) {
                horzSpan = new GridUnit[cell.getNumberColumnsSpanned()];
                horzSpan[0] = gu;
                for (int j = 1; j < cell.getNumberColumnsSpanned(); ++j) {
                    GridUnit guSpan = new GridUnit(gu, this.columns.getColumn(++colnum), colnum - 1, j);
                    other = (GridUnit)this.safelyGetListItem(gridUnits, colnum - 1);
                    if (other != null) {
                        String err = "A table-cell (" + cell.getContextInfo() + ") is overlapping with another (" + other.getCell().getContextInfo() + ") in column " + colnum;
                        throw new IllegalStateException(err + " (this should have been catched by FO tree validation)");
                    }
                    this.safelySetListItem(gridUnits, colnum - 1, guSpan);
                    if (hasRowSpanningLeft) {
                        ++this.pendingRowSpans;
                        this.safelySetListItem(this.previousRowsSpanningCells, colnum - 1, guSpan);
                    }
                    horzSpan[j] = guSpan;
                }
                gu.addRow(horzSpan);
            }
            if (bodyFO == null) {
                bodyFO = gu.getBody();
            }
            ++colnum;
        }
        this.fillEmptyGridUnits(gridUnits, rowFO, bodyFO);
        this.resolveStartEndBorders(gridUnits);
        return row;
    }

    private void fillEmptyGridUnits(List gridUnits, TableRow row, TableBody body) {
        for (int pos = 1; pos <= gridUnits.size(); ++pos) {
            GridUnit gu = (GridUnit)gridUnits.get(pos - 1);
            if (gu == null) {
                gu = new EmptyGridUnit(row, this.columns.getColumn(pos), body, pos - 1);
                gridUnits.set(pos - 1, gu);
            }
            gu.setFlag(0, pos == 1);
            gu.setFlag(1, pos == gridUnits.size());
        }
    }

    private void resolveStartEndBorders(List gridUnits) {
        for (int pos = 1; pos <= gridUnits.size(); ++pos) {
            int find;
            GridUnit starting = (GridUnit)gridUnits.get(pos - 1);
            if (this.table.isSeparateBorderModel()) {
                starting.assignBorderForSeparateBorderModel();
                continue;
            }
            GridUnit start = null;
            for (find = pos - 1; find >= 1; --find) {
                GridUnit candidate = (GridUnit)gridUnits.get(find - 1);
                if (!candidate.isLastGridUnitColSpan()) continue;
                start = candidate;
                break;
            }
            GridUnit ending = null;
            if (starting.getCell() != null) {
                pos += starting.getCell().getNumberColumnsSpanned() - 1;
            }
            ending = (GridUnit)gridUnits.get(pos - 1);
            GridUnit end = null;
            for (find = pos + 1; find <= gridUnits.size(); ++find) {
                GridUnit candidate = (GridUnit)gridUnits.get(find - 1);
                if (!candidate.isPrimary()) continue;
                end = candidate;
                break;
            }
            starting.resolveBorder(start, 2);
            ending.resolveBorder(end, 3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

