/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.GridUnitPart;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;

class RowPainter {
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$RowPainter == null ? (class$org$apache$fop$layoutmgr$table$RowPainter = RowPainter.class$("org.apache.fop.layoutmgr.table.RowPainter")) : class$org$apache$fop$layoutmgr$table$RowPainter);
    private TableRow rowFO = null;
    private int colCount;
    private int yoffset = 0;
    private int accumulatedBPD = 0;
    private EffRow lastRow = null;
    private LayoutContext layoutContext;
    private int[] firstRow = new int[3];
    private Map[] rowOffsets = new Map[]{new HashMap(), new HashMap(), new HashMap()};
    private PrimaryGridUnit[] primaryGridUnits;
    private int[] start;
    private int[] end;
    private int[] partBPD;
    private TableContentLayoutManager tclm;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$RowPainter;

    public RowPainter(TableContentLayoutManager tclm, LayoutContext layoutContext) {
        this.tclm = tclm;
        this.layoutContext = layoutContext;
        this.colCount = tclm.getColumns().getColumnCount();
        this.primaryGridUnits = new PrimaryGridUnit[this.colCount];
        this.start = new int[this.colCount];
        this.end = new int[this.colCount];
        this.partBPD = new int[this.colCount];
        Arrays.fill(this.firstRow, -1);
        Arrays.fill(this.end, -1);
    }

    public int getAccumulatedBPD() {
        return this.accumulatedBPD;
    }

    public void handleTableContentPosition(TableContentPosition tcpos) {
        if (this.lastRow != tcpos.row && this.lastRow != null) {
            this.addAreasAndFlushRow(false);
        }
        if (log.isDebugEnabled()) {
            log.debug("===handleTableContentPosition(" + tcpos);
        }
        this.rowFO = tcpos.row.getTableRow();
        this.lastRow = tcpos.row;
        Iterator partIter = tcpos.gridUnitParts.iterator();
        while (partIter.hasNext()) {
            int colIndex;
            GridUnitPart gup = (GridUnitPart)partIter.next();
            if (log.isDebugEnabled()) {
                log.debug(">" + gup);
            }
            if (this.primaryGridUnits[colIndex = gup.pgu.getStartCol()] != gup.pgu) {
                if (this.primaryGridUnits[colIndex] != null) {
                    log.warn("Replacing GU in slot " + colIndex + ". Some content may not be painted.");
                }
                this.primaryGridUnits[colIndex] = gup.pgu;
                this.start[colIndex] = gup.start;
                this.end[colIndex] = gup.end;
                continue;
            }
            if (gup.end < this.end[colIndex]) {
                throw new IllegalStateException("Internal Error: stepper problem");
            }
            this.end[colIndex] = gup.end;
        }
    }

    public int addAreasAndFlushRow(boolean forcedFlush) {
        int i;
        int actualRowHeight = 0;
        int bt = this.lastRow.getBodyType();
        if (log.isDebugEnabled()) {
            log.debug("Remembering yoffset for row " + this.lastRow.getIndex() + ": " + this.yoffset);
        }
        this.rowOffsets[bt].put(new Integer(this.lastRow.getIndex()), new Integer(this.yoffset));
        for (i = 0; i < this.primaryGridUnits.length; ++i) {
            if (this.primaryGridUnits[i] == null || !forcedFlush && this.end[i] != this.primaryGridUnits[i].getElements().size() - 1) continue;
            actualRowHeight = Math.max(actualRowHeight, this.computeSpanHeight(this.primaryGridUnits[i], this.start[i], this.end[i], i, bt));
        }
        this.tclm.addRowBackgroundArea(this.rowFO, actualRowHeight += 2 * this.tclm.getTableLM().getHalfBorderSeparationBPD(), this.layoutContext.getRefIPD(), this.yoffset);
        for (i = 0; i < this.primaryGridUnits.length; ++i) {
            GridUnit currentGU = this.lastRow.safelyGetGridUnit(i);
            if (this.primaryGridUnits[i] != null) {
                if (!forcedFlush && (this.end[i] != this.primaryGridUnits[i].getElements().size() - 1 || currentGU != null && !currentGU.isLastGridUnitRowSpan())) continue;
                this.addAreasForCell(this.primaryGridUnits[i], this.start[i], this.end[i], this.lastRow, this.partBPD[i], actualRowHeight);
                this.primaryGridUnits[i] = null;
                this.start[i] = 0;
                this.end[i] = -1;
                this.partBPD[i] = 0;
                continue;
            }
            if (currentGU == null || currentGU.isEmpty() || currentGU.getColSpanIndex() != 0 || !forcedFlush && !currentGU.isLastGridUnitRowSpan()) continue;
            this.addAreasForCell(currentGU.getPrimary(), this.start[i], this.end[i], this.lastRow, this.partBPD[i], actualRowHeight);
            this.start[i] = 0;
            this.end[i] = -1;
            this.partBPD[i] = 0;
        }
        this.yoffset += actualRowHeight;
        this.accumulatedBPD += actualRowHeight;
        if (forcedFlush) {
            this.lastRow = null;
        }
        return actualRowHeight;
    }

    private int computeSpanHeight(PrimaryGridUnit pgu, int start, int end, int columnIndex, int bodyType) {
        int actualStart;
        if (log.isTraceEnabled()) {
            log.trace("getting len for " + columnIndex + " " + start + "-" + end);
        }
        for (actualStart = start; actualStart <= end && !((KnuthElement)pgu.getElements().get(actualStart)).isBox(); ++actualStart) {
        }
        int len = ElementListUtils.calcContentLength(pgu.getElements(), actualStart, end);
        KnuthElement el = (KnuthElement)pgu.getElements().get(end);
        if (el.isPenalty()) {
            len += el.getW();
        }
        this.partBPD[columnIndex] = len;
        if (log.isTraceEnabled()) {
            log.trace("len of part: " + len);
        }
        if (start == 0) {
            int opt;
            int min;
            LengthRangeProperty bpd = pgu.getCell().getBlockProgressionDimension();
            if (!bpd.getMinimum(this.tclm.getTableLM()).isAuto() && (min = bpd.getMinimum(this.tclm.getTableLM()).getLength().getValue(this.tclm.getTableLM())) > 0) {
                len = Math.max(len, min);
            }
            if (!bpd.getOptimum(this.tclm.getTableLM()).isAuto() && (opt = bpd.getOptimum(this.tclm.getTableLM()).getLength().getValue(this.tclm.getTableLM())) > 0) {
                len = Math.max(len, opt);
            }
            if (pgu.getRow() != null && !(bpd = pgu.getRow().getBlockProgressionDimension()).getMinimum(this.tclm.getTableLM()).isAuto() && (min = bpd.getMinimum(this.tclm.getTableLM()).getLength().getValue(this.tclm.getTableLM())) > 0) {
                len = Math.max(len, min);
            }
        }
        len += pgu.getBorders().getPaddingBefore(false, pgu.getCellLM());
        len += pgu.getBorders().getPaddingAfter(false, pgu.getCellLM());
        if (this.tclm.isSeparateBorderModel()) {
            len += pgu.getBorders().getBorderBeforeWidth(false);
            len += pgu.getBorders().getBorderAfterWidth(false);
        } else {
            len += pgu.getHalfMaxBeforeBorderWidth();
            len += pgu.getHalfMaxAfterBorderWidth();
        }
        int startRow = Math.max(pgu.getStartRow(), this.firstRow[bodyType]);
        Integer storedOffset = (Integer)this.rowOffsets[bodyType].get(new Integer(startRow));
        int effYOffset = storedOffset != null ? storedOffset : this.yoffset;
        return len -= this.yoffset - effYOffset;
    }

    private void addAreasForCell(PrimaryGridUnit pgu, int startPos, int endPos, EffRow row, int contentHeight, int rowHeight) {
        int bt = row.getBodyType();
        if (this.firstRow[bt] < 0) {
            this.firstRow[bt] = row.getIndex();
        }
        int startRowIndex = Math.max(pgu.getStartRow(), this.firstRow[bt]);
        int lastRowIndex = this.lastRow.getIndex();
        int[] spannedGridRowHeights = null;
        if (!this.tclm.getTableLM().getTable().isSeparateBorderModel() && pgu.hasSpanning()) {
            spannedGridRowHeights = new int[lastRowIndex - startRowIndex + 1];
            int prevOffset = (Integer)this.rowOffsets[bt].get(new Integer(startRowIndex));
            for (int i = 0; i < lastRowIndex - startRowIndex; ++i) {
                int newOffset = (Integer)this.rowOffsets[bt].get(new Integer(startRowIndex + i + 1));
                spannedGridRowHeights[i] = newOffset - prevOffset;
                prevOffset = newOffset;
            }
            spannedGridRowHeights[lastRowIndex - startRowIndex] = rowHeight;
        }
        Integer offset = (Integer)this.rowOffsets[bt].get(new Integer(startRowIndex));
        while (offset == null) {
            offset = (Integer)this.rowOffsets[bt].get(new Integer(--startRowIndex));
        }
        int effYOffset = offset;
        int effCellHeight = rowHeight;
        effCellHeight += this.yoffset - effYOffset;
        if (log.isDebugEnabled()) {
            log.debug("Creating area for cell:");
            log.debug("  current row: " + row.getIndex());
            log.debug("  start row: " + pgu.getStartRow() + " " + this.yoffset + " " + effYOffset);
            log.debug("  contentHeight: " + contentHeight + " rowHeight=" + rowHeight + " effCellHeight=" + effCellHeight);
        }
        TableCellLayoutManager cellLM = pgu.getCellLM();
        cellLM.setXOffset(this.tclm.getXOffsetOfGridUnit(pgu));
        cellLM.setYOffset(effYOffset);
        cellLM.setContentHeight(contentHeight);
        cellLM.setRowHeight(effCellHeight);
        int prevBreak = ElementListUtils.determinePreviousBreak(pgu.getElements(), startPos);
        if (endPos >= 0) {
            SpaceResolver.performConditionalsNotification(pgu.getElements(), startPos, endPos, prevBreak);
        }
        cellLM.addAreas(new KnuthPossPosIter(pgu.getElements(), startPos, endPos + 1), this.layoutContext, spannedGridRowHeights, startRowIndex - pgu.getStartRow(), lastRowIndex - pgu.getStartRow() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

