/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.IDTracker;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreaker;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;

public class PageSequenceLayoutManager
extends AbstractLayoutManager {
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$PageSequenceLayoutManager == null ? (class$org$apache$fop$layoutmgr$PageSequenceLayoutManager = PageSequenceLayoutManager.class$("org.apache.fop.layoutmgr.PageSequenceLayoutManager")) : class$org$apache$fop$layoutmgr$PageSequenceLayoutManager);
    private AreaTreeHandler areaTreeHandler;
    private PageSequence pageSeq;
    private PageProvider pageProvider;
    private IDTracker idTracker;
    private Page curPage;
    private int startPageNum = 0;
    private int currentPageNum = 0;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$PageSequenceLayoutManager;

    public PageSequenceLayoutManager(AreaTreeHandler ath, PageSequence pseq) {
        super(pseq);
        this.areaTreeHandler = ath;
        this.idTracker = ath.getIDTracker();
        this.pageSeq = pseq;
        this.pageProvider = new PageProvider(ath, pseq);
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.areaTreeHandler.getLayoutManagerMaker();
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    protected PageSequence getPageSequence() {
        return this.pageSeq;
    }

    public void activateLayout() {
        this.startPageNum = this.pageSeq.getStartingPageNumber();
        this.currentPageNum = this.startPageNum - 1;
        LineArea title = null;
        if (this.pageSeq.getTitleFO() != null) {
            try {
                ContentLayoutManager clm = this.getLayoutManagerMaker().makeContentLayoutManager(this, this.pageSeq.getTitleFO());
                title = (LineArea)clm.getParentArea(null);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.areaTreeHandler.getAreaTreeModel().startPageSequence(title);
        if (log.isDebugEnabled()) {
            log.debug("Starting layout");
        }
        this.curPage = this.makeNewPage(false, false);
        PageBreaker breaker = new PageBreaker(this);
        int flowBPD = this.getCurrentPV().getBodyRegion().getRemainingBPD();
        breaker.doLayout(flowBPD);
        this.finishPage();
    }

    public void finishPageSequence() {
        if (this.pageSeq.hasId()) {
            this.idTracker.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        this.pageSeq.releasePageSequence();
        String masterReference = this.pageSeq.getMasterReference();
        PageSequenceMaster pageSeqMaster = this.pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(masterReference);
        if (pageSeqMaster != null) {
            pageSeqMaster.reset();
        }
        if (log.isDebugEnabled()) {
            log.debug("Ending layout");
        }
    }

    public Page getCurrentPage() {
        return this.curPage;
    }

    protected void setCurrentPage(Page currentPage) {
        this.curPage = currentPage;
    }

    protected int getCurrentPageNum() {
        return this.currentPageNum;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this;
    }

    public PageViewport getFirstPVWithID(String idref) {
        List list = this.idTracker.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return (PageViewport)list.get(0);
        }
        return null;
    }

    public PageViewport getLastPVWithID(String idref) {
        List list = this.idTracker.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return (PageViewport)list.get(list.size() - 1);
        }
        return null;
    }

    public void addIDToPage(String id) {
        if (id != null && id.length() > 0) {
            this.idTracker.associateIDWithPageViewport(id, this.curPage.getPageViewport());
        }
    }

    public boolean associateLayoutManagerID(String id) {
        if (log.isDebugEnabled()) {
            log.debug("associateLayoutManagerID(" + id + ")");
        }
        if (!this.idTracker.alreadyResolvedID(id)) {
            this.idTracker.signalPendingID(id);
            return false;
        }
        return true;
    }

    public void notifyEndOfLayout(String id) {
        this.idTracker.signalIDProcessed(id);
    }

    public void addUnresolvedArea(String id, Resolvable res) {
        this.curPage.getPageViewport().addUnresolvedIDRef(id, res);
        this.idTracker.addUnresolvedIDRef(id, this.curPage.getPageViewport());
    }

    public RetrieveMarker resolveRetrieveMarker(RetrieveMarker rm) {
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        String name = rm.getRetrieveClassName();
        int pos = rm.getRetrievePosition();
        int boundary = rm.getRetrieveBoundary();
        Marker mark = (Marker)this.getCurrentPV().getMarker(name, pos);
        if (mark == null && boundary != 104) {
            PageViewport pv;
            boolean doc = boundary == 34;
            int seq = areaTreeModel.getPageSequenceCount();
            int page = areaTreeModel.getPageCount(seq) - 1;
            while (page < 0 && doc && seq > 1) {
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
            while (page >= 0 && (mark = (Marker)(pv = areaTreeModel.getPage(seq, page)).getMarker(name, 74)) == null) {
                if (--page >= 0 || !doc || seq <= 1) continue;
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
        }
        if (mark == null) {
            log.debug("found no marker with name: " + name);
            return null;
        }
        rm.bindMarker(mark);
        return rm;
    }

    protected Page makeNewPage(boolean bIsBlank, boolean bIsLast) {
        if (this.curPage != null) {
            this.finishPage();
        }
        ++this.currentPageNum;
        this.curPage = this.pageProvider.getPage(bIsBlank, this.currentPageNum, 0);
        if (log.isDebugEnabled()) {
            log.debug("[" + this.curPage.getPageViewport().getPageNumberString() + (bIsBlank ? "*" : "") + "]");
        }
        this.addIDToPage(this.pageSeq.getId());
        return this.curPage;
    }

    private void layoutSideRegion(int regionID) {
        SideRegion reg = (SideRegion)this.curPage.getSimplePageMaster().getRegion(regionID);
        if (reg == null) {
            return;
        }
        StaticContent sc = this.pageSeq.getStaticContent(reg.getRegionName());
        if (sc == null) {
            return;
        }
        StaticContentLayoutManager lm = this.getLayoutManagerMaker().makeStaticContentLayoutManager(this, sc, reg);
        lm.doLayout();
    }

    private void finishPage() {
        if (log.isTraceEnabled()) {
            this.curPage.getPageViewport().dumpMarkers();
        }
        this.layoutSideRegion(35);
        this.layoutSideRegion(34);
        this.layoutSideRegion(38);
        this.layoutSideRegion(37);
        this.idTracker.tryIDResolution(this.curPage.getPageViewport());
        this.areaTreeHandler.getAreaTreeModel().addPage(this.curPage.getPageViewport());
        if (log.isDebugEnabled()) {
            log.debug("page finished: " + this.curPage.getPageViewport().getPageNumberString() + ", current num: " + this.currentPageNum);
        }
        this.curPage = null;
    }

    public void doForcePageCount(Numeric nextPageSeqInitialPageNumber) {
        int forcePageCount = this.pageSeq.getForcePageCount();
        if (nextPageSeqInitialPageNumber != null && forcePageCount == 9) {
            if (nextPageSeqInitialPageNumber.getEnum() != 0) {
                int nextPageSeqPageNumberType = nextPageSeqInitialPageNumber.getEnum();
                forcePageCount = nextPageSeqPageNumberType == 11 ? 40 : (nextPageSeqPageNumberType == 10 ? 41 : 88);
            } else {
                int nextPageSeqPageStart = nextPageSeqInitialPageNumber.getValue();
                nextPageSeqPageStart = nextPageSeqPageStart > 0 ? nextPageSeqPageStart : 1;
                forcePageCount = nextPageSeqPageStart % 2 == 0 ? 41 : 40;
            }
        }
        if (forcePageCount == 43) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 != 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 99) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 == 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 40) {
            if (this.currentPageNum % 2 != 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 41) {
            if (this.currentPageNum % 2 == 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 88) {
            // empty if block
        }
        if (this.curPage != null) {
            this.finishPage();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

