/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Block;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BalancingColumnBreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageBreaker
extends AbstractBreaker {
    private PageSequenceLayoutManager pslm;
    private boolean firstPart = true;
    private boolean pageBreakHandled;
    private boolean needColumnBalancing;
    private PageProvider pageProvider;
    private Block separatorArea;
    private FlowLayoutManager childFLM = null;
    private StaticContentLayoutManager footnoteSeparatorLM = null;

    public PageBreaker(PageSequenceLayoutManager pslm) {
        this.pslm = pslm;
        this.pageProvider = pslm.getPageProvider();
        this.childFLM = pslm.getLayoutManagerMaker().makeFlowLayoutManager(pslm, pslm.getPageSequence().getMainFlow());
    }

    protected void updateLayoutContext(LayoutContext context) {
        int flowIPD = this.pslm.getCurrentPV().getCurrentSpan().getColumnWidth();
        context.setRefIPD(flowIPD);
    }

    protected LayoutManager getTopLevelLM() {
        return this.pslm;
    }

    protected PageProvider getPageProvider() {
        return this.pslm.getPageProvider();
    }

    protected PageBreakingAlgorithm.PageBreakingLayoutListener getLayoutListener() {
        return new PageBreakingAlgorithm.PageBreakingLayoutListener(){

            public void notifyOverflow(int part, FObj obj) {
                Page p = PageBreaker.this.pageProvider.getPage(false, part, 1);
                RegionBody body = (RegionBody)p.getSimplePageMaster().getRegion(36);
                String err = FONode.decorateWithContextInfo("Content of the region-body on page " + p.getPageViewport().getPageNumberString() + " overflows the available area in block-progression dimension.", obj);
                if (body.getOverflow() == 42) {
                    throw new RuntimeException(err);
                }
                AbstractBreaker.log.warn(err);
            }
        };
    }

    protected int handleSpanChange(LayoutContext childLC, int nextSequenceStartsOn) {
        this.needColumnBalancing = false;
        if (childLC.getNextSpan() != 0) {
            nextSequenceStartsOn = childLC.getNextSpan();
            boolean bl = this.needColumnBalancing = childLC.getNextSpan() == 5;
        }
        if (this.needColumnBalancing) {
            AbstractBreaker.log.debug("Column balancing necessary for the next element list!!!");
        }
        return nextSequenceStartsOn;
    }

    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn) {
        if (!this.firstPart) {
            this.handleBreakTrait(nextSequenceStartsOn);
        }
        this.firstPart = false;
        this.pageBreakHandled = true;
        this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
        return super.getNextBlockList(childLC, nextSequenceStartsOn);
    }

    protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        StaticContent footnoteSeparator;
        AbstractList contentList = null;
        while (!this.childFLM.isFinished() && contentList == null) {
            contentList = this.childFLM.getNextKnuthElements(context, alignment);
        }
        boolean bFootnotesPresent = false;
        if (contentList != null) {
            ListIterator contentListIterator = contentList.listIterator();
            while (contentListIterator.hasNext()) {
                ListElement element = (ListElement)contentListIterator.next();
                if (!(element instanceof KnuthBlockBox) || !((KnuthBlockBox)element).hasAnchors()) continue;
                bFootnotesPresent = true;
                LayoutContext footnoteContext = new LayoutContext(context);
                footnoteContext.setStackLimit(context.getStackLimit());
                footnoteContext.setRefIPD(this.pslm.getCurrentPV().getRegionReference(36).getIPD());
                LinkedList footnoteBodyLMs = ((KnuthBlockBox)element).getFootnoteBodyLMs();
                ListIterator footnoteBodyIterator = footnoteBodyLMs.listIterator();
                while (footnoteBodyIterator.hasNext()) {
                    FootnoteBodyLayoutManager fblm = (FootnoteBodyLayoutManager)footnoteBodyIterator.next();
                    fblm.setParent(this.childFLM);
                    fblm.initialize();
                    ((KnuthBlockBox)element).addElementList(fblm.getNextKnuthElements(footnoteContext, alignment));
                }
            }
        }
        if (bFootnotesPresent && (footnoteSeparator = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator")) != null) {
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(36).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
            this.footnoteSeparatorLength = new MinOptMax(this.separatorArea.getBPD());
        }
        return contentList;
    }

    protected int getCurrentDisplayAlign() {
        return this.pslm.getCurrentPage().getSimplePageMaster().getRegion(36).getDisplayAlign();
    }

    protected boolean hasMoreContent() {
        return !this.childFLM.isFinished();
    }

    protected void addAreas(PositionIterator posIter, LayoutContext context) {
        if (this.footnoteSeparatorLM != null) {
            StaticContent footnoteSeparator = this.pslm.getPageSequence().getStaticContent("xsl-footnote-separator");
            this.separatorArea = new Block();
            this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(36).getIPD());
            this.footnoteSeparatorLM = this.pslm.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, this.separatorArea);
            this.footnoteSeparatorLM.doLayout();
        }
        this.childFLM.addAreas(posIter, context);
    }

    protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        if (this.needColumnBalancing) {
            this.doPhase3WithColumnBalancing(alg, partCount, originalList, effectiveList);
        } else if (!this.hasMoreContent() && this.pslm.getPageSequence().hasPagePositionLast()) {
            this.doPhase3WithLastPage(alg, partCount, originalList, effectiveList);
        } else {
            this.addAreas(alg, partCount, originalList, effectiveList);
        }
    }

    private void doPhase3WithLastPage(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        boolean replaceLastPage;
        int newStartPos;
        int restartPoint = this.pageProvider.getStartingPartIndexForLastPage(partCount);
        if (restartPoint > 0) {
            this.addAreas(alg, restartPoint, originalList, effectiveList);
            AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)alg.getPageBreaks().get(restartPoint - 1);
            newStartPos = pbp.getLeafPos();
            if (newStartPos > 0) {
                this.handleBreakTrait(104);
            }
        } else {
            newStartPos = 0;
        }
        AbstractBreaker.log.debug("Last page handling now!!!");
        AbstractBreaker.log.debug("===================================================");
        AbstractBreaker.log.debug("Restarting at " + restartPoint + ", new start position: " + newStartPos);
        this.pageBreakHandled = true;
        int currentPageNum = this.pslm.getCurrentPageNum();
        this.pageProvider.setStartOfNextElementList(currentPageNum, this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
        this.pageProvider.setLastPageIndex(currentPageNum);
        PageBreakingAlgorithm algRestart = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.getLayoutListener(), alg.getAlignment(), alg.getAlignmentLast(), this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), false, false);
        int iOptPageCount = algRestart.findBreakingPoints(effectiveList, newStartPos, 1.0, true, 0);
        AbstractBreaker.log.debug("restart: iOptPageCount= " + iOptPageCount + " pageBreaks.size()= " + algRestart.getPageBreaks().size());
        boolean bl = replaceLastPage = iOptPageCount <= this.pslm.getCurrentPV().getBodyRegion().getColumnCount();
        if (replaceLastPage) {
            this.pslm.setCurrentPage(this.pageProvider.getPage(false, currentPageNum));
            effectiveList.ignoreAtStart = newStartPos;
            this.addAreas(algRestart, iOptPageCount, originalList, effectiveList);
        } else {
            effectiveList.ignoreAtStart = newStartPos;
            this.addAreas(alg, restartPoint, partCount - restartPoint, originalList, effectiveList);
            this.pageProvider.setLastPageIndex(currentPageNum + 1);
            this.pslm.setCurrentPage(this.pslm.makeNewPage(true, true));
        }
        AbstractBreaker.log.debug("===================================================");
    }

    private void doPhase3WithColumnBalancing(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
        int newStartPos;
        AbstractBreaker.log.debug("Column balancing now!!!");
        AbstractBreaker.log.debug("===================================================");
        int restartPoint = this.pageProvider.getStartingPartIndexForLastPage(partCount);
        if (restartPoint > 0) {
            this.addAreas(alg, restartPoint, originalList, effectiveList);
            AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)alg.getPageBreaks().get(restartPoint - 1);
            newStartPos = pbp.getLeafPos();
            if (newStartPos > 0) {
                this.handleBreakTrait(104);
            }
        } else {
            newStartPos = 0;
        }
        AbstractBreaker.log.debug("Restarting at " + restartPoint + ", new start position: " + newStartPos);
        this.pageBreakHandled = true;
        this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
        BalancingColumnBreakingAlgorithm algRestart = new BalancingColumnBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.getLayoutListener(), this.alignment, 135, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), this.pslm.getCurrentPV().getBodyRegion().getColumnCount());
        int iOptPageCount = algRestart.findBreakingPoints(effectiveList, newStartPos, 1.0, true, 0);
        AbstractBreaker.log.debug("restart: iOptPageCount= " + iOptPageCount + " pageBreaks.size()= " + algRestart.getPageBreaks().size());
        if (iOptPageCount > this.pslm.getCurrentPV().getBodyRegion().getColumnCount()) {
            AbstractBreaker.log.warn("Breaking algorithm produced more columns than are available.");
        }
        effectiveList.ignoreAtStart = newStartPos;
        this.addAreas(algRestart, iOptPageCount, originalList, effectiveList);
        AbstractBreaker.log.debug("===================================================");
    }

    protected void startPart(AbstractBreaker.BlockSequence list, int breakClass) {
        AbstractBreaker.log.debug("startPart() breakClass=" + breakClass);
        if (this.pslm.getCurrentPage() == null) {
            throw new IllegalStateException("curPage must not be null");
        }
        if (!this.pageBreakHandled) {
            if (!this.firstPart) {
                this.handleBreakTrait(breakClass);
            }
            this.pageProvider.setStartOfNextElementList(this.pslm.getCurrentPageNum(), this.pslm.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
        }
        this.pageBreakHandled = false;
        this.firstPart = false;
    }

    protected void handleEmptyContent() {
        this.pslm.getCurrentPV().getPage().fakeNonEmpty();
    }

    protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        if (pbp.footnoteFirstListIndex < pbp.footnoteLastListIndex || pbp.footnoteFirstElementIndex <= pbp.footnoteLastElementIndex) {
            for (int i = pbp.footnoteFirstListIndex; i <= pbp.footnoteLastListIndex; ++i) {
                LinkedList elementList = alg.getFootnoteList(i);
                int firstIndex = i == pbp.footnoteFirstListIndex ? pbp.footnoteFirstElementIndex : 0;
                int lastIndex = i == pbp.footnoteLastListIndex ? pbp.footnoteLastElementIndex : elementList.size() - 1;
                SpaceResolver.performConditionalsNotification(elementList, firstIndex, lastIndex, -1);
                LayoutContext childLC = new LayoutContext(0);
                AreaAdditionUtil.addAreas(null, new KnuthPossPosIter(elementList, firstIndex, lastIndex + 1), childLC);
            }
            Footnote parentArea = this.pslm.getCurrentPV().getBodyRegion().getFootnote();
            int topOffset = this.pslm.getCurrentPV().getBodyRegion().getBPD() - parentArea.getBPD();
            if (this.separatorArea != null) {
                topOffset -= this.separatorArea.getBPD();
            }
            parentArea.setTop(topOffset);
            parentArea.setSeparator(this.separatorArea);
        }
        this.pslm.getCurrentPV().getCurrentSpan().notifyFlowsFinished();
    }

    protected LayoutManager getCurrentChildLM() {
        return this.childFLM;
    }

    protected void observeElementList(List elementList) {
        ElementListObserver.observe(elementList, "breaker", ((PageSequence)this.pslm.getFObj()).getId());
    }

    private void handleBreakTrait(int breakVal) {
        Page curPage = this.pslm.getCurrentPage();
        if (breakVal == 5) {
            curPage.getPageViewport().createSpan(true);
            return;
        }
        if (breakVal == 95) {
            curPage.getPageViewport().createSpan(false);
            return;
        }
        if (breakVal == 28 || breakVal <= 0) {
            PageViewport pv = curPage.getPageViewport();
            boolean forceNewPageWithSpan = false;
            RegionBody rb = (RegionBody)curPage.getSimplePageMaster().getRegion(36);
            if (breakVal < 0 && rb.getColumnCount() > 1 && pv.getCurrentSpan().getColumnCount() == 1) {
                forceNewPageWithSpan = true;
            }
            if (forceNewPageWithSpan) {
                curPage = this.pslm.makeNewPage(false, false);
                curPage.getPageViewport().createSpan(true);
            } else if (pv.getCurrentSpan().hasMoreFlows()) {
                pv.getCurrentSpan().moveToNextFlow();
            } else {
                curPage = this.pslm.makeNewPage(false, false);
            }
            return;
        }
        log.debug("handling break-before after page " + this.pslm.getCurrentPageNum() + " breakVal=" + breakVal);
        if (this.needBlankPageBeforeNew(breakVal)) {
            curPage = this.pslm.makeNewPage(true, false);
        }
        if (this.needNewPage(breakVal)) {
            curPage = this.pslm.makeNewPage(false, false);
        }
    }

    private boolean needBlankPageBeforeNew(int breakVal) {
        if (breakVal == 104 || this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            return false;
        }
        if (this.pslm.getCurrentPageNum() % 2 == 0) {
            return breakVal == 44;
        }
        return breakVal == 100;
    }

    private boolean needNewPage(int breakVal) {
        if (this.pslm.getCurrentPage().getPageViewport().getPage().isEmpty()) {
            if (breakVal == 104) {
                return false;
            }
            if (this.pslm.getCurrentPageNum() % 2 == 0) {
                return breakVal == 100;
            }
            return breakVal == 44;
        }
        return true;
    }
}

