/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.image.codec.util.FileCacheSeekableStream;
import org.apache.xmlgraphics.image.codec.util.MemoryCacheSeekableStream;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public abstract class XmlGraphicsCommonsImage
extends AbstractFopImage {
    private byte[] softMask = null;
    protected SeekableStream seekableInput = null;
    protected CachableRed cr = null;

    public XmlGraphicsCommonsImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
    }

    protected boolean loadDimensions() {
        if (this.seekableInput == null && this.inputStream != null) {
            try {
                this.seekableInput = new FileCacheSeekableStream(this.inputStream);
            }
            catch (IOException ioe) {
                this.seekableInput = new MemoryCacheSeekableStream(this.inputStream);
            }
            try {
                this.bitsPerPixel = 8;
                this.cr = this.decodeImage(this.seekableInput);
                this.height = this.cr.getHeight();
                this.width = this.cr.getWidth();
                this.isTransparent = false;
                this.softMask = null;
                ColorModel cm = this.cr.getColorModel();
                this.height = this.cr.getHeight();
                this.width = this.cr.getWidth();
                this.isTransparent = false;
                this.softMask = null;
                int transparencyType = cm.getTransparency();
                if (cm instanceof IndexColorModel) {
                    if (transparencyType == 2) {
                        IndexColorModel icm = (IndexColorModel)cm;
                        int numColor = icm.getMapSize();
                        byte[] alpha = new byte[numColor];
                        icm.getAlphas(alpha);
                        for (int i = 0; i < numColor; ++i) {
                            if ((alpha[i] & 0xFF) != 0) continue;
                            this.isTransparent = true;
                            int red = icm.getRed(i) & 0xFF;
                            int grn = icm.getGreen(i) & 0xFF;
                            int blu = icm.getBlue(i) & 0xFF;
                            this.transparentColor = new Color(red, grn, blu);
                            break;
                        }
                    }
                } else {
                    this.cr = GraphicsUtil.convertTosRGB(this.cr);
                }
                cm = this.cr.getColorModel();
                if (this.colorSpace == null) {
                    this.colorSpace = cm.getColorSpace();
                }
            }
            catch (IOException ioe) {
                log.error("Error while loading image (Batik): " + ioe.getMessage(), ioe);
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                return false;
            }
        }
        return this.height != -1;
    }

    protected boolean loadBitmap() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    public boolean hasSoftMask() {
        if (this.bitmaps == null && this.raw == null) {
            this.loadImage();
        }
        return this.softMask != null;
    }

    public byte[] getSoftMask() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.softMask;
    }

    protected abstract CachableRed decodeImage(SeekableStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage() {
        if (!this.loadDimensions()) return;
        try {
            try {
                if (this.cr == null) {
                    throw new IllegalStateException("Can't load the bitmaps data without the CachableRed instance");
                }
                ColorModel cm = this.cr.getColorModel();
                if (!this.isTransparent && cm.hasAlpha()) {
                    this.softMask = new byte[this.width * this.height];
                }
                this.bitmaps = new byte[this.width * this.height * 3];
                XmlGraphicsCommonsImage.constructBitmaps(this.cr, this.bitmaps, this.softMask);
            }
            catch (Exception ex) {
                log.error("Error while loading image (Batik): " + ex.getMessage(), ex);
                Object var3_4 = null;
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            IOUtils.closeQuietly((InputStream)this.seekableInput);
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.seekableInput = null;
            this.inputStream = null;
            this.cr = null;
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)this.seekableInput);
        IOUtils.closeQuietly((InputStream)this.inputStream);
        this.seekableInput = null;
        this.inputStream = null;
        this.cr = null;
    }

    private static void constructBitmaps(RenderedImage red, byte[] bitmaps, byte[] softMask) {
        WritableRaster wr = (WritableRaster)red.getData();
        ColorModel cm = red.getColorModel();
        BufferedImage bi = new BufferedImage(cm, wr.createWritableTranslatedChild(0, 0), cm.isAlphaPremultiplied(), null);
        int width = red.getWidth();
        int height = red.getHeight();
        int[] tmpMap = new int[width];
        int idx = 0;
        int sfIdx = 0;
        for (int y = 0; y < height; ++y) {
            int pix;
            int x;
            tmpMap = bi.getRGB(0, y, width, 1, tmpMap, 0, width);
            if (softMask != null) {
                for (x = 0; x < width; ++x) {
                    pix = tmpMap[x];
                    softMask[sfIdx++] = (byte)(pix >>> 24);
                    bitmaps[idx++] = (byte)(pix >>> 16 & 0xFF);
                    bitmaps[idx++] = (byte)(pix >>> 8 & 0xFF);
                    bitmaps[idx++] = (byte)(pix & 0xFF);
                }
                continue;
            }
            for (x = 0; x < width; ++x) {
                pix = tmpMap[x];
                bitmaps[idx++] = (byte)(pix >> 16 & 0xFF);
                bitmaps[idx++] = (byte)(pix >> 8 & 0xFF);
                bitmaps[idx++] = (byte)(pix & 0xFF);
            }
        }
    }
}

