/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.XmlGraphicsCommonsImage;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDirectory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public class TIFFImage
extends XmlGraphicsCommonsImage {
    private int compression = 0;
    private int stripCount = 0;
    private long stripOffset = 0L;
    private long stripLength = 0L;
    private int fillOrder = 1;
    private static byte[] flipTable = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};

    public TIFFImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
    }

    public int getCompression() {
        return this.compression;
    }

    public int getStripCount() {
        return this.stripCount;
    }

    protected CachableRed decodeImage(SeekableStream stream) throws IOException {
        org.apache.xmlgraphics.image.codec.tiff.TIFFImage img = new org.apache.xmlgraphics.image.codec.tiff.TIFFImage(stream, null, 0);
        TIFFDirectory dir = (TIFFDirectory)img.getProperty("tiff_directory");
        TIFFField fld = dir.getField(296);
        int resUnit = fld.getAsInt(0);
        fld = dir.getField(282);
        double xRes = fld.getAsDouble(0);
        fld = dir.getField(283);
        double yRes = fld.getAsDouble(0);
        switch (resUnit) {
            case 2: {
                this.dpiHorizontal = xRes;
                this.dpiVertical = yRes;
                break;
            }
            case 3: {
                this.dpiHorizontal = xRes * (double)2.54f;
                this.dpiVertical = yRes * (double)2.54f;
                break;
            }
            default: {
                log.warn("Cannot determine bitmap resolution. Unimplemented resolution unit: " + resUnit);
            }
        }
        fld = dir.getField(259);
        if (fld != null) {
            this.compression = fld.getAsInt(0);
        }
        if ((fld = dir.getField(258)) != null) {
            this.bitsPerPixel = fld.getAsInt(0);
        }
        this.stripCount = (fld = dir.getField(278)) == null ? 1 : (int)(dir.getFieldAsLong(257) / fld.getAsLong(0));
        fld = dir.getField(266);
        if (fld != null) {
            this.fillOrder = fld.getAsInt(0);
        }
        this.stripOffset = dir.getField(273).getAsLong(0);
        this.stripLength = dir.getField(279).getAsLong(0);
        if (this.bitsPerPixel == 1) {
            this.colorSpace = ColorSpace.getInstance(1003);
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadOriginalData() {
        if (this.loadDimensions()) {
            int i;
            byte[] readBuf;
            block8: {
                readBuf = new byte[(int)this.stripLength];
                this.seekableInput.reset();
                this.seekableInput.skip(this.stripOffset);
                int bytesRead = this.seekableInput.read(readBuf);
                if ((long)bytesRead == this.stripLength) break block8;
                log.error("Error while loading image: length mismatch on read");
                boolean bl = false;
                Object var6_6 = null;
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return bl;
            }
            try {
                if (this.fillOrder == 2) {
                    for (i = 0; i < (int)this.stripLength; i += 1) {
                        readBuf[i] = flipTable[readBuf[i] & 0xFF];
                    }
                }
                this.raw = readBuf;
                i = 1;
                Object var6_7 = null;
            }
            catch (IOException ioe) {
                boolean bl;
                try {
                    log.error("Error while loading image strip 1 (TIFF): ", ioe);
                    bl = false;
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    IOUtils.closeQuietly((InputStream)this.seekableInput);
                    IOUtils.closeQuietly((InputStream)this.inputStream);
                    this.seekableInput = null;
                    this.inputStream = null;
                    this.cr = null;
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)this.seekableInput);
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.seekableInput = null;
                this.inputStream = null;
                this.cr = null;
                return bl;
            }
            IOUtils.closeQuietly((InputStream)this.seekableInput);
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.seekableInput = null;
            this.inputStream = null;
            this.cr = null;
            return i != 0;
        }
        return false;
    }
}

